/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringListCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepInput> {
    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("integerValue").getter(StepInput.getter(StepInput::integerValue)).setter(StepInput.setter(Builder::integerValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValue").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(StepInput.getter(StepInput::stringValue)).setter(StepInput.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final SdkField<List<String>> LIST_OF_STRINGS_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listOfStringsValue").getter(StepInput.getter(StepInput::listOfStringsValue)).setter(StepInput.setter(Builder::listOfStringsValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listOfStringsValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> MAP_OF_STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("mapOfStringValue").getter(StepInput.getter(StepInput::mapOfStringValue)).setter(StepInput.setter(Builder::mapOfStringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapOfStringValue").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_VALUE_FIELD, STRING_VALUE_FIELD, LIST_OF_STRINGS_VALUE_FIELD, MAP_OF_STRING_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("integerValue", INTEGER_VALUE_FIELD);
            this.put("stringValue", STRING_VALUE_FIELD);
            this.put("listOfStringsValue", LIST_OF_STRINGS_VALUE_FIELD);
            this.put("mapOfStringValue", MAP_OF_STRING_VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer integerValue;
    private final String stringValue;
    private final List<String> listOfStringsValue;
    private final Map<String, String> mapOfStringValue;
    private final Type type;

    private StepInput(BuilderImpl builder) {
        this.integerValue = builder.integerValue;
        this.stringValue = builder.stringValue;
        this.listOfStringsValue = builder.listOfStringsValue;
        this.mapOfStringValue = builder.mapOfStringValue;
        this.type = builder.type;
    }

    public final Integer integerValue() {
        return this.integerValue;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final boolean hasListOfStringsValue() {
        return this.listOfStringsValue != null && !(this.listOfStringsValue instanceof SdkAutoConstructList);
    }

    public final List<String> listOfStringsValue() {
        return this.listOfStringsValue;
    }

    public final boolean hasMapOfStringValue() {
        return this.mapOfStringValue != null && !(this.mapOfStringValue instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> mapOfStringValue() {
        return this.mapOfStringValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListOfStringsValue() ? this.listOfStringsValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMapOfStringValue() ? this.mapOfStringValue() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepInput)) {
            return false;
        }
        StepInput other = (StepInput)obj;
        return Objects.equals(this.integerValue(), other.integerValue()) && Objects.equals(this.stringValue(), other.stringValue()) && this.hasListOfStringsValue() == other.hasListOfStringsValue() && Objects.equals(this.listOfStringsValue(), other.listOfStringsValue()) && this.hasMapOfStringValue() == other.hasMapOfStringValue() && Objects.equals(this.mapOfStringValue(), other.mapOfStringValue());
    }

    public final String toString() {
        return ToString.builder((String)"StepInput").add("IntegerValue", (Object)this.integerValue()).add("StringValue", (Object)this.stringValue()).add("ListOfStringsValue", this.hasListOfStringsValue() ? this.listOfStringsValue() : null).add("MapOfStringValue", this.hasMapOfStringValue() ? this.mapOfStringValue() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "integerValue": {
                return Optional.ofNullable(clazz.cast(this.integerValue()));
            }
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "listOfStringsValue": {
                return Optional.ofNullable(clazz.cast(this.listOfStringsValue()));
            }
            case "mapOfStringValue": {
                return Optional.ofNullable(clazz.cast(this.mapOfStringValue()));
            }
        }
        return Optional.empty();
    }

    public static StepInput fromIntegerValue(Integer integerValue) {
        return (StepInput)StepInput.builder().integerValue(integerValue).build();
    }

    public static StepInput fromStringValue(String stringValue) {
        return (StepInput)StepInput.builder().stringValue(stringValue).build();
    }

    public static StepInput fromListOfStringsValue(List<String> listOfStringsValue) {
        return (StepInput)StepInput.builder().listOfStringsValue(listOfStringsValue).build();
    }

    public static StepInput fromMapOfStringValue(Map<String, String> mapOfStringValue) {
        return (StepInput)StepInput.builder().mapOfStringValue(mapOfStringValue).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StepInput, T> g) {
        return obj -> g.apply((StepInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INTEGER_VALUE,
        STRING_VALUE,
        LIST_OF_STRINGS_VALUE,
        MAP_OF_STRING_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Integer integerValue;
        private String stringValue;
        private List<String> listOfStringsValue = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> mapOfStringValue = DefaultSdkAutoConstructMap.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(StepInput model) {
            this.integerValue(model.integerValue);
            this.stringValue(model.stringValue);
            this.listOfStringsValue(model.listOfStringsValue);
            this.mapOfStringValue(model.mapOfStringValue);
        }

        public final Integer getIntegerValue() {
            return this.integerValue;
        }

        public final void setIntegerValue(Integer integerValue) {
            Integer oldValue = this.integerValue;
            this.integerValue = integerValue;
            this.handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
        }

        @Override
        public final Builder integerValue(Integer integerValue) {
            Integer oldValue = this.integerValue;
            this.integerValue = integerValue;
            this.handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final Collection<String> getListOfStringsValue() {
            if (this.listOfStringsValue instanceof SdkAutoConstructList) {
                return null;
            }
            return this.listOfStringsValue;
        }

        public final void setListOfStringsValue(Collection<String> listOfStringsValue) {
            List<String> oldValue = this.listOfStringsValue;
            this.listOfStringsValue = StringListCopier.copy(listOfStringsValue);
            this.handleUnionValueChange(Type.LIST_OF_STRINGS_VALUE, oldValue, this.listOfStringsValue);
        }

        @Override
        public final Builder listOfStringsValue(Collection<String> listOfStringsValue) {
            List<String> oldValue = this.listOfStringsValue;
            this.listOfStringsValue = StringListCopier.copy(listOfStringsValue);
            this.handleUnionValueChange(Type.LIST_OF_STRINGS_VALUE, oldValue, this.listOfStringsValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfStringsValue(String ... listOfStringsValue) {
            this.listOfStringsValue(Arrays.asList(listOfStringsValue));
            return this;
        }

        public final Map<String, String> getMapOfStringValue() {
            if (this.mapOfStringValue instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.mapOfStringValue;
        }

        public final void setMapOfStringValue(Map<String, String> mapOfStringValue) {
            Map<String, String> oldValue = this.mapOfStringValue;
            this.mapOfStringValue = StringMapCopier.copy(mapOfStringValue);
            this.handleUnionValueChange(Type.MAP_OF_STRING_VALUE, oldValue, this.mapOfStringValue);
        }

        @Override
        public final Builder mapOfStringValue(Map<String, String> mapOfStringValue) {
            Map<String, String> oldValue = this.mapOfStringValue;
            this.mapOfStringValue = StringMapCopier.copy(mapOfStringValue);
            this.handleUnionValueChange(Type.MAP_OF_STRING_VALUE, oldValue, this.mapOfStringValue);
            return this;
        }

        public StepInput build() {
            return new StepInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepInput> {
        public Builder integerValue(Integer var1);

        public Builder stringValue(String var1);

        public Builder listOfStringsValue(Collection<String> var1);

        public Builder listOfStringsValue(String ... var1);

        public Builder mapOfStringValue(Map<String, String> var1);
    }
}

