/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhuborchestrator.model.PlatformCommand;
import software.amazon.awssdk.services.migrationhuborchestrator.model.PlatformScriptKey;
import software.amazon.awssdk.services.migrationhuborchestrator.model.RunEnvironment;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepAutomationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepAutomationConfiguration> {
    private static final SdkField<String> SCRIPT_LOCATION_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scriptLocationS3Bucket").getter(StepAutomationConfiguration.getter(StepAutomationConfiguration::scriptLocationS3Bucket)).setter(StepAutomationConfiguration.setter(Builder::scriptLocationS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptLocationS3Bucket").build()}).build();
    private static final SdkField<PlatformScriptKey> SCRIPT_LOCATION_S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scriptLocationS3Key").getter(StepAutomationConfiguration.getter(StepAutomationConfiguration::scriptLocationS3Key)).setter(StepAutomationConfiguration.setter(Builder::scriptLocationS3Key)).constructor(PlatformScriptKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptLocationS3Key").build()}).build();
    private static final SdkField<PlatformCommand> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("command").getter(StepAutomationConfiguration.getter(StepAutomationConfiguration::command)).setter(StepAutomationConfiguration.setter(Builder::command)).constructor(PlatformCommand::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()}).build();
    private static final SdkField<String> RUN_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runEnvironment").getter(StepAutomationConfiguration.getter(StepAutomationConfiguration::runEnvironmentAsString)).setter(StepAutomationConfiguration.setter(Builder::runEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runEnvironment").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetType").getter(StepAutomationConfiguration.getter(StepAutomationConfiguration::targetTypeAsString)).setter(StepAutomationConfiguration.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_LOCATION_S3_BUCKET_FIELD, SCRIPT_LOCATION_S3_KEY_FIELD, COMMAND_FIELD, RUN_ENVIRONMENT_FIELD, TARGET_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("scriptLocationS3Bucket", SCRIPT_LOCATION_S3_BUCKET_FIELD);
            this.put("scriptLocationS3Key", SCRIPT_LOCATION_S3_KEY_FIELD);
            this.put("command", COMMAND_FIELD);
            this.put("runEnvironment", RUN_ENVIRONMENT_FIELD);
            this.put("targetType", TARGET_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String scriptLocationS3Bucket;
    private final PlatformScriptKey scriptLocationS3Key;
    private final PlatformCommand command;
    private final String runEnvironment;
    private final String targetType;

    private StepAutomationConfiguration(BuilderImpl builder) {
        this.scriptLocationS3Bucket = builder.scriptLocationS3Bucket;
        this.scriptLocationS3Key = builder.scriptLocationS3Key;
        this.command = builder.command;
        this.runEnvironment = builder.runEnvironment;
        this.targetType = builder.targetType;
    }

    public final String scriptLocationS3Bucket() {
        return this.scriptLocationS3Bucket;
    }

    public final PlatformScriptKey scriptLocationS3Key() {
        return this.scriptLocationS3Key;
    }

    public final PlatformCommand command() {
        return this.command;
    }

    public final RunEnvironment runEnvironment() {
        return RunEnvironment.fromValue(this.runEnvironment);
    }

    public final String runEnvironmentAsString() {
        return this.runEnvironment;
    }

    public final TargetType targetType() {
        return TargetType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptLocationS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptLocationS3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.runEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepAutomationConfiguration)) {
            return false;
        }
        StepAutomationConfiguration other = (StepAutomationConfiguration)obj;
        return Objects.equals(this.scriptLocationS3Bucket(), other.scriptLocationS3Bucket()) && Objects.equals(this.scriptLocationS3Key(), other.scriptLocationS3Key()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.runEnvironmentAsString(), other.runEnvironmentAsString()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StepAutomationConfiguration").add("ScriptLocationS3Bucket", (Object)this.scriptLocationS3Bucket()).add("ScriptLocationS3Key", (Object)this.scriptLocationS3Key()).add("Command", (Object)this.command()).add("RunEnvironment", (Object)this.runEnvironmentAsString()).add("TargetType", (Object)this.targetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scriptLocationS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.scriptLocationS3Bucket()));
            }
            case "scriptLocationS3Key": {
                return Optional.ofNullable(clazz.cast(this.scriptLocationS3Key()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "runEnvironment": {
                return Optional.ofNullable(clazz.cast(this.runEnvironmentAsString()));
            }
            case "targetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StepAutomationConfiguration, T> g) {
        return obj -> g.apply((StepAutomationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scriptLocationS3Bucket;
        private PlatformScriptKey scriptLocationS3Key;
        private PlatformCommand command;
        private String runEnvironment;
        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(StepAutomationConfiguration model) {
            this.scriptLocationS3Bucket(model.scriptLocationS3Bucket);
            this.scriptLocationS3Key(model.scriptLocationS3Key);
            this.command(model.command);
            this.runEnvironment(model.runEnvironment);
            this.targetType(model.targetType);
        }

        public final String getScriptLocationS3Bucket() {
            return this.scriptLocationS3Bucket;
        }

        public final void setScriptLocationS3Bucket(String scriptLocationS3Bucket) {
            this.scriptLocationS3Bucket = scriptLocationS3Bucket;
        }

        @Override
        public final Builder scriptLocationS3Bucket(String scriptLocationS3Bucket) {
            this.scriptLocationS3Bucket = scriptLocationS3Bucket;
            return this;
        }

        public final PlatformScriptKey.Builder getScriptLocationS3Key() {
            return this.scriptLocationS3Key != null ? this.scriptLocationS3Key.toBuilder() : null;
        }

        public final void setScriptLocationS3Key(PlatformScriptKey.BuilderImpl scriptLocationS3Key) {
            this.scriptLocationS3Key = scriptLocationS3Key != null ? scriptLocationS3Key.build() : null;
        }

        @Override
        public final Builder scriptLocationS3Key(PlatformScriptKey scriptLocationS3Key) {
            this.scriptLocationS3Key = scriptLocationS3Key;
            return this;
        }

        public final PlatformCommand.Builder getCommand() {
            return this.command != null ? this.command.toBuilder() : null;
        }

        public final void setCommand(PlatformCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        @Override
        public final Builder command(PlatformCommand command) {
            this.command = command;
            return this;
        }

        public final String getRunEnvironment() {
            return this.runEnvironment;
        }

        public final void setRunEnvironment(String runEnvironment) {
            this.runEnvironment = runEnvironment;
        }

        @Override
        public final Builder runEnvironment(String runEnvironment) {
            this.runEnvironment = runEnvironment;
            return this;
        }

        @Override
        public final Builder runEnvironment(RunEnvironment runEnvironment) {
            this.runEnvironment(runEnvironment == null ? null : runEnvironment.toString());
            return this;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public StepAutomationConfiguration build() {
            return new StepAutomationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepAutomationConfiguration> {
        public Builder scriptLocationS3Bucket(String var1);

        public Builder scriptLocationS3Key(PlatformScriptKey var1);

        default public Builder scriptLocationS3Key(Consumer<PlatformScriptKey.Builder> scriptLocationS3Key) {
            return this.scriptLocationS3Key((PlatformScriptKey)((PlatformScriptKey.Builder)PlatformScriptKey.builder().applyMutation(scriptLocationS3Key)).build());
        }

        public Builder command(PlatformCommand var1);

        default public Builder command(Consumer<PlatformCommand.Builder> command) {
            return this.command((PlatformCommand)((PlatformCommand.Builder)PlatformCommand.builder().applyMutation(command)).build());
        }

        public Builder runEnvironment(String var1);

        public Builder runEnvironment(RunEnvironment var1);

        public Builder targetType(String var1);

        public Builder targetType(TargetType var1);
    }
}

