/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowStatusEnum;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepInput;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepInputParametersCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringListCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkflowResponse
extends MigrationHubOrchestratorResponse
implements ToCopyableBuilder<Builder, CreateWorkflowResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::id)).setter(CreateWorkflowResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::arn)).setter(CreateWorkflowResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::name)).setter(CreateWorkflowResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::description)).setter(CreateWorkflowResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateId").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::templateId)).setter(CreateWorkflowResponse.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()}).build();
    private static final SdkField<String> ADS_APPLICATION_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adsApplicationConfigurationId").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::adsApplicationConfigurationId)).setter(CreateWorkflowResponse.setter(Builder::adsApplicationConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adsApplicationConfigurationId").build()}).build();
    private static final SdkField<Map<String, StepInput>> WORKFLOW_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("workflowInputs").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::workflowInputs)).setter(CreateWorkflowResponse.setter(Builder::workflowInputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowInputs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STEP_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stepTargets").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::stepTargets)).setter(CreateWorkflowResponse.setter(Builder::stepTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::statusAsString)).setter(CreateWorkflowResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::creationTime)).setter(CreateWorkflowResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::tags)).setter(CreateWorkflowResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TEMPLATE_ID_FIELD, ADS_APPLICATION_CONFIGURATION_ID_FIELD, WORKFLOW_INPUTS_FIELD, STEP_TARGETS_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("templateId", TEMPLATE_ID_FIELD);
            this.put("adsApplicationConfigurationId", ADS_APPLICATION_CONFIGURATION_ID_FIELD);
            this.put("workflowInputs", WORKFLOW_INPUTS_FIELD);
            this.put("stepTargets", STEP_TARGETS_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String id;
    private final String arn;
    private final String name;
    private final String description;
    private final String templateId;
    private final String adsApplicationConfigurationId;
    private final Map<String, StepInput> workflowInputs;
    private final List<String> stepTargets;
    private final String status;
    private final Instant creationTime;
    private final Map<String, String> tags;

    private CreateWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.templateId = builder.templateId;
        this.adsApplicationConfigurationId = builder.adsApplicationConfigurationId;
        this.workflowInputs = builder.workflowInputs;
        this.stepTargets = builder.stepTargets;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final String adsApplicationConfigurationId() {
        return this.adsApplicationConfigurationId;
    }

    public final boolean hasWorkflowInputs() {
        return this.workflowInputs != null && !(this.workflowInputs instanceof SdkAutoConstructMap);
    }

    public final Map<String, StepInput> workflowInputs() {
        return this.workflowInputs;
    }

    public final boolean hasStepTargets() {
        return this.stepTargets != null && !(this.stepTargets instanceof SdkAutoConstructList);
    }

    public final List<String> stepTargets() {
        return this.stepTargets;
    }

    public final MigrationWorkflowStatusEnum status() {
        return MigrationWorkflowStatusEnum.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adsApplicationConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflowInputs() ? this.workflowInputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepTargets() ? this.stepTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowResponse)) {
            return false;
        }
        CreateWorkflowResponse other = (CreateWorkflowResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.adsApplicationConfigurationId(), other.adsApplicationConfigurationId()) && this.hasWorkflowInputs() == other.hasWorkflowInputs() && Objects.equals(this.workflowInputs(), other.workflowInputs()) && this.hasStepTargets() == other.hasStepTargets() && Objects.equals(this.stepTargets(), other.stepTargets()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkflowResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("TemplateId", (Object)this.templateId()).add("AdsApplicationConfigurationId", (Object)this.adsApplicationConfigurationId()).add("WorkflowInputs", (Object)(this.workflowInputs() == null ? null : "*** Sensitive Data Redacted ***")).add("StepTargets", this.hasStepTargets() ? this.stepTargets() : null).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "templateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "adsApplicationConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.adsApplicationConfigurationId()));
            }
            case "workflowInputs": {
                return Optional.ofNullable(clazz.cast(this.workflowInputs()));
            }
            case "stepTargets": {
                return Optional.ofNullable(clazz.cast(this.stepTargets()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowResponse, T> g) {
        return obj -> g.apply((CreateWorkflowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String description;
        private String templateId;
        private String adsApplicationConfigurationId;
        private Map<String, StepInput> workflowInputs = DefaultSdkAutoConstructMap.getInstance();
        private List<String> stepTargets = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Instant creationTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.templateId(model.templateId);
            this.adsApplicationConfigurationId(model.adsApplicationConfigurationId);
            this.workflowInputs(model.workflowInputs);
            this.stepTargets(model.stepTargets);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getAdsApplicationConfigurationId() {
            return this.adsApplicationConfigurationId;
        }

        public final void setAdsApplicationConfigurationId(String adsApplicationConfigurationId) {
            this.adsApplicationConfigurationId = adsApplicationConfigurationId;
        }

        @Override
        public final Builder adsApplicationConfigurationId(String adsApplicationConfigurationId) {
            this.adsApplicationConfigurationId = adsApplicationConfigurationId;
            return this;
        }

        public final Map<String, StepInput.Builder> getWorkflowInputs() {
            Map<String, StepInput.Builder> result = StepInputParametersCopier.copyToBuilder(this.workflowInputs);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setWorkflowInputs(Map<String, StepInput.BuilderImpl> workflowInputs) {
            this.workflowInputs = StepInputParametersCopier.copyFromBuilder(workflowInputs);
        }

        @Override
        public final Builder workflowInputs(Map<String, StepInput> workflowInputs) {
            this.workflowInputs = StepInputParametersCopier.copy(workflowInputs);
            return this;
        }

        public final Collection<String> getStepTargets() {
            if (this.stepTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stepTargets;
        }

        public final void setStepTargets(Collection<String> stepTargets) {
            this.stepTargets = StringListCopier.copy(stepTargets);
        }

        @Override
        public final Builder stepTargets(Collection<String> stepTargets) {
            this.stepTargets = StringListCopier.copy(stepTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepTargets(String ... stepTargets) {
            this.stepTargets(Arrays.asList(stepTargets));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MigrationWorkflowStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateWorkflowResponse build() {
            return new CreateWorkflowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubOrchestratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkflowResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder templateId(String var1);

        public Builder adsApplicationConfigurationId(String var1);

        public Builder workflowInputs(Map<String, StepInput> var1);

        public Builder stepTargets(Collection<String> var1);

        public Builder stepTargets(String ... var1);

        public Builder status(String var1);

        public Builder status(MigrationWorkflowStatusEnum var1);

        public Builder creationTime(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

