/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowStatusEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkflowsRequest
extends MigrationHubOrchestratorRequest
implements ToCopyableBuilder<Builder, ListWorkflowsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::maxResults)).setter(ListWorkflowsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::nextToken)).setter(ListWorkflowsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateId").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::templateId)).setter(ListWorkflowsRequest.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("templateId").build()}).build();
    private static final SdkField<String> ADS_APPLICATION_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adsApplicationConfigurationName").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::adsApplicationConfigurationName)).setter(ListWorkflowsRequest.setter(Builder::adsApplicationConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("adsApplicationConfigurationName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::statusAsString)).setter(ListWorkflowsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ListWorkflowsRequest.getter(ListWorkflowsRequest::name)).setter(ListWorkflowsRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, TEMPLATE_ID_FIELD, ADS_APPLICATION_CONFIGURATION_NAME_FIELD, STATUS_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("templateId", TEMPLATE_ID_FIELD);
            this.put("adsApplicationConfigurationName", ADS_APPLICATION_CONFIGURATION_NAME_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("name", NAME_FIELD);
        }
    });
    private final Integer maxResults;
    private final String nextToken;
    private final String templateId;
    private final String adsApplicationConfigurationName;
    private final String status;
    private final String name;

    private ListWorkflowsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.templateId = builder.templateId;
        this.adsApplicationConfigurationName = builder.adsApplicationConfigurationName;
        this.status = builder.status;
        this.name = builder.name;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final String adsApplicationConfigurationName() {
        return this.adsApplicationConfigurationName;
    }

    public final MigrationWorkflowStatusEnum status() {
        return MigrationWorkflowStatusEnum.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adsApplicationConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowsRequest)) {
            return false;
        }
        ListWorkflowsRequest other = (ListWorkflowsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.adsApplicationConfigurationName(), other.adsApplicationConfigurationName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkflowsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("TemplateId", (Object)this.templateId()).add("AdsApplicationConfigurationName", (Object)this.adsApplicationConfigurationName()).add("Status", (Object)this.statusAsString()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "templateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "adsApplicationConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.adsApplicationConfigurationName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowsRequest, T> g) {
        return obj -> g.apply((ListWorkflowsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String templateId;
        private String adsApplicationConfigurationName;
        private String status;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.templateId(model.templateId);
            this.adsApplicationConfigurationName(model.adsApplicationConfigurationName);
            this.status(model.status);
            this.name(model.name);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getAdsApplicationConfigurationName() {
            return this.adsApplicationConfigurationName;
        }

        public final void setAdsApplicationConfigurationName(String adsApplicationConfigurationName) {
            this.adsApplicationConfigurationName = adsApplicationConfigurationName;
        }

        @Override
        public final Builder adsApplicationConfigurationName(String adsApplicationConfigurationName) {
            this.adsApplicationConfigurationName = adsApplicationConfigurationName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MigrationWorkflowStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListWorkflowsRequest build() {
            return new ListWorkflowsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubOrchestratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkflowsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder templateId(String var1);

        public Builder adsApplicationConfigurationName(String var1);

        public Builder status(String var1);

        public Builder status(MigrationWorkflowStatusEnum var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

