/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhuborchestrator.model.Owner;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowStepSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowStepSummary> {
    private static final SdkField<String> STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepId").getter(WorkflowStepSummary.getter(WorkflowStepSummary::stepId)).setter(WorkflowStepSummary.setter(Builder::stepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(WorkflowStepSummary.getter(WorkflowStepSummary::name)).setter(WorkflowStepSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STEP_ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepActionType").getter(WorkflowStepSummary.getter(WorkflowStepSummary::stepActionTypeAsString)).setter(WorkflowStepSummary.setter(Builder::stepActionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepActionType").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(WorkflowStepSummary.getter(WorkflowStepSummary::ownerAsString)).setter(WorkflowStepSummary.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<List<String>> PREVIOUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("previous").getter(WorkflowStepSummary.getter(WorkflowStepSummary::previous)).setter(WorkflowStepSummary.setter(Builder::previous)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previous").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("next").getter(WorkflowStepSummary.getter(WorkflowStepSummary::next)).setter(WorkflowStepSummary.setter(Builder::next)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WorkflowStepSummary.getter(WorkflowStepSummary::statusAsString)).setter(WorkflowStepSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(WorkflowStepSummary.getter(WorkflowStepSummary::statusMessage)).setter(WorkflowStepSummary.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<Integer> NO_OF_SRV_COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("noOfSrvCompleted").getter(WorkflowStepSummary.getter(WorkflowStepSummary::noOfSrvCompleted)).setter(WorkflowStepSummary.setter(Builder::noOfSrvCompleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noOfSrvCompleted").build()}).build();
    private static final SdkField<Integer> NO_OF_SRV_FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("noOfSrvFailed").getter(WorkflowStepSummary.getter(WorkflowStepSummary::noOfSrvFailed)).setter(WorkflowStepSummary.setter(Builder::noOfSrvFailed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noOfSrvFailed").build()}).build();
    private static final SdkField<Integer> TOTAL_NO_OF_SRV_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalNoOfSrv").getter(WorkflowStepSummary.getter(WorkflowStepSummary::totalNoOfSrv)).setter(WorkflowStepSummary.setter(Builder::totalNoOfSrv)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalNoOfSrv").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(WorkflowStepSummary.getter(WorkflowStepSummary::description)).setter(WorkflowStepSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SCRIPT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scriptLocation").getter(WorkflowStepSummary.getter(WorkflowStepSummary::scriptLocation)).setter(WorkflowStepSummary.setter(Builder::scriptLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_ID_FIELD, NAME_FIELD, STEP_ACTION_TYPE_FIELD, OWNER_FIELD, PREVIOUS_FIELD, NEXT_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, NO_OF_SRV_COMPLETED_FIELD, NO_OF_SRV_FAILED_FIELD, TOTAL_NO_OF_SRV_FIELD, DESCRIPTION_FIELD, SCRIPT_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("stepId", STEP_ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("stepActionType", STEP_ACTION_TYPE_FIELD);
            this.put("owner", OWNER_FIELD);
            this.put("previous", PREVIOUS_FIELD);
            this.put("next", NEXT_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("statusMessage", STATUS_MESSAGE_FIELD);
            this.put("noOfSrvCompleted", NO_OF_SRV_COMPLETED_FIELD);
            this.put("noOfSrvFailed", NO_OF_SRV_FAILED_FIELD);
            this.put("totalNoOfSrv", TOTAL_NO_OF_SRV_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("scriptLocation", SCRIPT_LOCATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String stepId;
    private final String name;
    private final String stepActionType;
    private final String owner;
    private final List<String> previous;
    private final List<String> next;
    private final String status;
    private final String statusMessage;
    private final Integer noOfSrvCompleted;
    private final Integer noOfSrvFailed;
    private final Integer totalNoOfSrv;
    private final String description;
    private final String scriptLocation;

    private WorkflowStepSummary(BuilderImpl builder) {
        this.stepId = builder.stepId;
        this.name = builder.name;
        this.stepActionType = builder.stepActionType;
        this.owner = builder.owner;
        this.previous = builder.previous;
        this.next = builder.next;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.noOfSrvCompleted = builder.noOfSrvCompleted;
        this.noOfSrvFailed = builder.noOfSrvFailed;
        this.totalNoOfSrv = builder.totalNoOfSrv;
        this.description = builder.description;
        this.scriptLocation = builder.scriptLocation;
    }

    public final String stepId() {
        return this.stepId;
    }

    public final String name() {
        return this.name;
    }

    public final StepActionType stepActionType() {
        return StepActionType.fromValue(this.stepActionType);
    }

    public final String stepActionTypeAsString() {
        return this.stepActionType;
    }

    public final Owner owner() {
        return Owner.fromValue(this.owner);
    }

    public final String ownerAsString() {
        return this.owner;
    }

    public final boolean hasPrevious() {
        return this.previous != null && !(this.previous instanceof SdkAutoConstructList);
    }

    public final List<String> previous() {
        return this.previous;
    }

    public final boolean hasNext() {
        return this.next != null && !(this.next instanceof SdkAutoConstructList);
    }

    public final List<String> next() {
        return this.next;
    }

    public final StepStatus status() {
        return StepStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Integer noOfSrvCompleted() {
        return this.noOfSrvCompleted;
    }

    public final Integer noOfSrvFailed() {
        return this.noOfSrvFailed;
    }

    public final Integer totalNoOfSrv() {
        return this.totalNoOfSrv;
    }

    public final String description() {
        return this.description;
    }

    public final String scriptLocation() {
        return this.scriptLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrevious() ? this.previous() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNext() ? this.next() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.noOfSrvCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.noOfSrvFailed());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNoOfSrv());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStepSummary)) {
            return false;
        }
        WorkflowStepSummary other = (WorkflowStepSummary)obj;
        return Objects.equals(this.stepId(), other.stepId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.stepActionTypeAsString(), other.stepActionTypeAsString()) && Objects.equals(this.ownerAsString(), other.ownerAsString()) && this.hasPrevious() == other.hasPrevious() && Objects.equals(this.previous(), other.previous()) && this.hasNext() == other.hasNext() && Objects.equals(this.next(), other.next()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.noOfSrvCompleted(), other.noOfSrvCompleted()) && Objects.equals(this.noOfSrvFailed(), other.noOfSrvFailed()) && Objects.equals(this.totalNoOfSrv(), other.totalNoOfSrv()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.scriptLocation(), other.scriptLocation());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowStepSummary").add("StepId", (Object)this.stepId()).add("Name", (Object)this.name()).add("StepActionType", (Object)this.stepActionTypeAsString()).add("Owner", (Object)this.ownerAsString()).add("Previous", this.hasPrevious() ? this.previous() : null).add("Next", this.hasNext() ? this.next() : null).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("NoOfSrvCompleted", (Object)this.noOfSrvCompleted()).add("NoOfSrvFailed", (Object)this.noOfSrvFailed()).add("TotalNoOfSrv", (Object)this.totalNoOfSrv()).add("Description", (Object)this.description()).add("ScriptLocation", (Object)this.scriptLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stepId": {
                return Optional.ofNullable(clazz.cast(this.stepId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "stepActionType": {
                return Optional.ofNullable(clazz.cast(this.stepActionTypeAsString()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.ownerAsString()));
            }
            case "previous": {
                return Optional.ofNullable(clazz.cast(this.previous()));
            }
            case "next": {
                return Optional.ofNullable(clazz.cast(this.next()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "noOfSrvCompleted": {
                return Optional.ofNullable(clazz.cast(this.noOfSrvCompleted()));
            }
            case "noOfSrvFailed": {
                return Optional.ofNullable(clazz.cast(this.noOfSrvFailed()));
            }
            case "totalNoOfSrv": {
                return Optional.ofNullable(clazz.cast(this.totalNoOfSrv()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "scriptLocation": {
                return Optional.ofNullable(clazz.cast(this.scriptLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStepSummary, T> g) {
        return obj -> g.apply((WorkflowStepSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stepId;
        private String name;
        private String stepActionType;
        private String owner;
        private List<String> previous = DefaultSdkAutoConstructList.getInstance();
        private List<String> next = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusMessage;
        private Integer noOfSrvCompleted;
        private Integer noOfSrvFailed;
        private Integer totalNoOfSrv;
        private String description;
        private String scriptLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStepSummary model) {
            this.stepId(model.stepId);
            this.name(model.name);
            this.stepActionType(model.stepActionType);
            this.owner(model.owner);
            this.previous(model.previous);
            this.next(model.next);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.noOfSrvCompleted(model.noOfSrvCompleted);
            this.noOfSrvFailed(model.noOfSrvFailed);
            this.totalNoOfSrv(model.totalNoOfSrv);
            this.description(model.description);
            this.scriptLocation(model.scriptLocation);
        }

        public final String getStepId() {
            return this.stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStepActionType() {
            return this.stepActionType;
        }

        public final void setStepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
        }

        @Override
        public final Builder stepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
            return this;
        }

        @Override
        public final Builder stepActionType(StepActionType stepActionType) {
            this.stepActionType(stepActionType == null ? null : stepActionType.toString());
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public final Collection<String> getPrevious() {
            if (this.previous instanceof SdkAutoConstructList) {
                return null;
            }
            return this.previous;
        }

        public final void setPrevious(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
        }

        @Override
        public final Builder previous(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previous(String ... previous) {
            this.previous(Arrays.asList(previous));
            return this;
        }

        public final Collection<String> getNext() {
            if (this.next instanceof SdkAutoConstructList) {
                return null;
            }
            return this.next;
        }

        public final void setNext(Collection<String> next) {
            this.next = StringListCopier.copy(next);
        }

        @Override
        public final Builder next(Collection<String> next) {
            this.next = StringListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(String ... next) {
            this.next(Arrays.asList(next));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StepStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Integer getNoOfSrvCompleted() {
            return this.noOfSrvCompleted;
        }

        public final void setNoOfSrvCompleted(Integer noOfSrvCompleted) {
            this.noOfSrvCompleted = noOfSrvCompleted;
        }

        @Override
        public final Builder noOfSrvCompleted(Integer noOfSrvCompleted) {
            this.noOfSrvCompleted = noOfSrvCompleted;
            return this;
        }

        public final Integer getNoOfSrvFailed() {
            return this.noOfSrvFailed;
        }

        public final void setNoOfSrvFailed(Integer noOfSrvFailed) {
            this.noOfSrvFailed = noOfSrvFailed;
        }

        @Override
        public final Builder noOfSrvFailed(Integer noOfSrvFailed) {
            this.noOfSrvFailed = noOfSrvFailed;
            return this;
        }

        public final Integer getTotalNoOfSrv() {
            return this.totalNoOfSrv;
        }

        public final void setTotalNoOfSrv(Integer totalNoOfSrv) {
            this.totalNoOfSrv = totalNoOfSrv;
        }

        @Override
        public final Builder totalNoOfSrv(Integer totalNoOfSrv) {
            this.totalNoOfSrv = totalNoOfSrv;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getScriptLocation() {
            return this.scriptLocation;
        }

        public final void setScriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
        }

        @Override
        public final Builder scriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
            return this;
        }

        public WorkflowStepSummary build() {
            return new WorkflowStepSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowStepSummary> {
        public Builder stepId(String var1);

        public Builder name(String var1);

        public Builder stepActionType(String var1);

        public Builder stepActionType(StepActionType var1);

        public Builder owner(String var1);

        public Builder owner(Owner var1);

        public Builder previous(Collection<String> var1);

        public Builder previous(String ... var1);

        public Builder next(Collection<String> var1);

        public Builder next(String ... var1);

        public Builder status(String var1);

        public Builder status(StepStatus var1);

        public Builder statusMessage(String var1);

        public Builder noOfSrvCompleted(Integer var1);

        public Builder noOfSrvFailed(Integer var1);

        public Builder totalNoOfSrv(Integer var1);

        public Builder description(String var1);

        public Builder scriptLocation(String var1);
    }
}

