/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorClient;
import software.amazon.awssdk.services.migrationhuborchestrator.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepSummary;

public class ListWorkflowStepsIterable
implements SdkIterable<ListWorkflowStepsResponse> {
    private final MigrationHubOrchestratorClient client;
    private final ListWorkflowStepsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowStepsIterable(MigrationHubOrchestratorClient client, ListWorkflowStepsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkflowStepsResponseFetcher();
    }

    public Iterator<ListWorkflowStepsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowStepSummary> workflowStepsSummary() {
        Function<ListWorkflowStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowStepsSummary() != null) {
                return response.workflowStepsSummary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowStepsResponseFetcher
    implements SyncPageFetcher<ListWorkflowStepsResponse> {
        private ListWorkflowStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowStepsResponse nextPage(ListWorkflowStepsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowStepsIterable.this.client.listWorkflowSteps(ListWorkflowStepsIterable.this.firstRequest);
            }
            return ListWorkflowStepsIterable.this.client.listWorkflowSteps((ListWorkflowStepsRequest)((Object)ListWorkflowStepsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

