/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MaxStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowStepOutputUnion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowStepOutputUnion> {
    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("integerValue").getter(WorkflowStepOutputUnion.getter(WorkflowStepOutputUnion::integerValue)).setter(WorkflowStepOutputUnion.setter(Builder::integerValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValue").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(WorkflowStepOutputUnion.getter(WorkflowStepOutputUnion::stringValue)).setter(WorkflowStepOutputUnion.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final SdkField<List<String>> LIST_OF_STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listOfStringValue").getter(WorkflowStepOutputUnion.getter(WorkflowStepOutputUnion::listOfStringValue)).setter(WorkflowStepOutputUnion.setter(Builder::listOfStringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listOfStringValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_VALUE_FIELD, STRING_VALUE_FIELD, LIST_OF_STRING_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer integerValue;
    private final String stringValue;
    private final List<String> listOfStringValue;
    private final Type type;

    private WorkflowStepOutputUnion(BuilderImpl builder) {
        this.integerValue = builder.integerValue;
        this.stringValue = builder.stringValue;
        this.listOfStringValue = builder.listOfStringValue;
        this.type = builder.type;
    }

    public final Integer integerValue() {
        return this.integerValue;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final boolean hasListOfStringValue() {
        return this.listOfStringValue != null && !(this.listOfStringValue instanceof SdkAutoConstructList);
    }

    public final List<String> listOfStringValue() {
        return this.listOfStringValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListOfStringValue() ? this.listOfStringValue() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStepOutputUnion)) {
            return false;
        }
        WorkflowStepOutputUnion other = (WorkflowStepOutputUnion)obj;
        return Objects.equals(this.integerValue(), other.integerValue()) && Objects.equals(this.stringValue(), other.stringValue()) && this.hasListOfStringValue() == other.hasListOfStringValue() && Objects.equals(this.listOfStringValue(), other.listOfStringValue());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowStepOutputUnion").add("IntegerValue", (Object)this.integerValue()).add("StringValue", (Object)this.stringValue()).add("ListOfStringValue", this.hasListOfStringValue() ? this.listOfStringValue() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "integerValue": {
                return Optional.ofNullable(clazz.cast(this.integerValue()));
            }
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "listOfStringValue": {
                return Optional.ofNullable(clazz.cast(this.listOfStringValue()));
            }
        }
        return Optional.empty();
    }

    public static WorkflowStepOutputUnion fromIntegerValue(Integer integerValue) {
        return (WorkflowStepOutputUnion)WorkflowStepOutputUnion.builder().integerValue(integerValue).build();
    }

    public static WorkflowStepOutputUnion fromStringValue(String stringValue) {
        return (WorkflowStepOutputUnion)WorkflowStepOutputUnion.builder().stringValue(stringValue).build();
    }

    public static WorkflowStepOutputUnion fromListOfStringValue(List<String> listOfStringValue) {
        return (WorkflowStepOutputUnion)WorkflowStepOutputUnion.builder().listOfStringValue(listOfStringValue).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStepOutputUnion, T> g) {
        return obj -> g.apply((WorkflowStepOutputUnion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INTEGER_VALUE,
        STRING_VALUE,
        LIST_OF_STRING_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Integer integerValue;
        private String stringValue;
        private List<String> listOfStringValue = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStepOutputUnion model) {
            this.integerValue(model.integerValue);
            this.stringValue(model.stringValue);
            this.listOfStringValue(model.listOfStringValue);
        }

        public final Integer getIntegerValue() {
            return this.integerValue;
        }

        public final void setIntegerValue(Integer integerValue) {
            Integer oldValue = this.integerValue;
            this.integerValue = integerValue;
            this.handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
        }

        @Override
        public final Builder integerValue(Integer integerValue) {
            Integer oldValue = this.integerValue;
            this.integerValue = integerValue;
            this.handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final Collection<String> getListOfStringValue() {
            if (this.listOfStringValue instanceof SdkAutoConstructList) {
                return null;
            }
            return this.listOfStringValue;
        }

        public final void setListOfStringValue(Collection<String> listOfStringValue) {
            List<String> oldValue = this.listOfStringValue;
            this.listOfStringValue = MaxStringListCopier.copy(listOfStringValue);
            this.handleUnionValueChange(Type.LIST_OF_STRING_VALUE, oldValue, this.listOfStringValue);
        }

        @Override
        public final Builder listOfStringValue(Collection<String> listOfStringValue) {
            List<String> oldValue = this.listOfStringValue;
            this.listOfStringValue = MaxStringListCopier.copy(listOfStringValue);
            this.handleUnionValueChange(Type.LIST_OF_STRING_VALUE, oldValue, this.listOfStringValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfStringValue(String ... listOfStringValue) {
            this.listOfStringValue(Arrays.asList(listOfStringValue));
            return this;
        }

        public WorkflowStepOutputUnion build() {
            return new WorkflowStepOutputUnion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowStepOutputUnion> {
        public Builder integerValue(Integer var1);

        public Builder stringValue(String var1);

        public Builder listOfStringValue(Collection<String> var1);

        public Builder listOfStringValue(String ... var1);
    }
}

