/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RunEnvironment {
    AWS("AWS"),
    ONPREMISE("ONPREMISE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RunEnvironment> VALUE_MAP;
    private final String value;

    private RunEnvironment(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RunEnvironment fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RunEnvironment> knownValues() {
        EnumSet<RunEnvironment> knownValues = EnumSet.allOf(RunEnvironment.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RunEnvironment.class, RunEnvironment::toString);
    }
}

