/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTemplateResponse extends MigrationHubOrchestratorResponse implements
        ToCopyableBuilder<GetTemplateResponse.Builder, GetTemplateResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetTemplateResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetTemplateResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetTemplateResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<TemplateInput>> INPUTS_FIELD = SdkField
            .<List<TemplateInput>> builder(MarshallingType.LIST)
            .memberName("inputs")
            .getter(getter(GetTemplateResponse::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TemplateInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(TemplateInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tool>> TOOLS_FIELD = SdkField
            .<List<Tool>> builder(MarshallingType.LIST)
            .memberName("tools")
            .getter(getter(GetTemplateResponse::tools))
            .setter(setter(Builder::tools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tool> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tool::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetTemplateResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetTemplateResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, INPUTS_FIELD, TOOLS_FIELD, STATUS_FIELD, CREATION_TIME_FIELD));

    private final String id;

    private final String name;

    private final String description;

    private final List<TemplateInput> inputs;

    private final List<Tool> tools;

    private final String status;

    private final Instant creationTime;

    private GetTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.inputs = builder.inputs;
        this.tools = builder.tools;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The ID of the template.
     * </p>
     * 
     * @return The ID of the template.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the template.
     * </p>
     * 
     * @return The name of the template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time at which the template was last created.
     * </p>
     * 
     * @return The time at which the template was last created.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inputs provided for the creation of the migration workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The inputs provided for the creation of the migration workflow.
     */
    public final List<TemplateInput> inputs() {
        return inputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tools property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTools() {
        return tools != null && !(tools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of AWS services utilized in a migration workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTools} method.
     * </p>
     * 
     * @return List of AWS services utilized in a migration workflow.
     */
    public final List<Tool> tools() {
        return tools;
    }

    /**
     * <p>
     * The status of the template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the template.
     * @see TemplateStatus
     */
    public final TemplateStatus status() {
        return TemplateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the template.
     * @see TemplateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the template was last created.
     * </p>
     * 
     * @return The time at which the template was last created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTools() ? tools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateResponse)) {
            return false;
        }
        GetTemplateResponse other = (GetTemplateResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && hasTools() == other.hasTools()
                && Objects.equals(tools(), other.tools()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTemplateResponse").add("Id", id()).add("Name", name()).add("Description", description())
                .add("Inputs", hasInputs() ? inputs() : null).add("Tools", hasTools() ? tools() : null)
                .add("Status", statusAsString()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "tools":
            return Optional.ofNullable(clazz.cast(tools()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateResponse, T> g) {
        return obj -> g.apply((GetTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubOrchestratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTemplateResponse> {
        /**
         * <p>
         * The ID of the template.
         * </p>
         * 
         * @param id
         *        The ID of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the template.
         * </p>
         * 
         * @param name
         *        The name of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time at which the template was last created.
         * </p>
         * 
         * @param description
         *        The time at which the template was last created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The inputs provided for the creation of the migration workflow.
         * </p>
         * 
         * @param inputs
         *        The inputs provided for the creation of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<TemplateInput> inputs);

        /**
         * <p>
         * The inputs provided for the creation of the migration workflow.
         * </p>
         * 
         * @param inputs
         *        The inputs provided for the creation of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(TemplateInput... inputs);

        /**
         * <p>
         * The inputs provided for the creation of the migration workflow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateInput.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateInput.Builder#build()} is
         * called immediately and its result is passed to {@link #inputs(List<TemplateInput>)}.
         * 
         * @param inputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputs(java.util.Collection<TemplateInput>)
         */
        Builder inputs(Consumer<TemplateInput.Builder>... inputs);

        /**
         * <p>
         * List of AWS services utilized in a migration workflow.
         * </p>
         * 
         * @param tools
         *        List of AWS services utilized in a migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tools(Collection<Tool> tools);

        /**
         * <p>
         * List of AWS services utilized in a migration workflow.
         * </p>
         * 
         * @param tools
         *        List of AWS services utilized in a migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tools(Tool... tools);

        /**
         * <p>
         * List of AWS services utilized in a migration workflow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.Tool.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.migrationhuborchestrator.model.Tool#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.Tool.Builder#build()} is called
         * immediately and its result is passed to {@link #tools(List<Tool>)}.
         * 
         * @param tools
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhuborchestrator.model.Tool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tools(java.util.Collection<Tool>)
         */
        Builder tools(Consumer<Tool.Builder>... tools);

        /**
         * <p>
         * The status of the template.
         * </p>
         * 
         * @param status
         *        The status of the template.
         * @see TemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the template.
         * </p>
         * 
         * @param status
         *        The status of the template.
         * @see TemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateStatus
         */
        Builder status(TemplateStatus status);

        /**
         * <p>
         * The time at which the template was last created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the template was last created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends MigrationHubOrchestratorResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private List<TemplateInput> inputs = DefaultSdkAutoConstructList.getInstance();

        private List<Tool> tools = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            description(model.description);
            inputs(model.inputs);
            tools(model.tools);
            status(model.status);
            creationTime(model.creationTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<TemplateInput.Builder> getInputs() {
            List<TemplateInput.Builder> result = TemplateInputListCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<TemplateInput.BuilderImpl> inputs) {
            this.inputs = TemplateInputListCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<TemplateInput> inputs) {
            this.inputs = TemplateInputListCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(TemplateInput... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<TemplateInput.Builder>... inputs) {
            inputs(Stream.of(inputs).map(c -> TemplateInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tool.Builder> getTools() {
            List<Tool.Builder> result = ToolsListCopier.copyToBuilder(this.tools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTools(Collection<Tool.BuilderImpl> tools) {
            this.tools = ToolsListCopier.copyFromBuilder(tools);
        }

        @Override
        public final Builder tools(Collection<Tool> tools) {
            this.tools = ToolsListCopier.copy(tools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Tool... tools) {
            tools(Arrays.asList(tools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Consumer<Tool.Builder>... tools) {
            tools(Stream.of(tools).map(c -> Tool.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public GetTemplateResponse build() {
            return new GetTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
