/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorAsyncClient;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepSummary;

public class ListWorkflowStepsPublisher
implements SdkPublisher<ListWorkflowStepsResponse> {
    private final MigrationHubOrchestratorAsyncClient client;
    private final ListWorkflowStepsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkflowStepsPublisher(MigrationHubOrchestratorAsyncClient client, ListWorkflowStepsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkflowStepsPublisher(MigrationHubOrchestratorAsyncClient client, ListWorkflowStepsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkflowStepsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkflowStepsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkflowStepSummary> workflowStepsSummary() {
        Function<ListWorkflowStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowStepsSummary() != null) {
                return response.workflowStepsSummary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkflowStepsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkflowStepsResponseFetcher
    implements AsyncPageFetcher<ListWorkflowStepsResponse> {
        private ListWorkflowStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkflowStepsResponse> nextPage(ListWorkflowStepsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowStepsPublisher.this.client.listWorkflowSteps(ListWorkflowStepsPublisher.this.firstRequest);
            }
            return ListWorkflowStepsPublisher.this.client.listWorkflowSteps((ListWorkflowStepsRequest)((Object)ListWorkflowStepsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

