/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorAsyncClient;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepSummary;

public class ListTemplateStepsPublisher
implements SdkPublisher<ListTemplateStepsResponse> {
    private final MigrationHubOrchestratorAsyncClient client;
    private final ListTemplateStepsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTemplateStepsPublisher(MigrationHubOrchestratorAsyncClient client, ListTemplateStepsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTemplateStepsPublisher(MigrationHubOrchestratorAsyncClient client, ListTemplateStepsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTemplateStepsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTemplateStepsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TemplateStepSummary> templateStepSummaryList() {
        Function<ListTemplateStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateStepSummaryList() != null) {
                return response.templateStepSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTemplateStepsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTemplateStepsResponseFetcher
    implements AsyncPageFetcher<ListTemplateStepsResponse> {
        private ListTemplateStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTemplateStepsResponse> nextPage(ListTemplateStepsResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateStepsPublisher.this.client.listTemplateSteps(ListTemplateStepsPublisher.this.firstRequest);
            }
            return ListTemplateStepsPublisher.this.client.listTemplateSteps((ListTemplateStepsRequest)((Object)ListTemplateStepsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

