/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorClient;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepSummary;

public class ListTemplateStepsIterable
implements SdkIterable<ListTemplateStepsResponse> {
    private final MigrationHubOrchestratorClient client;
    private final ListTemplateStepsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTemplateStepsIterable(MigrationHubOrchestratorClient client, ListTemplateStepsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTemplateStepsResponseFetcher();
    }

    public Iterator<ListTemplateStepsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TemplateStepSummary> templateStepSummaryList() {
        Function<ListTemplateStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateStepSummaryList() != null) {
                return response.templateStepSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTemplateStepsResponseFetcher
    implements SyncPageFetcher<ListTemplateStepsResponse> {
        private ListTemplateStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTemplateStepsResponse nextPage(ListTemplateStepsResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateStepsIterable.this.client.listTemplateSteps(ListTemplateStepsIterable.this.firstRequest);
            }
            return ListTemplateStepsIterable.this.client.listTemplateSteps((ListTemplateStepsRequest)((Object)ListTemplateStepsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

