/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateInput;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateInputListCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStatus;
import software.amazon.awssdk.services.migrationhuborchestrator.model.Tool;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ToolsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTemplateResponse
extends MigrationHubOrchestratorResponse
implements ToCopyableBuilder<Builder, GetTemplateResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetTemplateResponse.getter(GetTemplateResponse::id)).setter(GetTemplateResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetTemplateResponse.getter(GetTemplateResponse::name)).setter(GetTemplateResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetTemplateResponse.getter(GetTemplateResponse::description)).setter(GetTemplateResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<TemplateInput>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputs").getter(GetTemplateResponse.getter(GetTemplateResponse::inputs)).setter(GetTemplateResponse.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tool>> TOOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tools").getter(GetTemplateResponse.getter(GetTemplateResponse::tools)).setter(GetTemplateResponse.setter(Builder::tools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTemplateResponse.getter(GetTemplateResponse::statusAsString)).setter(GetTemplateResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetTemplateResponse.getter(GetTemplateResponse::creationTime)).setter(GetTemplateResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, INPUTS_FIELD, TOOLS_FIELD, STATUS_FIELD, CREATION_TIME_FIELD));
    private final String id;
    private final String name;
    private final String description;
    private final List<TemplateInput> inputs;
    private final List<Tool> tools;
    private final String status;
    private final Instant creationTime;

    private GetTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.inputs = builder.inputs;
        this.tools = builder.tools;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<TemplateInput> inputs() {
        return this.inputs;
    }

    public final boolean hasTools() {
        return this.tools != null && !(this.tools instanceof SdkAutoConstructList);
    }

    public final List<Tool> tools() {
        return this.tools;
    }

    public final TemplateStatus status() {
        return TemplateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTools() ? this.tools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateResponse)) {
            return false;
        }
        GetTemplateResponse other = (GetTemplateResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && this.hasTools() == other.hasTools() && Objects.equals(this.tools(), other.tools()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetTemplateResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("Tools", this.hasTools() ? this.tools() : null).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "tools": {
                return Optional.ofNullable(clazz.cast(this.tools()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateResponse, T> g) {
        return obj -> g.apply((GetTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private List<TemplateInput> inputs = DefaultSdkAutoConstructList.getInstance();
        private List<Tool> tools = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.inputs(model.inputs);
            this.tools(model.tools);
            this.status(model.status);
            this.creationTime(model.creationTime);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<TemplateInput.Builder> getInputs() {
            List<TemplateInput.Builder> result = TemplateInputListCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<TemplateInput.BuilderImpl> inputs) {
            this.inputs = TemplateInputListCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<TemplateInput> inputs) {
            this.inputs = TemplateInputListCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(TemplateInput ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<TemplateInput.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (TemplateInput)((TemplateInput.Builder)TemplateInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tool.Builder> getTools() {
            List<Tool.Builder> result = ToolsListCopier.copyToBuilder(this.tools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTools(Collection<Tool.BuilderImpl> tools) {
            this.tools = ToolsListCopier.copyFromBuilder(tools);
        }

        @Override
        public final Builder tools(Collection<Tool> tools) {
            this.tools = ToolsListCopier.copy(tools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Tool ... tools) {
            this.tools(Arrays.asList(tools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Consumer<Tool.Builder> ... tools) {
            this.tools(Stream.of(tools).map(c -> (Tool)((Tool.Builder)Tool.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public GetTemplateResponse build() {
            return new GetTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubOrchestratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTemplateResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder inputs(Collection<TemplateInput> var1);

        public Builder inputs(TemplateInput ... var1);

        public Builder inputs(Consumer<TemplateInput.Builder> ... var1);

        public Builder tools(Collection<Tool> var1);

        public Builder tools(Tool ... var1);

        public Builder tools(Consumer<Tool.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(TemplateStatus var1);

        public Builder creationTime(Instant var1);
    }
}

