/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhuborchestrator.model.Owner;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepGroupStatus;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowStepGroupSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowStepGroupSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(WorkflowStepGroupSummary.getter(WorkflowStepGroupSummary::id)).setter(WorkflowStepGroupSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(WorkflowStepGroupSummary.getter(WorkflowStepGroupSummary::name)).setter(WorkflowStepGroupSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(WorkflowStepGroupSummary.getter(WorkflowStepGroupSummary::ownerAsString)).setter(WorkflowStepGroupSummary.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WorkflowStepGroupSummary.getter(WorkflowStepGroupSummary::statusAsString)).setter(WorkflowStepGroupSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> PREVIOUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("previous").getter(WorkflowStepGroupSummary.getter(WorkflowStepGroupSummary::previous)).setter(WorkflowStepGroupSummary.setter(Builder::previous)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previous").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("next").getter(WorkflowStepGroupSummary.getter(WorkflowStepGroupSummary::next)).setter(WorkflowStepGroupSummary.setter(Builder::next)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, OWNER_FIELD, STATUS_FIELD, PREVIOUS_FIELD, NEXT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String owner;
    private final String status;
    private final List<String> previous;
    private final List<String> next;

    private WorkflowStepGroupSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.owner = builder.owner;
        this.status = builder.status;
        this.previous = builder.previous;
        this.next = builder.next;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final Owner owner() {
        return Owner.fromValue(this.owner);
    }

    public final String ownerAsString() {
        return this.owner;
    }

    public final StepGroupStatus status() {
        return StepGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasPrevious() {
        return this.previous != null && !(this.previous instanceof SdkAutoConstructList);
    }

    public final List<String> previous() {
        return this.previous;
    }

    public final boolean hasNext() {
        return this.next != null && !(this.next instanceof SdkAutoConstructList);
    }

    public final List<String> next() {
        return this.next;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrevious() ? this.previous() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNext() ? this.next() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStepGroupSummary)) {
            return false;
        }
        WorkflowStepGroupSummary other = (WorkflowStepGroupSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ownerAsString(), other.ownerAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasPrevious() == other.hasPrevious() && Objects.equals(this.previous(), other.previous()) && this.hasNext() == other.hasNext() && Objects.equals(this.next(), other.next());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowStepGroupSummary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Owner", (Object)this.ownerAsString()).add("Status", (Object)this.statusAsString()).add("Previous", this.hasPrevious() ? this.previous() : null).add("Next", this.hasNext() ? this.next() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.ownerAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "previous": {
                return Optional.ofNullable(clazz.cast(this.previous()));
            }
            case "next": {
                return Optional.ofNullable(clazz.cast(this.next()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStepGroupSummary, T> g) {
        return obj -> g.apply((WorkflowStepGroupSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String owner;
        private String status;
        private List<String> previous = DefaultSdkAutoConstructList.getInstance();
        private List<String> next = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStepGroupSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.owner(model.owner);
            this.status(model.status);
            this.previous(model.previous);
            this.next(model.next);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StepGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getPrevious() {
            if (this.previous instanceof SdkAutoConstructList) {
                return null;
            }
            return this.previous;
        }

        public final void setPrevious(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
        }

        @Override
        public final Builder previous(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previous(String ... previous) {
            this.previous(Arrays.asList(previous));
            return this;
        }

        public final Collection<String> getNext() {
            if (this.next instanceof SdkAutoConstructList) {
                return null;
            }
            return this.next;
        }

        public final void setNext(Collection<String> next) {
            this.next = StringListCopier.copy(next);
        }

        @Override
        public final Builder next(Collection<String> next) {
            this.next = StringListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(String ... next) {
            this.next(Arrays.asList(next));
            return this;
        }

        public WorkflowStepGroupSummary build() {
            return new WorkflowStepGroupSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowStepGroupSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder owner(Owner var1);

        public Builder status(String var1);

        public Builder status(StepGroupStatus var1);

        public Builder previous(Collection<String> var1);

        public Builder previous(String ... var1);

        public Builder next(Collection<String> var1);

        public Builder next(String ... var1);
    }
}

