/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of a step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowStepOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowStepOutput.Builder, WorkflowStepOutput> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(WorkflowStepOutput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(WorkflowStepOutput::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("required").getter(getter(WorkflowStepOutput::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()).build();

    private static final SdkField<WorkflowStepOutputUnion> VALUE_FIELD = SdkField
            .<WorkflowStepOutputUnion> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(WorkflowStepOutput::value)).setter(setter(Builder::value))
            .constructor(WorkflowStepOutputUnion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATA_TYPE_FIELD,
            REQUIRED_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String dataType;

    private final Boolean required;

    private final WorkflowStepOutputUnion value;

    private WorkflowStepOutput(BuilderImpl builder) {
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.required = builder.required;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the step.
     * </p>
     * 
     * @return The name of the step.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The data type of the output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link DataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the output.
     * @see DataType
     */
    public final DataType dataType() {
        return DataType.fromValue(dataType);
    }

    /**
     * <p>
     * The data type of the output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link DataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the output.
     * @see DataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * Determine if an output is required from a step.
     * </p>
     * 
     * @return Determine if an output is required from a step.
     */
    public final Boolean required() {
        return required;
    }

    /**
     * <p>
     * The value of the output.
     * </p>
     * 
     * @return The value of the output.
     */
    public final WorkflowStepOutputUnion value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(required());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStepOutput)) {
            return false;
        }
        WorkflowStepOutput other = (WorkflowStepOutput) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(dataTypeAsString(), other.dataTypeAsString())
                && Objects.equals(required(), other.required()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowStepOutput").add("Name", name()).add("DataType", dataTypeAsString())
                .add("Required", required()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "required":
            return Optional.ofNullable(clazz.cast(required()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStepOutput, T> g) {
        return obj -> g.apply((WorkflowStepOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowStepOutput> {
        /**
         * <p>
         * The name of the step.
         * </p>
         * 
         * @param name
         *        The name of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data type of the output.
         * </p>
         * 
         * @param dataType
         *        The data type of the output.
         * @see DataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The data type of the output.
         * </p>
         * 
         * @param dataType
         *        The data type of the output.
         * @see DataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataType
         */
        Builder dataType(DataType dataType);

        /**
         * <p>
         * Determine if an output is required from a step.
         * </p>
         * 
         * @param required
         *        Determine if an output is required from a step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);

        /**
         * <p>
         * The value of the output.
         * </p>
         * 
         * @param value
         *        The value of the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(WorkflowStepOutputUnion value);

        /**
         * <p>
         * The value of the output.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkflowStepOutputUnion.Builder} avoiding
         * the need to create one manually via {@link WorkflowStepOutputUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowStepOutputUnion.Builder#build()} is called immediately
         * and its result is passed to {@link #value(WorkflowStepOutputUnion)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link WorkflowStepOutputUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(WorkflowStepOutputUnion)
         */
        default Builder value(Consumer<WorkflowStepOutputUnion.Builder> value) {
            return value(WorkflowStepOutputUnion.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String dataType;

        private Boolean required;

        private WorkflowStepOutputUnion value;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStepOutput model) {
            name(model.name);
            dataType(model.dataType);
            required(model.required);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(DataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final Boolean getRequired() {
            return required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final WorkflowStepOutputUnion.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(WorkflowStepOutputUnion.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(WorkflowStepOutputUnion value) {
            this.value = value;
            return this;
        }

        @Override
        public WorkflowStepOutput build() {
            return new WorkflowStepOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
