/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetryWorkflowStepResponse extends MigrationHubOrchestratorResponse implements
        ToCopyableBuilder<RetryWorkflowStepResponse.Builder, RetryWorkflowStepResponse> {
    private static final SdkField<String> STEP_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepGroupId").getter(getter(RetryWorkflowStepResponse::stepGroupId))
            .setter(setter(Builder::stepGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepGroupId").build()).build();

    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowId").getter(getter(RetryWorkflowStepResponse::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(RetryWorkflowStepResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RetryWorkflowStepResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_GROUP_ID_FIELD,
            WORKFLOW_ID_FIELD, ID_FIELD, STATUS_FIELD));

    private final String stepGroupId;

    private final String workflowId;

    private final String id;

    private final String status;

    private RetryWorkflowStepResponse(BuilderImpl builder) {
        super(builder);
        this.stepGroupId = builder.stepGroupId;
        this.workflowId = builder.workflowId;
        this.id = builder.id;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the step group.
     * </p>
     * 
     * @return The ID of the step group.
     */
    public final String stepGroupId() {
        return stepGroupId;
    }

    /**
     * <p>
     * The ID of the migration workflow.
     * </p>
     * 
     * @return The ID of the migration workflow.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The ID of the step.
     * </p>
     * 
     * @return The ID of the step.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The status of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the step.
     * @see StepStatus
     */
    public final StepStatus status() {
        return StepStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the step.
     * @see StepStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stepGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryWorkflowStepResponse)) {
            return false;
        }
        RetryWorkflowStepResponse other = (RetryWorkflowStepResponse) obj;
        return Objects.equals(stepGroupId(), other.stepGroupId()) && Objects.equals(workflowId(), other.workflowId())
                && Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetryWorkflowStepResponse").add("StepGroupId", stepGroupId()).add("WorkflowId", workflowId())
                .add("Id", id()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepGroupId":
            return Optional.ofNullable(clazz.cast(stepGroupId()));
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryWorkflowStepResponse, T> g) {
        return obj -> g.apply((RetryWorkflowStepResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubOrchestratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RetryWorkflowStepResponse> {
        /**
         * <p>
         * The ID of the step group.
         * </p>
         * 
         * @param stepGroupId
         *        The ID of the step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepGroupId(String stepGroupId);

        /**
         * <p>
         * The ID of the migration workflow.
         * </p>
         * 
         * @param workflowId
         *        The ID of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The ID of the step.
         * </p>
         * 
         * @param id
         *        The ID of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the step.
         * </p>
         * 
         * @param status
         *        The status of the step.
         * @see StepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the step.
         * </p>
         * 
         * @param status
         *        The status of the step.
         * @see StepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepStatus
         */
        Builder status(StepStatus status);
    }

    static final class BuilderImpl extends MigrationHubOrchestratorResponse.BuilderImpl implements Builder {
        private String stepGroupId;

        private String workflowId;

        private String id;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryWorkflowStepResponse model) {
            super(model);
            stepGroupId(model.stepGroupId);
            workflowId(model.workflowId);
            id(model.id);
            status(model.status);
        }

        public final String getStepGroupId() {
            return stepGroupId;
        }

        public final void setStepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
        }

        @Override
        public final Builder stepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
            return this;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StepStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public RetryWorkflowStepResponse build() {
            return new RetryWorkflowStepResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
