/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorClient;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowSummary;

public class ListWorkflowsIterable
implements SdkIterable<ListWorkflowsResponse> {
    private final MigrationHubOrchestratorClient client;
    private final ListWorkflowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowsIterable(MigrationHubOrchestratorClient client, ListWorkflowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWorkflowsResponseFetcher();
    }

    public Iterator<ListWorkflowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MigrationWorkflowSummary> migrationWorkflowSummary() {
        Function<ListWorkflowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.migrationWorkflowSummary() != null) {
                return response.migrationWorkflowSummary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowsResponseFetcher
    implements SyncPageFetcher<ListWorkflowsResponse> {
        private ListWorkflowsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowsResponse nextPage(ListWorkflowsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowsIterable.this.client.listWorkflows(ListWorkflowsIterable.this.firstRequest);
            }
            return ListWorkflowsIterable.this.client.listWorkflows((ListWorkflowsRequest)((Object)ListWorkflowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

