/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorAsyncClient;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateSummary;

public class ListTemplatesPublisher
implements SdkPublisher<ListTemplatesResponse> {
    private final MigrationHubOrchestratorAsyncClient client;
    private final ListTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTemplatesPublisher(MigrationHubOrchestratorAsyncClient client, ListTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTemplatesPublisher(MigrationHubOrchestratorAsyncClient client, ListTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TemplateSummary> templateSummary() {
        Function<ListTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateSummary() != null) {
                return response.templateSummary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTemplatesResponseFetcher
    implements AsyncPageFetcher<ListTemplatesResponse> {
        private ListTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTemplatesResponse> nextPage(ListTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListTemplatesPublisher.this.client.listTemplates(ListTemplatesPublisher.this.firstRequest);
            }
            return ListTemplatesPublisher.this.client.listTemplates((ListTemplatesRequest)((Object)ListTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

