/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorClient;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepGroupSummary;

public class ListWorkflowStepGroupsIterable
implements SdkIterable<ListWorkflowStepGroupsResponse> {
    private final MigrationHubOrchestratorClient client;
    private final ListWorkflowStepGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowStepGroupsIterable(MigrationHubOrchestratorClient client, ListWorkflowStepGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWorkflowStepGroupsResponseFetcher();
    }

    public Iterator<ListWorkflowStepGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowStepGroupSummary> workflowStepGroupsSummary() {
        Function<ListWorkflowStepGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowStepGroupsSummary() != null) {
                return response.workflowStepGroupsSummary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowStepGroupsResponseFetcher
    implements SyncPageFetcher<ListWorkflowStepGroupsResponse> {
        private ListWorkflowStepGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowStepGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowStepGroupsResponse nextPage(ListWorkflowStepGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowStepGroupsIterable.this.client.listWorkflowStepGroups(ListWorkflowStepGroupsIterable.this.firstRequest);
            }
            return ListWorkflowStepGroupsIterable.this.client.listWorkflowStepGroups((ListWorkflowStepGroupsRequest)((Object)ListWorkflowStepGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

