/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHomeRegionControlRequest extends MigrationHubConfigRequest implements
        ToCopyableBuilder<CreateHomeRegionControlRequest.Builder, CreateHomeRegionControlRequest> {
    private static final SdkField<String> HOME_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion").getter(getter(CreateHomeRegionControlRequest::homeRegion))
            .setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()).build();

    private static final SdkField<Target> TARGET_FIELD = SdkField.<Target> builder(MarshallingType.SDK_POJO).memberName("Target")
            .getter(getter(CreateHomeRegionControlRequest::target)).setter(setter(Builder::target)).constructor(Target::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(CreateHomeRegionControlRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOME_REGION_FIELD,
            TARGET_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String homeRegion;

    private final Target target;

    private final Boolean dryRun;

    private CreateHomeRegionControlRequest(BuilderImpl builder) {
        super(builder);
        this.homeRegion = builder.homeRegion;
        this.target = builder.target;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The name of the home region of the calling account.
     * </p>
     * 
     * @return The name of the home region of the calling account.
     */
    public final String homeRegion() {
        return homeRegion;
    }

    /**
     * <p>
     * The account for which this command sets up a home region control. The <code>Target</code> is always of type
     * <code>ACCOUNT</code>.
     * </p>
     * 
     * @return The account for which this command sets up a home region control. The <code>Target</code> is always of
     *         type <code>ACCOUNT</code>.
     */
    public final Target target() {
        return target;
    }

    /**
     * <p>
     * Optional Boolean flag to indicate whether any effect should take place. It tests whether the caller has
     * permission to make the call.
     * </p>
     * 
     * @return Optional Boolean flag to indicate whether any effect should take place. It tests whether the caller has
     *         permission to make the call.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHomeRegionControlRequest)) {
            return false;
        }
        CreateHomeRegionControlRequest other = (CreateHomeRegionControlRequest) obj;
        return Objects.equals(homeRegion(), other.homeRegion()) && Objects.equals(target(), other.target())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHomeRegionControlRequest").add("HomeRegion", homeRegion()).add("Target", target())
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HomeRegion", HOME_REGION_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHomeRegionControlRequest, T> g) {
        return obj -> g.apply((CreateHomeRegionControlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateHomeRegionControlRequest> {
        /**
         * <p>
         * The name of the home region of the calling account.
         * </p>
         * 
         * @param homeRegion
         *        The name of the home region of the calling account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);

        /**
         * <p>
         * The account for which this command sets up a home region control. The <code>Target</code> is always of type
         * <code>ACCOUNT</code>.
         * </p>
         * 
         * @param target
         *        The account for which this command sets up a home region control. The <code>Target</code> is always of
         *        type <code>ACCOUNT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(Target target);

        /**
         * <p>
         * The account for which this command sets up a home region control. The <code>Target</code> is always of type
         * <code>ACCOUNT</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Target.Builder} avoiding the need to
         * create one manually via {@link Target#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Target.Builder#build()} is called immediately and its result is
         * passed to {@link #target(Target)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(Target)
         */
        default Builder target(Consumer<Target.Builder> target) {
            return target(Target.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * Optional Boolean flag to indicate whether any effect should take place. It tests whether the caller has
         * permission to make the call.
         * </p>
         * 
         * @param dryRun
         *        Optional Boolean flag to indicate whether any effect should take place. It tests whether the caller
         *        has permission to make the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubConfigRequest.BuilderImpl implements Builder {
        private String homeRegion;

        private Target target;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHomeRegionControlRequest model) {
            super(model);
            homeRegion(model.homeRegion);
            target(model.target);
            dryRun(model.dryRun);
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final Target.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(Target.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(Target target) {
            this.target = target;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHomeRegionControlRequest build() {
            return new CreateHomeRegionControlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
