/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubconfig.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubconfig.model.HomeRegionControl;
import software.amazon.awssdk.services.migrationhubconfig.model.HomeRegionControlsCopier;
import software.amazon.awssdk.services.migrationhubconfig.model.MigrationHubConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHomeRegionControlsResponse
extends MigrationHubConfigResponse
implements ToCopyableBuilder<Builder, DescribeHomeRegionControlsResponse> {
    private static final SdkField<List<HomeRegionControl>> HOME_REGION_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HomeRegionControls").getter(DescribeHomeRegionControlsResponse.getter(DescribeHomeRegionControlsResponse::homeRegionControls)).setter(DescribeHomeRegionControlsResponse.setter(Builder::homeRegionControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegionControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HomeRegionControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeHomeRegionControlsResponse.getter(DescribeHomeRegionControlsResponse::nextToken)).setter(DescribeHomeRegionControlsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOME_REGION_CONTROLS_FIELD, NEXT_TOKEN_FIELD));
    private final List<HomeRegionControl> homeRegionControls;
    private final String nextToken;

    private DescribeHomeRegionControlsResponse(BuilderImpl builder) {
        super(builder);
        this.homeRegionControls = builder.homeRegionControls;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasHomeRegionControls() {
        return this.homeRegionControls != null && !(this.homeRegionControls instanceof SdkAutoConstructList);
    }

    public final List<HomeRegionControl> homeRegionControls() {
        return this.homeRegionControls;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHomeRegionControls() ? this.homeRegionControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHomeRegionControlsResponse)) {
            return false;
        }
        DescribeHomeRegionControlsResponse other = (DescribeHomeRegionControlsResponse)((Object)obj);
        return this.hasHomeRegionControls() == other.hasHomeRegionControls() && Objects.equals(this.homeRegionControls(), other.homeRegionControls()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHomeRegionControlsResponse").add("HomeRegionControls", this.hasHomeRegionControls() ? this.homeRegionControls() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HomeRegionControls": {
                return Optional.ofNullable(clazz.cast(this.homeRegionControls()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHomeRegionControlsResponse, T> g) {
        return obj -> g.apply((DescribeHomeRegionControlsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubConfigResponse.BuilderImpl
    implements Builder {
        private List<HomeRegionControl> homeRegionControls = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHomeRegionControlsResponse model) {
            super(model);
            this.homeRegionControls(model.homeRegionControls);
            this.nextToken(model.nextToken);
        }

        public final List<HomeRegionControl.Builder> getHomeRegionControls() {
            List<HomeRegionControl.Builder> result = HomeRegionControlsCopier.copyToBuilder(this.homeRegionControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHomeRegionControls(Collection<HomeRegionControl.BuilderImpl> homeRegionControls) {
            this.homeRegionControls = HomeRegionControlsCopier.copyFromBuilder(homeRegionControls);
        }

        @Override
        @Transient
        public final Builder homeRegionControls(Collection<HomeRegionControl> homeRegionControls) {
            this.homeRegionControls = HomeRegionControlsCopier.copy(homeRegionControls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder homeRegionControls(HomeRegionControl ... homeRegionControls) {
            this.homeRegionControls(Arrays.asList(homeRegionControls));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder homeRegionControls(Consumer<HomeRegionControl.Builder> ... homeRegionControls) {
            this.homeRegionControls(Stream.of(homeRegionControls).map(c -> (HomeRegionControl)((HomeRegionControl.Builder)HomeRegionControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeHomeRegionControlsResponse build() {
            return new DescribeHomeRegionControlsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHomeRegionControlsResponse> {
        public Builder homeRegionControls(Collection<HomeRegionControl> var1);

        public Builder homeRegionControls(HomeRegionControl ... var1);

        public Builder homeRegionControls(Consumer<HomeRegionControl.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

