/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubconfig;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.migrationhubconfig.MigrationHubConfigAsyncClient;
import software.amazon.awssdk.services.migrationhubconfig.model.AccessDeniedException;
import software.amazon.awssdk.services.migrationhubconfig.model.CreateHomeRegionControlRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.CreateHomeRegionControlResponse;
import software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse;
import software.amazon.awssdk.services.migrationhubconfig.model.DryRunOperationException;
import software.amazon.awssdk.services.migrationhubconfig.model.GetHomeRegionRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.GetHomeRegionResponse;
import software.amazon.awssdk.services.migrationhubconfig.model.InternalServerErrorException;
import software.amazon.awssdk.services.migrationhubconfig.model.InvalidInputException;
import software.amazon.awssdk.services.migrationhubconfig.model.MigrationHubConfigException;
import software.amazon.awssdk.services.migrationhubconfig.model.MigrationHubConfigRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.ServiceUnavailableException;
import software.amazon.awssdk.services.migrationhubconfig.model.ThrottlingException;
import software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsPublisher;
import software.amazon.awssdk.services.migrationhubconfig.transform.CreateHomeRegionControlRequestMarshaller;
import software.amazon.awssdk.services.migrationhubconfig.transform.DescribeHomeRegionControlsRequestMarshaller;
import software.amazon.awssdk.services.migrationhubconfig.transform.GetHomeRegionRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultMigrationHubConfigAsyncClient
implements MigrationHubConfigAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultMigrationHubConfigAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMigrationHubConfigAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "mgh";
    }

    @Override
    public CompletableFuture<CreateHomeRegionControlResponse> createHomeRegionControl(CreateHomeRegionControlRequest createHomeRegionControlRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHomeRegionControlResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHomeRegionControl").withMarshaller((Marshaller)new CreateHomeRegionControlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHomeRegionControlRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeHomeRegionControlsResponse> describeHomeRegionControls(DescribeHomeRegionControlsRequest describeHomeRegionControlsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeHomeRegionControlsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHomeRegionControls").withMarshaller((Marshaller)new DescribeHomeRegionControlsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHomeRegionControlsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeHomeRegionControlsPublisher describeHomeRegionControlsPaginator(DescribeHomeRegionControlsRequest describeHomeRegionControlsRequest) {
        return new DescribeHomeRegionControlsPublisher(this, this.applyPaginatorUserAgent(describeHomeRegionControlsRequest));
    }

    @Override
    public CompletableFuture<GetHomeRegionResponse> getHomeRegion(GetHomeRegionRequest getHomeRegionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetHomeRegionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHomeRegion").withMarshaller((Marshaller)new GetHomeRegionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getHomeRegionRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MigrationHubConfigException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerError").exceptionBuilderSupplier(InternalServerErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DryRunOperation").exceptionBuilderSupplier(DryRunOperationException::builder).build());
    }

    private <T extends MigrationHubConfigRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.10").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MigrationHubConfigRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}

