/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubconfig;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.migrationhubconfig.model.CreateHomeRegionControlRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.CreateHomeRegionControlResponse;
import software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse;
import software.amazon.awssdk.services.migrationhubconfig.model.GetHomeRegionRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.GetHomeRegionResponse;
import software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsPublisher;

/**
 * Service client for accessing AWS Migration Hub Config asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The AWS Migration Hub home region APIs are available specifically for working with your Migration Hub home region.
 * You can use these APIs to determine a home region, as well as to create and work with controls that describe the home
 * region.
 * </p>
 * <p>
 * You can use these APIs within your home region only. If you call these APIs from outside your home region, your calls
 * are rejected, except for the ability to register your agents and connectors.
 * </p>
 * <p>
 * You must call <code>GetHomeRegion</code> at least once before you call any other AWS Application Discovery Service
 * and AWS Migration Hub APIs, to obtain the account's Migration Hub home region.
 * </p>
 * <p>
 * The <code>StartDataCollection</code> API call in AWS Application Discovery Service allows your agents and connectors
 * to begin collecting data that flows directly into the home region, and it will prevent you from enabling data
 * collection information to be sent outside the home region.
 * </p>
 * <p>
 * For specific API usage, see the sections that follow in this AWS Migration Hub Home Region API reference.
 * </p>
 * <note>
 * <p>
 * The Migration Hub Home Region APIs do not support AWS Organizations.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public interface MigrationHubConfigAsyncClient extends SdkClient {
    String SERVICE_NAME = "mgh";

    /**
     * Create a {@link MigrationHubConfigAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MigrationHubConfigAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MigrationHubConfigAsyncClient}.
     */
    static MigrationHubConfigAsyncClientBuilder builder() {
        return new DefaultMigrationHubConfigAsyncClientBuilder();
    }

    /**
     * <p>
     * This API sets up the home region for the calling account only.
     * </p>
     *
     * @param createHomeRegionControlRequest
     * @return A Java Future containing the result of the CreateHomeRegionControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>DryRunOperationException Exception raised to indicate that authorization of an action was successful,
     *         when the <code>DryRun</code> flag is set to true.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.CreateHomeRegionControl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/CreateHomeRegionControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHomeRegionControlResponse> createHomeRegionControl(
            CreateHomeRegionControlRequest createHomeRegionControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API sets up the home region for the calling account only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHomeRegionControlRequest.Builder} avoiding
     * the need to create one manually via {@link CreateHomeRegionControlRequest#builder()}
     * </p>
     *
     * @param createHomeRegionControlRequest
     *        A {@link Consumer} that will call methods on {@link CreateHomeRegionControlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateHomeRegionControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>DryRunOperationException Exception raised to indicate that authorization of an action was successful,
     *         when the <code>DryRun</code> flag is set to true.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.CreateHomeRegionControl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/CreateHomeRegionControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHomeRegionControlResponse> createHomeRegionControl(
            Consumer<CreateHomeRegionControlRequest.Builder> createHomeRegionControlRequest) {
        return createHomeRegionControl(CreateHomeRegionControlRequest.builder().applyMutation(createHomeRegionControlRequest)
                .build());
    }

    /**
     * <p>
     * This API permits filtering on the <code>ControlId</code>, <code>HomeRegion</code>, and
     * <code>RegionControlScope</code> fields.
     * </p>
     *
     * @param describeHomeRegionControlsRequest
     * @return A Java Future containing the result of the DescribeHomeRegionControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.DescribeHomeRegionControls
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DescribeHomeRegionControls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHomeRegionControlsResponse> describeHomeRegionControls(
            DescribeHomeRegionControlsRequest describeHomeRegionControlsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API permits filtering on the <code>ControlId</code>, <code>HomeRegion</code>, and
     * <code>RegionControlScope</code> fields.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHomeRegionControlsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHomeRegionControlsRequest#builder()}
     * </p>
     *
     * @param describeHomeRegionControlsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHomeRegionControlsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeHomeRegionControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.DescribeHomeRegionControls
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DescribeHomeRegionControls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHomeRegionControlsResponse> describeHomeRegionControls(
            Consumer<DescribeHomeRegionControlsRequest.Builder> describeHomeRegionControlsRequest) {
        return describeHomeRegionControls(DescribeHomeRegionControlsRequest.builder()
                .applyMutation(describeHomeRegionControlsRequest).build());
    }

    /**
     * <p>
     * This API permits filtering on the <code>ControlId</code>, <code>HomeRegion</code>, and
     * <code>RegionControlScope</code> fields.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHomeRegionControls(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsPublisher publisher = client.describeHomeRegionControlsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsPublisher publisher = client.describeHomeRegionControlsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHomeRegionControls(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeHomeRegionControlsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.DescribeHomeRegionControls
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DescribeHomeRegionControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHomeRegionControlsPublisher describeHomeRegionControlsPaginator(
            DescribeHomeRegionControlsRequest describeHomeRegionControlsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API permits filtering on the <code>ControlId</code>, <code>HomeRegion</code>, and
     * <code>RegionControlScope</code> fields.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHomeRegionControls(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsPublisher publisher = client.describeHomeRegionControlsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsPublisher publisher = client.describeHomeRegionControlsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHomeRegionControls(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHomeRegionControlsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHomeRegionControlsRequest#builder()}
     * </p>
     *
     * @param describeHomeRegionControlsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHomeRegionControlsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.DescribeHomeRegionControls
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DescribeHomeRegionControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHomeRegionControlsPublisher describeHomeRegionControlsPaginator(
            Consumer<DescribeHomeRegionControlsRequest.Builder> describeHomeRegionControlsRequest) {
        return describeHomeRegionControlsPaginator(DescribeHomeRegionControlsRequest.builder()
                .applyMutation(describeHomeRegionControlsRequest).build());
    }

    /**
     * <p>
     * Returns the calling account’s home region, if configured. This API is used by other AWS services to determine the
     * regional endpoint for calling AWS Application Discovery Service and Migration Hub. You must call
     * <code>GetHomeRegion</code> at least once before you call any other AWS Application Discovery Service and AWS
     * Migration Hub APIs, to obtain the account's Migration Hub home region.
     * </p>
     *
     * @param getHomeRegionRequest
     * @return A Java Future containing the result of the GetHomeRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.GetHomeRegion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/GetHomeRegion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHomeRegionResponse> getHomeRegion(GetHomeRegionRequest getHomeRegionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the calling account’s home region, if configured. This API is used by other AWS services to determine the
     * regional endpoint for calling AWS Application Discovery Service and Migration Hub. You must call
     * <code>GetHomeRegion</code> at least once before you call any other AWS Application Discovery Service and AWS
     * Migration Hub APIs, to obtain the account's Migration Hub home region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHomeRegionRequest.Builder} avoiding the need to
     * create one manually via {@link GetHomeRegionRequest#builder()}
     * </p>
     *
     * @param getHomeRegionRequest
     *        A {@link Consumer} that will call methods on {@link GetHomeRegionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetHomeRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.GetHomeRegion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/GetHomeRegion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHomeRegionResponse> getHomeRegion(Consumer<GetHomeRegionRequest.Builder> getHomeRegionRequest) {
        return getHomeRegion(GetHomeRegionRequest.builder().applyMutation(getHomeRegionRequest).build());
    }
}
