/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhub.model.Task;
import software.amazon.awssdk.services.migrationhub.model.UpdateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MigrationTaskUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MigrationTaskUpdate> {
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateDateTime").getter(MigrationTaskUpdate.getter(MigrationTaskUpdate::updateDateTime)).setter(MigrationTaskUpdate.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDateTime").build()}).build();
    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateType").getter(MigrationTaskUpdate.getter(MigrationTaskUpdate::updateTypeAsString)).setter(MigrationTaskUpdate.setter(Builder::updateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateType").build()}).build();
    private static final SdkField<Task> MIGRATION_TASK_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MigrationTaskState").getter(MigrationTaskUpdate.getter(MigrationTaskUpdate::migrationTaskState)).setter(MigrationTaskUpdate.setter(Builder::migrationTaskState)).constructor(Task::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_DATE_TIME_FIELD, UPDATE_TYPE_FIELD, MIGRATION_TASK_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UpdateDateTime", UPDATE_DATE_TIME_FIELD);
            this.put("UpdateType", UPDATE_TYPE_FIELD);
            this.put("MigrationTaskState", MIGRATION_TASK_STATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant updateDateTime;
    private final String updateType;
    private final Task migrationTaskState;

    private MigrationTaskUpdate(BuilderImpl builder) {
        this.updateDateTime = builder.updateDateTime;
        this.updateType = builder.updateType;
        this.migrationTaskState = builder.migrationTaskState;
    }

    public final Instant updateDateTime() {
        return this.updateDateTime;
    }

    public final UpdateType updateType() {
        return UpdateType.fromValue(this.updateType);
    }

    public final String updateTypeAsString() {
        return this.updateType;
    }

    public final Task migrationTaskState() {
        return this.migrationTaskState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTaskState());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationTaskUpdate)) {
            return false;
        }
        MigrationTaskUpdate other = (MigrationTaskUpdate)obj;
        return Objects.equals(this.updateDateTime(), other.updateDateTime()) && Objects.equals(this.updateTypeAsString(), other.updateTypeAsString()) && Objects.equals(this.migrationTaskState(), other.migrationTaskState());
    }

    public final String toString() {
        return ToString.builder((String)"MigrationTaskUpdate").add("UpdateDateTime", (Object)this.updateDateTime()).add("UpdateType", (Object)this.updateTypeAsString()).add("MigrationTaskState", (Object)this.migrationTaskState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpdateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
            case "UpdateType": {
                return Optional.ofNullable(clazz.cast(this.updateTypeAsString()));
            }
            case "MigrationTaskState": {
                return Optional.ofNullable(clazz.cast(this.migrationTaskState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MigrationTaskUpdate, T> g) {
        return obj -> g.apply((MigrationTaskUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant updateDateTime;
        private String updateType;
        private Task migrationTaskState;

        private BuilderImpl() {
        }

        private BuilderImpl(MigrationTaskUpdate model) {
            this.updateDateTime(model.updateDateTime);
            this.updateType(model.updateType);
            this.migrationTaskState(model.migrationTaskState);
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getUpdateType() {
            return this.updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(UpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public final Task.Builder getMigrationTaskState() {
            return this.migrationTaskState != null ? this.migrationTaskState.toBuilder() : null;
        }

        public final void setMigrationTaskState(Task.BuilderImpl migrationTaskState) {
            this.migrationTaskState = migrationTaskState != null ? migrationTaskState.build() : null;
        }

        @Override
        public final Builder migrationTaskState(Task migrationTaskState) {
            this.migrationTaskState = migrationTaskState;
            return this;
        }

        public MigrationTaskUpdate build() {
            return new MigrationTaskUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MigrationTaskUpdate> {
        public Builder updateDateTime(Instant var1);

        public Builder updateType(String var1);

        public Builder updateType(UpdateType var1);

        public Builder migrationTaskState(Task var1);

        default public Builder migrationTaskState(Consumer<Task.Builder> migrationTaskState) {
            return this.migrationTaskState((Task)((Task.Builder)Task.builder().applyMutation(migrationTaskState)).build());
        }
    }
}

