/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourceAttributesRequest extends MigrationHubRequest implements
        ToCopyableBuilder<PutResourceAttributesRequest.Builder, PutResourceAttributesRequest> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutResourceAttributesRequest::progressUpdateStream)).setter(setter(Builder::progressUpdateStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStream").build())
            .build();

    private static final SdkField<String> MIGRATION_TASK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutResourceAttributesRequest::migrationTaskName)).setter(setter(Builder::migrationTaskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskName").build()).build();

    private static final SdkField<List<ResourceAttribute>> RESOURCE_ATTRIBUTE_LIST_FIELD = SdkField
            .<List<ResourceAttribute>> builder(MarshallingType.LIST)
            .getter(getter(PutResourceAttributesRequest::resourceAttributeList))
            .setter(setter(Builder::resourceAttributeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAttributeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PutResourceAttributesRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_UPDATE_STREAM_FIELD,
            MIGRATION_TASK_NAME_FIELD, RESOURCE_ATTRIBUTE_LIST_FIELD, DRY_RUN_FIELD));

    private final String progressUpdateStream;

    private final String migrationTaskName;

    private final List<ResourceAttribute> resourceAttributeList;

    private final Boolean dryRun;

    private PutResourceAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.resourceAttributeList = builder.resourceAttributeList;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The name of the ProgressUpdateStream.
     * </p>
     * 
     * @return The name of the ProgressUpdateStream.
     */
    public String progressUpdateStream() {
        return progressUpdateStream;
    }

    /**
     * <p>
     * Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
     * </p>
     * 
     * @return Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
     */
    public String migrationTaskName() {
        return migrationTaskName;
    }

    /**
     * Returns true if the ResourceAttributeList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResourceAttributeList() {
        return resourceAttributeList != null && !(resourceAttributeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the resource that is being migrated. This data will be used to map the task to a resource in
     * the Application Discovery Service repository.
     * </p>
     * <note>
     * <p>
     * Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code> field is reserved for the
     * following values:
     * <code>IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code>
     * where the identifying value can be a string up to 256 characters.
     * </p>
     * </note> <important>
     * <ul>
     * <li>
     * <p>
     * If any "VM" related value is set for a <code>ResourceAttribute</code> object, it is required that
     * <code>VM_MANAGER_ID</code>, as a minimum, is always set. If <code>VM_MANAGER_ID</code> is not set, then all "VM"
     * fields will be discarded and "VM" fields will not be used for matching the migration task to a server in
     * Application Discovery Service repository. See the <a href=
     * "https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples"
     * >Example</a> section below for a use case of specifying "VM" related values.
     * </p>
     * </li>
     * <li>
     * <p>
     * If a server you are trying to match has multiple IP or MAC addresses, you should provide as many as you know in
     * separate type/value pairs passed to the <code>ResourceAttributeList</code> parameter to maximize the chances of
     * matching.
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAttributeList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the resource that is being migrated. This data will be used to map the task to a
     *         resource in the Application Discovery Service repository.</p> <note>
     *         <p>
     *         Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code> field is reserved
     *         for the following values:
     *         <code>IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code>
     *         where the identifying value can be a string up to 256 characters.
     *         </p>
     *         </note> <important>
     *         <ul>
     *         <li>
     *         <p>
     *         If any "VM" related value is set for a <code>ResourceAttribute</code> object, it is required that
     *         <code>VM_MANAGER_ID</code>, as a minimum, is always set. If <code>VM_MANAGER_ID</code> is not set, then
     *         all "VM" fields will be discarded and "VM" fields will not be used for matching the migration task to a
     *         server in Application Discovery Service repository. See the <a href=
     *         "https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples"
     *         >Example</a> section below for a use case of specifying "VM" related values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If a server you are trying to match has multiple IP or MAC addresses, you should provide as many as you
     *         know in separate type/value pairs passed to the <code>ResourceAttributeList</code> parameter to maximize
     *         the chances of matching.
     *         </p>
     *         </li>
     *         </ul>
     */
    public List<ResourceAttribute> resourceAttributeList() {
        return resourceAttributeList;
    }

    /**
     * <p>
     * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission
     * to make the call.
     * </p>
     * 
     * @return Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
     *         permission to make the call.
     */
    public Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAttributeList());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourceAttributesRequest)) {
            return false;
        }
        PutResourceAttributesRequest other = (PutResourceAttributesRequest) obj;
        return Objects.equals(progressUpdateStream(), other.progressUpdateStream())
                && Objects.equals(migrationTaskName(), other.migrationTaskName())
                && Objects.equals(resourceAttributeList(), other.resourceAttributeList())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutResourceAttributesRequest").add("ProgressUpdateStream", progressUpdateStream())
                .add("MigrationTaskName", migrationTaskName()).add("ResourceAttributeList", resourceAttributeList())
                .add("DryRun", dryRun()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressUpdateStream":
            return Optional.ofNullable(clazz.cast(progressUpdateStream()));
        case "MigrationTaskName":
            return Optional.ofNullable(clazz.cast(migrationTaskName()));
        case "ResourceAttributeList":
            return Optional.ofNullable(clazz.cast(resourceAttributeList()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResourceAttributesRequest, T> g) {
        return obj -> g.apply((PutResourceAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutResourceAttributesRequest> {
        /**
         * <p>
         * The name of the ProgressUpdateStream.
         * </p>
         * 
         * @param progressUpdateStream
         *        The name of the ProgressUpdateStream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressUpdateStream(String progressUpdateStream);

        /**
         * <p>
         * Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
         * </p>
         * 
         * @param migrationTaskName
         *        Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskName(String migrationTaskName);

        /**
         * <p>
         * Information about the resource that is being migrated. This data will be used to map the task to a resource
         * in the Application Discovery Service repository.
         * </p>
         * <note>
         * <p>
         * Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code> field is reserved for
         * the following values:
         * <code>IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code>
         * where the identifying value can be a string up to 256 characters.
         * </p>
         * </note> <important>
         * <ul>
         * <li>
         * <p>
         * If any "VM" related value is set for a <code>ResourceAttribute</code> object, it is required that
         * <code>VM_MANAGER_ID</code>, as a minimum, is always set. If <code>VM_MANAGER_ID</code> is not set, then all
         * "VM" fields will be discarded and "VM" fields will not be used for matching the migration task to a server in
         * Application Discovery Service repository. See the <a href=
         * "https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples"
         * >Example</a> section below for a use case of specifying "VM" related values.
         * </p>
         * </li>
         * <li>
         * <p>
         * If a server you are trying to match has multiple IP or MAC addresses, you should provide as many as you know
         * in separate type/value pairs passed to the <code>ResourceAttributeList</code> parameter to maximize the
         * chances of matching.
         * </p>
         * </li>
         * </ul>
         * </important>
         * 
         * @param resourceAttributeList
         *        Information about the resource that is being migrated. This data will be used to map the task to a
         *        resource in the Application Discovery Service repository.</p> <note>
         *        <p>
         *        Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code> field is reserved
         *        for the following values:
         *        <code>IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code>
         *        where the identifying value can be a string up to 256 characters.
         *        </p>
         *        </note> <important>
         *        <ul>
         *        <li>
         *        <p>
         *        If any "VM" related value is set for a <code>ResourceAttribute</code> object, it is required that
         *        <code>VM_MANAGER_ID</code>, as a minimum, is always set. If <code>VM_MANAGER_ID</code> is not set,
         *        then all "VM" fields will be discarded and "VM" fields will not be used for matching the migration
         *        task to a server in Application Discovery Service repository. See the <a href=
         *        "https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples"
         *        >Example</a> section below for a use case of specifying "VM" related values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If a server you are trying to match has multiple IP or MAC addresses, you should provide as many as
         *        you know in separate type/value pairs passed to the <code>ResourceAttributeList</code> parameter to
         *        maximize the chances of matching.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAttributeList(Collection<ResourceAttribute> resourceAttributeList);

        /**
         * <p>
         * Information about the resource that is being migrated. This data will be used to map the task to a resource
         * in the Application Discovery Service repository.
         * </p>
         * <note>
         * <p>
         * Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code> field is reserved for
         * the following values:
         * <code>IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code>
         * where the identifying value can be a string up to 256 characters.
         * </p>
         * </note> <important>
         * <ul>
         * <li>
         * <p>
         * If any "VM" related value is set for a <code>ResourceAttribute</code> object, it is required that
         * <code>VM_MANAGER_ID</code>, as a minimum, is always set. If <code>VM_MANAGER_ID</code> is not set, then all
         * "VM" fields will be discarded and "VM" fields will not be used for matching the migration task to a server in
         * Application Discovery Service repository. See the <a href=
         * "https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples"
         * >Example</a> section below for a use case of specifying "VM" related values.
         * </p>
         * </li>
         * <li>
         * <p>
         * If a server you are trying to match has multiple IP or MAC addresses, you should provide as many as you know
         * in separate type/value pairs passed to the <code>ResourceAttributeList</code> parameter to maximize the
         * chances of matching.
         * </p>
         * </li>
         * </ul>
         * </important>
         * 
         * @param resourceAttributeList
         *        Information about the resource that is being migrated. This data will be used to map the task to a
         *        resource in the Application Discovery Service repository.</p> <note>
         *        <p>
         *        Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code> field is reserved
         *        for the following values:
         *        <code>IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code>
         *        where the identifying value can be a string up to 256 characters.
         *        </p>
         *        </note> <important>
         *        <ul>
         *        <li>
         *        <p>
         *        If any "VM" related value is set for a <code>ResourceAttribute</code> object, it is required that
         *        <code>VM_MANAGER_ID</code>, as a minimum, is always set. If <code>VM_MANAGER_ID</code> is not set,
         *        then all "VM" fields will be discarded and "VM" fields will not be used for matching the migration
         *        task to a server in Application Discovery Service repository. See the <a href=
         *        "https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples"
         *        >Example</a> section below for a use case of specifying "VM" related values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If a server you are trying to match has multiple IP or MAC addresses, you should provide as many as
         *        you know in separate type/value pairs passed to the <code>ResourceAttributeList</code> parameter to
         *        maximize the chances of matching.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAttributeList(ResourceAttribute... resourceAttributeList);

        /**
         * <p>
         * Information about the resource that is being migrated. This data will be used to map the task to a resource
         * in the Application Discovery Service repository.
         * </p>
         * <note>
         * <p>
         * Takes the object array of <code>ResourceAttribute</code> where the <code>Type</code> field is reserved for
         * the following values:
         * <code>IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER</code>
         * where the identifying value can be a string up to 256 characters.
         * </p>
         * </note> <important>
         * <ul>
         * <li>
         * <p>
         * If any "VM" related value is set for a <code>ResourceAttribute</code> object, it is required that
         * <code>VM_MANAGER_ID</code>, as a minimum, is always set. If <code>VM_MANAGER_ID</code> is not set, then all
         * "VM" fields will be discarded and "VM" fields will not be used for matching the migration task to a server in
         * Application Discovery Service repository. See the <a href=
         * "https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples"
         * >Example</a> section below for a use case of specifying "VM" related values.
         * </p>
         * </li>
         * <li>
         * <p>
         * If a server you are trying to match has multiple IP or MAC addresses, you should provide as many as you know
         * in separate type/value pairs passed to the <code>ResourceAttributeList</code> parameter to maximize the
         * chances of matching.
         * </p>
         * </li>
         * </ul>
         * </important> This is a convenience that creates an instance of the {@link List<ResourceAttribute>.Builder}
         * avoiding the need to create one manually via {@link List<ResourceAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceAttribute>.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceAttributeList(List<ResourceAttribute>)}.
         * 
         * @param resourceAttributeList
         *        a consumer that will call methods on {@link List<ResourceAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAttributeList(List<ResourceAttribute>)
         */
        Builder resourceAttributeList(Consumer<ResourceAttribute.Builder>... resourceAttributeList);

        /**
         * <p>
         * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
         * permission to make the call.
         * </p>
         * 
         * @param dryRun
         *        Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
         *        permission to make the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRequest.BuilderImpl implements Builder {
        private String progressUpdateStream;

        private String migrationTaskName;

        private List<ResourceAttribute> resourceAttributeList = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourceAttributesRequest model) {
            super(model);
            progressUpdateStream(model.progressUpdateStream);
            migrationTaskName(model.migrationTaskName);
            resourceAttributeList(model.resourceAttributeList);
            dryRun(model.dryRun);
        }

        public final String getProgressUpdateStream() {
            return progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        public final String getMigrationTaskName() {
            return migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        public final Collection<ResourceAttribute.Builder> getResourceAttributeList() {
            return resourceAttributeList != null ? resourceAttributeList.stream().map(ResourceAttribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAttributeList(Collection<ResourceAttribute> resourceAttributeList) {
            this.resourceAttributeList = ResourceAttributeListCopier.copy(resourceAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAttributeList(ResourceAttribute... resourceAttributeList) {
            resourceAttributeList(Arrays.asList(resourceAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAttributeList(Consumer<ResourceAttribute.Builder>... resourceAttributeList) {
            resourceAttributeList(Stream.of(resourceAttributeList).map(c -> ResourceAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAttributeList(Collection<ResourceAttribute.BuilderImpl> resourceAttributeList) {
            this.resourceAttributeList = ResourceAttributeListCopier.copyFromBuilder(resourceAttributeList);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourceAttributesRequest build() {
            return new PutResourceAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
