/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a migration task in a migration tool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MigrationTask implements SdkPojo, Serializable, ToCopyableBuilder<MigrationTask.Builder, MigrationTask> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MigrationTask::progressUpdateStream)).setter(setter(Builder::progressUpdateStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStream").build())
            .build();

    private static final SdkField<String> MIGRATION_TASK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MigrationTask::migrationTaskName)).setter(setter(Builder::migrationTaskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskName").build()).build();

    private static final SdkField<Task> TASK_FIELD = SdkField.<Task> builder(MarshallingType.SDK_POJO)
            .getter(getter(MigrationTask::task)).setter(setter(Builder::task)).constructor(Task::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Task").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(MigrationTask::updateDateTime)).setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDateTime").build()).build();

    private static final SdkField<List<ResourceAttribute>> RESOURCE_ATTRIBUTE_LIST_FIELD = SdkField
            .<List<ResourceAttribute>> builder(MarshallingType.LIST)
            .getter(getter(MigrationTask::resourceAttributeList))
            .setter(setter(Builder::resourceAttributeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAttributeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_UPDATE_STREAM_FIELD,
            MIGRATION_TASK_NAME_FIELD, TASK_FIELD, UPDATE_DATE_TIME_FIELD, RESOURCE_ATTRIBUTE_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String progressUpdateStream;

    private final String migrationTaskName;

    private final Task task;

    private final Instant updateDateTime;

    private final List<ResourceAttribute> resourceAttributeList;

    private MigrationTask(BuilderImpl builder) {
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.task = builder.task;
        this.updateDateTime = builder.updateDateTime;
        this.resourceAttributeList = builder.resourceAttributeList;
    }

    /**
     * <p>
     * A name that identifies the vendor of the migration tool being used.
     * </p>
     * 
     * @return A name that identifies the vendor of the migration tool being used.
     */
    public String progressUpdateStream() {
        return progressUpdateStream;
    }

    /**
     * <p>
     * Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
     * </p>
     * 
     * @return Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
     */
    public String migrationTaskName() {
        return migrationTaskName;
    }

    /**
     * <p>
     * Task object encapsulating task information.
     * </p>
     * 
     * @return Task object encapsulating task information.
     */
    public Task task() {
        return task;
    }

    /**
     * <p>
     * The timestamp when the task was gathered.
     * </p>
     * 
     * @return The timestamp when the task was gathered.
     */
    public Instant updateDateTime() {
        return updateDateTime;
    }

    /**
     * Returns true if the ResourceAttributeList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResourceAttributeList() {
        return resourceAttributeList != null && !(resourceAttributeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the resource that is being migrated. This data will be used to map the task to a resource in
     * the Application Discovery Service repository.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAttributeList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the resource that is being migrated. This data will be used to map the task to a
     *         resource in the Application Discovery Service repository.
     */
    public List<ResourceAttribute> resourceAttributeList() {
        return resourceAttributeList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(task());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAttributeList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationTask)) {
            return false;
        }
        MigrationTask other = (MigrationTask) obj;
        return Objects.equals(progressUpdateStream(), other.progressUpdateStream())
                && Objects.equals(migrationTaskName(), other.migrationTaskName()) && Objects.equals(task(), other.task())
                && Objects.equals(updateDateTime(), other.updateDateTime())
                && Objects.equals(resourceAttributeList(), other.resourceAttributeList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MigrationTask").add("ProgressUpdateStream", progressUpdateStream())
                .add("MigrationTaskName", migrationTaskName()).add("Task", task()).add("UpdateDateTime", updateDateTime())
                .add("ResourceAttributeList", resourceAttributeList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressUpdateStream":
            return Optional.ofNullable(clazz.cast(progressUpdateStream()));
        case "MigrationTaskName":
            return Optional.ofNullable(clazz.cast(migrationTaskName()));
        case "Task":
            return Optional.ofNullable(clazz.cast(task()));
        case "UpdateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        case "ResourceAttributeList":
            return Optional.ofNullable(clazz.cast(resourceAttributeList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MigrationTask, T> g) {
        return obj -> g.apply((MigrationTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MigrationTask> {
        /**
         * <p>
         * A name that identifies the vendor of the migration tool being used.
         * </p>
         * 
         * @param progressUpdateStream
         *        A name that identifies the vendor of the migration tool being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressUpdateStream(String progressUpdateStream);

        /**
         * <p>
         * Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
         * </p>
         * 
         * @param migrationTaskName
         *        Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskName(String migrationTaskName);

        /**
         * <p>
         * Task object encapsulating task information.
         * </p>
         * 
         * @param task
         *        Task object encapsulating task information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder task(Task task);

        /**
         * <p>
         * Task object encapsulating task information.
         * </p>
         * This is a convenience that creates an instance of the {@link Task.Builder} avoiding the need to create one
         * manually via {@link Task#builder()}.
         *
         * When the {@link Consumer} completes, {@link Task.Builder#build()} is called immediately and its result is
         * passed to {@link #task(Task)}.
         * 
         * @param task
         *        a consumer that will call methods on {@link Task.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #task(Task)
         */
        default Builder task(Consumer<Task.Builder> task) {
            return task(Task.builder().applyMutation(task).build());
        }

        /**
         * <p>
         * The timestamp when the task was gathered.
         * </p>
         * 
         * @param updateDateTime
         *        The timestamp when the task was gathered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);

        /**
         * <p>
         * Information about the resource that is being migrated. This data will be used to map the task to a resource
         * in the Application Discovery Service repository.
         * </p>
         * 
         * @param resourceAttributeList
         *        Information about the resource that is being migrated. This data will be used to map the task to a
         *        resource in the Application Discovery Service repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAttributeList(Collection<ResourceAttribute> resourceAttributeList);

        /**
         * <p>
         * Information about the resource that is being migrated. This data will be used to map the task to a resource
         * in the Application Discovery Service repository.
         * </p>
         * 
         * @param resourceAttributeList
         *        Information about the resource that is being migrated. This data will be used to map the task to a
         *        resource in the Application Discovery Service repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAttributeList(ResourceAttribute... resourceAttributeList);

        /**
         * <p>
         * Information about the resource that is being migrated. This data will be used to map the task to a resource
         * in the Application Discovery Service repository.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceAttribute>.Builder} avoiding the
         * need to create one manually via {@link List<ResourceAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceAttribute>.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceAttributeList(List<ResourceAttribute>)}.
         * 
         * @param resourceAttributeList
         *        a consumer that will call methods on {@link List<ResourceAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAttributeList(List<ResourceAttribute>)
         */
        Builder resourceAttributeList(Consumer<ResourceAttribute.Builder>... resourceAttributeList);
    }

    static final class BuilderImpl implements Builder {
        private String progressUpdateStream;

        private String migrationTaskName;

        private Task task;

        private Instant updateDateTime;

        private List<ResourceAttribute> resourceAttributeList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MigrationTask model) {
            progressUpdateStream(model.progressUpdateStream);
            migrationTaskName(model.migrationTaskName);
            task(model.task);
            updateDateTime(model.updateDateTime);
            resourceAttributeList(model.resourceAttributeList);
        }

        public final String getProgressUpdateStream() {
            return progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        public final String getMigrationTaskName() {
            return migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        public final Task.Builder getTask() {
            return task != null ? task.toBuilder() : null;
        }

        @Override
        public final Builder task(Task task) {
            this.task = task;
            return this;
        }

        public final void setTask(Task.BuilderImpl task) {
            this.task = task != null ? task.build() : null;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        public final Collection<ResourceAttribute.Builder> getResourceAttributeList() {
            return resourceAttributeList != null ? resourceAttributeList.stream().map(ResourceAttribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAttributeList(Collection<ResourceAttribute> resourceAttributeList) {
            this.resourceAttributeList = LatestResourceAttributeListCopier.copy(resourceAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAttributeList(ResourceAttribute... resourceAttributeList) {
            resourceAttributeList(Arrays.asList(resourceAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAttributeList(Consumer<ResourceAttribute.Builder>... resourceAttributeList) {
            resourceAttributeList(Stream.of(resourceAttributeList).map(c -> ResourceAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAttributeList(Collection<ResourceAttribute.BuilderImpl> resourceAttributeList) {
            this.resourceAttributeList = LatestResourceAttributeListCopier.copyFromBuilder(resourceAttributeList);
        }

        @Override
        public MigrationTask build() {
            return new MigrationTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
