/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProgressUpdateStreamRequest extends MigrationHubRequest implements
        ToCopyableBuilder<CreateProgressUpdateStreamRequest.Builder, CreateProgressUpdateStreamRequest> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProgressUpdateStreamRequest::progressUpdateStreamName))
            .setter(setter(Builder::progressUpdateStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStreamName").build())
            .build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateProgressUpdateStreamRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROGRESS_UPDATE_STREAM_NAME_FIELD, DRY_RUN_FIELD));

    private final String progressUpdateStreamName;

    private final Boolean dryRun;

    private CreateProgressUpdateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStreamName = builder.progressUpdateStreamName;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i>
     * </p>
     * 
     * @return The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i>
     */
    public String progressUpdateStreamName() {
        return progressUpdateStreamName;
    }

    /**
     * <p>
     * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission
     * to make the call.
     * </p>
     * 
     * @return Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
     *         permission to make the call.
     */
    public Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(progressUpdateStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProgressUpdateStreamRequest)) {
            return false;
        }
        CreateProgressUpdateStreamRequest other = (CreateProgressUpdateStreamRequest) obj;
        return Objects.equals(progressUpdateStreamName(), other.progressUpdateStreamName())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateProgressUpdateStreamRequest").add("ProgressUpdateStreamName", progressUpdateStreamName())
                .add("DryRun", dryRun()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressUpdateStreamName":
            return Optional.ofNullable(clazz.cast(progressUpdateStreamName()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProgressUpdateStreamRequest, T> g) {
        return obj -> g.apply((CreateProgressUpdateStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateProgressUpdateStreamRequest> {
        /**
         * <p>
         * The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i>
         * </p>
         * 
         * @param progressUpdateStreamName
         *        The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressUpdateStreamName(String progressUpdateStreamName);

        /**
         * <p>
         * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
         * permission to make the call.
         * </p>
         * 
         * @param dryRun
         *        Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
         *        permission to make the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRequest.BuilderImpl implements Builder {
        private String progressUpdateStreamName;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProgressUpdateStreamRequest model) {
            super(model);
            progressUpdateStreamName(model.progressUpdateStreamName);
            dryRun(model.dryRun);
        }

        public final String getProgressUpdateStreamName() {
            return progressUpdateStreamName;
        }

        @Override
        public final Builder progressUpdateStreamName(String progressUpdateStreamName) {
            this.progressUpdateStreamName = progressUpdateStreamName;
            return this;
        }

        public final void setProgressUpdateStreamName(String progressUpdateStreamName) {
            this.progressUpdateStreamName = progressUpdateStreamName;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProgressUpdateStreamRequest build() {
            return new CreateProgressUpdateStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
