/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateCreatedArtifactRequest extends MigrationHubRequest implements
        ToCopyableBuilder<AssociateCreatedArtifactRequest.Builder, AssociateCreatedArtifactRequest> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateCreatedArtifactRequest::progressUpdateStream)).setter(setter(Builder::progressUpdateStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStream").build())
            .build();

    private static final SdkField<String> MIGRATION_TASK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateCreatedArtifactRequest::migrationTaskName)).setter(setter(Builder::migrationTaskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskName").build()).build();

    private static final SdkField<CreatedArtifact> CREATED_ARTIFACT_FIELD = SdkField
            .<CreatedArtifact> builder(MarshallingType.SDK_POJO).getter(getter(AssociateCreatedArtifactRequest::createdArtifact))
            .setter(setter(Builder::createdArtifact)).constructor(CreatedArtifact::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedArtifact").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AssociateCreatedArtifactRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_UPDATE_STREAM_FIELD,
            MIGRATION_TASK_NAME_FIELD, CREATED_ARTIFACT_FIELD, DRY_RUN_FIELD));

    private final String progressUpdateStream;

    private final String migrationTaskName;

    private final CreatedArtifact createdArtifact;

    private final Boolean dryRun;

    private AssociateCreatedArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.createdArtifact = builder.createdArtifact;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The name of the ProgressUpdateStream.
     * </p>
     * 
     * @return The name of the ProgressUpdateStream.
     */
    public String progressUpdateStream() {
        return progressUpdateStream;
    }

    /**
     * <p>
     * Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
     * </p>
     * 
     * @return Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
     */
    public String migrationTaskName() {
        return migrationTaskName;
    }

    /**
     * <p>
     * An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.)
     * </p>
     * 
     * @return An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.)
     */
    public CreatedArtifact createdArtifact() {
        return createdArtifact;
    }

    /**
     * <p>
     * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission
     * to make the call.
     * </p>
     * 
     * @return Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
     *         permission to make the call.
     */
    public Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(createdArtifact());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateCreatedArtifactRequest)) {
            return false;
        }
        AssociateCreatedArtifactRequest other = (AssociateCreatedArtifactRequest) obj;
        return Objects.equals(progressUpdateStream(), other.progressUpdateStream())
                && Objects.equals(migrationTaskName(), other.migrationTaskName())
                && Objects.equals(createdArtifact(), other.createdArtifact()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateCreatedArtifactRequest").add("ProgressUpdateStream", progressUpdateStream())
                .add("MigrationTaskName", migrationTaskName()).add("CreatedArtifact", createdArtifact()).add("DryRun", dryRun())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressUpdateStream":
            return Optional.ofNullable(clazz.cast(progressUpdateStream()));
        case "MigrationTaskName":
            return Optional.ofNullable(clazz.cast(migrationTaskName()));
        case "CreatedArtifact":
            return Optional.ofNullable(clazz.cast(createdArtifact()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateCreatedArtifactRequest, T> g) {
        return obj -> g.apply((AssociateCreatedArtifactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateCreatedArtifactRequest> {
        /**
         * <p>
         * The name of the ProgressUpdateStream.
         * </p>
         * 
         * @param progressUpdateStream
         *        The name of the ProgressUpdateStream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressUpdateStream(String progressUpdateStream);

        /**
         * <p>
         * Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
         * </p>
         * 
         * @param migrationTaskName
         *        Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskName(String migrationTaskName);

        /**
         * <p>
         * An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.)
         * </p>
         * 
         * @param createdArtifact
         *        An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdArtifact(CreatedArtifact createdArtifact);

        /**
         * <p>
         * An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.)
         * </p>
         * This is a convenience that creates an instance of the {@link CreatedArtifact.Builder} avoiding the need to
         * create one manually via {@link CreatedArtifact#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreatedArtifact.Builder#build()} is called immediately and its
         * result is passed to {@link #createdArtifact(CreatedArtifact)}.
         * 
         * @param createdArtifact
         *        a consumer that will call methods on {@link CreatedArtifact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdArtifact(CreatedArtifact)
         */
        default Builder createdArtifact(Consumer<CreatedArtifact.Builder> createdArtifact) {
            return createdArtifact(CreatedArtifact.builder().applyMutation(createdArtifact).build());
        }

        /**
         * <p>
         * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
         * permission to make the call.
         * </p>
         * 
         * @param dryRun
         *        Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
         *        permission to make the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRequest.BuilderImpl implements Builder {
        private String progressUpdateStream;

        private String migrationTaskName;

        private CreatedArtifact createdArtifact;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateCreatedArtifactRequest model) {
            super(model);
            progressUpdateStream(model.progressUpdateStream);
            migrationTaskName(model.migrationTaskName);
            createdArtifact(model.createdArtifact);
            dryRun(model.dryRun);
        }

        public final String getProgressUpdateStream() {
            return progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        public final String getMigrationTaskName() {
            return migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        public final CreatedArtifact.Builder getCreatedArtifact() {
            return createdArtifact != null ? createdArtifact.toBuilder() : null;
        }

        @Override
        public final Builder createdArtifact(CreatedArtifact createdArtifact) {
            this.createdArtifact = createdArtifact;
            return this;
        }

        public final void setCreatedArtifact(CreatedArtifact.BuilderImpl createdArtifact) {
            this.createdArtifact = createdArtifact != null ? createdArtifact.build() : null;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateCreatedArtifactRequest build() {
            return new AssociateCreatedArtifactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
