/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubAsyncClient;
import software.amazon.awssdk.services.migrationhub.model.DiscoveredResource;
import software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesResponse;

public class ListDiscoveredResourcesPublisher
implements SdkPublisher<ListDiscoveredResourcesResponse> {
    private final MigrationHubAsyncClient client;
    private final ListDiscoveredResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDiscoveredResourcesPublisher(MigrationHubAsyncClient client, ListDiscoveredResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDiscoveredResourcesPublisher(MigrationHubAsyncClient client, ListDiscoveredResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDiscoveredResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDiscoveredResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DiscoveredResource> discoveredResourceList() {
        Function<ListDiscoveredResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.discoveredResourceList() != null) {
                return response.discoveredResourceList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDiscoveredResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDiscoveredResourcesResponseFetcher
    implements AsyncPageFetcher<ListDiscoveredResourcesResponse> {
        private ListDiscoveredResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListDiscoveredResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDiscoveredResourcesResponse> nextPage(ListDiscoveredResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListDiscoveredResourcesPublisher.this.client.listDiscoveredResources(ListDiscoveredResourcesPublisher.this.firstRequest);
            }
            return ListDiscoveredResourcesPublisher.this.client.listDiscoveredResources((ListDiscoveredResourcesRequest)((Object)ListDiscoveredResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

