/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.migrationhub.model.Task;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TaskMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSDETAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetail").isBinary(false).build();
    private static final MarshallingInfo<Integer> PROGRESSPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProgressPercent").isBinary(false).build();
    private static final TaskMarshaller INSTANCE = new TaskMarshaller();

    private TaskMarshaller() {
    }

    public static TaskMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Task task, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)task, (String)"task");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)task.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)task.statusDetail(), STATUSDETAIL_BINDING);
            protocolMarshaller.marshall((Object)task.progressPercent(), PROGRESSPERCENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

