/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.migrationhub.model.Status;
import software.amazon.awssdk.services.migrationhub.transform.MigrationTaskSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MigrationTaskSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, MigrationTaskSummary> {
    private final String progressUpdateStream;
    private final String migrationTaskName;
    private final String status;
    private final Integer progressPercent;
    private final String statusDetail;
    private final Instant updateDateTime;

    private MigrationTaskSummary(BuilderImpl builder) {
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.status = builder.status;
        this.progressPercent = builder.progressPercent;
        this.statusDetail = builder.statusDetail;
        this.updateDateTime = builder.updateDateTime;
    }

    public String progressUpdateStream() {
        return this.progressUpdateStream;
    }

    public String migrationTaskName() {
        return this.migrationTaskName;
    }

    public Status status() {
        return Status.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Integer progressPercent() {
        return this.progressPercent;
    }

    public String statusDetail() {
        return this.statusDetail;
    }

    public Instant updateDateTime() {
        return this.updateDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationTaskSummary)) {
            return false;
        }
        MigrationTaskSummary other = (MigrationTaskSummary)obj;
        return Objects.equals(this.progressUpdateStream(), other.progressUpdateStream()) && Objects.equals(this.migrationTaskName(), other.migrationTaskName()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.progressPercent(), other.progressPercent()) && Objects.equals(this.statusDetail(), other.statusDetail()) && Objects.equals(this.updateDateTime(), other.updateDateTime());
    }

    public String toString() {
        return ToString.builder((String)"MigrationTaskSummary").add("ProgressUpdateStream", (Object)this.progressUpdateStream()).add("MigrationTaskName", (Object)this.migrationTaskName()).add("Status", (Object)this.statusString()).add("ProgressPercent", (Object)this.progressPercent()).add("StatusDetail", (Object)this.statusDetail()).add("UpdateDateTime", (Object)this.updateDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressUpdateStream": {
                return Optional.of(clazz.cast(this.progressUpdateStream()));
            }
            case "MigrationTaskName": {
                return Optional.of(clazz.cast(this.migrationTaskName()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "ProgressPercent": {
                return Optional.of(clazz.cast(this.progressPercent()));
            }
            case "StatusDetail": {
                return Optional.of(clazz.cast(this.statusDetail()));
            }
            case "UpdateDateTime": {
                return Optional.of(clazz.cast(this.updateDateTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MigrationTaskSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String progressUpdateStream;
        private String migrationTaskName;
        private String status;
        private Integer progressPercent;
        private String statusDetail;
        private Instant updateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MigrationTaskSummary model) {
            this.progressUpdateStream(model.progressUpdateStream);
            this.migrationTaskName(model.migrationTaskName);
            this.status(model.status);
            this.progressPercent(model.progressPercent);
            this.statusDetail(model.statusDetail);
            this.updateDateTime(model.updateDateTime);
        }

        public final String getProgressUpdateStream() {
            return this.progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        public final String getMigrationTaskName() {
            return this.migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getProgressPercent() {
            return this.progressPercent;
        }

        @Override
        public final Builder progressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final void setProgressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
        }

        public final String getStatusDetail() {
            return this.statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        public MigrationTaskSummary build() {
            return new MigrationTaskSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MigrationTaskSummary> {
        public Builder progressUpdateStream(String var1);

        public Builder migrationTaskName(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder progressPercent(Integer var1);

        public Builder statusDetail(String var1);

        public Builder updateDateTime(Instant var1);
    }
}

