/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDiscoveredResourcesRequest
extends MigrationHubRequest
implements ToCopyableBuilder<Builder, ListDiscoveredResourcesRequest> {
    private final String progressUpdateStream;
    private final String migrationTaskName;
    private final String nextToken;
    private final Integer maxResults;

    private ListDiscoveredResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String progressUpdateStream() {
        return this.progressUpdateStream;
    }

    public String migrationTaskName() {
        return this.migrationTaskName;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesRequest)) {
            return false;
        }
        ListDiscoveredResourcesRequest other = (ListDiscoveredResourcesRequest)((Object)obj);
        return Objects.equals(this.progressUpdateStream(), other.progressUpdateStream()) && Objects.equals(this.migrationTaskName(), other.migrationTaskName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListDiscoveredResourcesRequest").add("ProgressUpdateStream", (Object)this.progressUpdateStream()).add("MigrationTaskName", (Object)this.migrationTaskName()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressUpdateStream": {
                return Optional.of(clazz.cast(this.progressUpdateStream()));
            }
            case "MigrationTaskName": {
                return Optional.of(clazz.cast(this.migrationTaskName()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MigrationHubRequest.BuilderImpl
    implements Builder {
        private String progressUpdateStream;
        private String migrationTaskName;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoveredResourcesRequest model) {
            this.progressUpdateStream(model.progressUpdateStream);
            this.migrationTaskName(model.migrationTaskName);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getProgressUpdateStream() {
            return this.progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        public final String getMigrationTaskName() {
            return this.migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListDiscoveredResourcesRequest build() {
            return new ListDiscoveredResourcesRequest(this);
        }
    }

    public static interface Builder
    extends MigrationHubRequest.Builder,
    CopyableBuilder<Builder, ListDiscoveredResourcesRequest> {
        public Builder progressUpdateStream(String var1);

        public Builder migrationTaskName(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

