/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.migrationhub.MigrationHubClient;
import software.amazon.awssdk.services.migrationhub.model.AccessDeniedException;
import software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactRequest;
import software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactResponse;
import software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceRequest;
import software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceResponse;
import software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamRequest;
import software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamResponse;
import software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamRequest;
import software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamResponse;
import software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateRequest;
import software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateResponse;
import software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskRequest;
import software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskResponse;
import software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactRequest;
import software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactResponse;
import software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceRequest;
import software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceResponse;
import software.amazon.awssdk.services.migrationhub.model.DryRunOperationException;
import software.amazon.awssdk.services.migrationhub.model.ImportMigrationTaskRequest;
import software.amazon.awssdk.services.migrationhub.model.ImportMigrationTaskResponse;
import software.amazon.awssdk.services.migrationhub.model.InternalServerErrorException;
import software.amazon.awssdk.services.migrationhub.model.InvalidInputException;
import software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest;
import software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsResponse;
import software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksResponse;
import software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest;
import software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsResponse;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubException;
import software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateRequest;
import software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateResponse;
import software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateRequest;
import software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateResponse;
import software.amazon.awssdk.services.migrationhub.model.PolicyErrorException;
import software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesRequest;
import software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesResponse;
import software.amazon.awssdk.services.migrationhub.model.ResourceNotFoundException;
import software.amazon.awssdk.services.migrationhub.model.ServiceUnavailableException;
import software.amazon.awssdk.services.migrationhub.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.migrationhub.transform.AssociateCreatedArtifactRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.AssociateCreatedArtifactResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.AssociateDiscoveredResourceRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.AssociateDiscoveredResourceResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.CreateProgressUpdateStreamRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.CreateProgressUpdateStreamResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DeleteProgressUpdateStreamRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DeleteProgressUpdateStreamResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DescribeApplicationStateRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DescribeApplicationStateResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DescribeMigrationTaskRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DescribeMigrationTaskResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DisassociateCreatedArtifactRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DisassociateCreatedArtifactResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DisassociateDiscoveredResourceRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DisassociateDiscoveredResourceResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ImportMigrationTaskRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ImportMigrationTaskResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListCreatedArtifactsRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListCreatedArtifactsResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListDiscoveredResourcesResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListMigrationTasksRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListMigrationTasksResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListProgressUpdateStreamsRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListProgressUpdateStreamsResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.NotifyApplicationStateRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.NotifyApplicationStateResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.NotifyMigrationTaskStateRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.NotifyMigrationTaskStateResponseUnmarshaller;
import software.amazon.awssdk.services.migrationhub.transform.PutResourceAttributesRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.PutResourceAttributesResponseUnmarshaller;

@SdkInternalApi
final class DefaultMigrationHubClient
implements MigrationHubClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultMigrationHubClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "mgh";
    }

    @Override
    public AssociateCreatedArtifactResponse associateCreatedArtifact(AssociateCreatedArtifactRequest associateCreatedArtifactRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateCreatedArtifactResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AssociateCreatedArtifactResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateCreatedArtifactRequest).withMarshaller((Marshaller)new AssociateCreatedArtifactRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AssociateDiscoveredResourceResponse associateDiscoveredResource(AssociateDiscoveredResourceRequest associateDiscoveredResourceRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, PolicyErrorException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateDiscoveredResourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AssociateDiscoveredResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateDiscoveredResourceRequest).withMarshaller((Marshaller)new AssociateDiscoveredResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateProgressUpdateStreamResponse createProgressUpdateStream(CreateProgressUpdateStreamRequest createProgressUpdateStreamRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProgressUpdateStreamResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateProgressUpdateStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createProgressUpdateStreamRequest).withMarshaller((Marshaller)new CreateProgressUpdateStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteProgressUpdateStreamResponse deleteProgressUpdateStream(DeleteProgressUpdateStreamRequest deleteProgressUpdateStreamRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteProgressUpdateStreamResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteProgressUpdateStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteProgressUpdateStreamRequest).withMarshaller((Marshaller)new DeleteProgressUpdateStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeApplicationStateResponse describeApplicationState(DescribeApplicationStateRequest describeApplicationStateRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, PolicyErrorException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeApplicationStateResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeApplicationStateResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicationStateRequest).withMarshaller((Marshaller)new DescribeApplicationStateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeMigrationTaskResponse describeMigrationTask(DescribeMigrationTaskRequest describeMigrationTaskRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeMigrationTaskResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeMigrationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMigrationTaskRequest).withMarshaller((Marshaller)new DescribeMigrationTaskRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisassociateCreatedArtifactResponse disassociateCreatedArtifact(DisassociateCreatedArtifactRequest disassociateCreatedArtifactRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateCreatedArtifactResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DisassociateCreatedArtifactResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateCreatedArtifactRequest).withMarshaller((Marshaller)new DisassociateCreatedArtifactRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisassociateDiscoveredResourceResponse disassociateDiscoveredResource(DisassociateDiscoveredResourceRequest disassociateDiscoveredResourceRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateDiscoveredResourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DisassociateDiscoveredResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateDiscoveredResourceRequest).withMarshaller((Marshaller)new DisassociateDiscoveredResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ImportMigrationTaskResponse importMigrationTask(ImportMigrationTaskRequest importMigrationTaskRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ImportMigrationTaskResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ImportMigrationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importMigrationTaskRequest).withMarshaller((Marshaller)new ImportMigrationTaskRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListCreatedArtifactsResponse listCreatedArtifacts(ListCreatedArtifactsRequest listCreatedArtifactsRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCreatedArtifactsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListCreatedArtifactsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCreatedArtifactsRequest).withMarshaller((Marshaller)new ListCreatedArtifactsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListDiscoveredResourcesResponse listDiscoveredResources(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDiscoveredResourcesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListDiscoveredResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDiscoveredResourcesRequest).withMarshaller((Marshaller)new ListDiscoveredResourcesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListMigrationTasksResponse listMigrationTasks(ListMigrationTasksRequest listMigrationTasksRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, PolicyErrorException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMigrationTasksResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListMigrationTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMigrationTasksRequest).withMarshaller((Marshaller)new ListMigrationTasksRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListProgressUpdateStreamsResponse listProgressUpdateStreams(ListProgressUpdateStreamsRequest listProgressUpdateStreamsRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProgressUpdateStreamsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListProgressUpdateStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProgressUpdateStreamsRequest).withMarshaller((Marshaller)new ListProgressUpdateStreamsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public NotifyApplicationStateResponse notifyApplicationState(NotifyApplicationStateRequest notifyApplicationStateRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, PolicyErrorException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new NotifyApplicationStateResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (NotifyApplicationStateResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)notifyApplicationStateRequest).withMarshaller((Marshaller)new NotifyApplicationStateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public NotifyMigrationTaskStateResponse notifyMigrationTaskState(NotifyMigrationTaskStateRequest notifyMigrationTaskStateRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new NotifyMigrationTaskStateResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (NotifyMigrationTaskStateResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)notifyMigrationTaskStateRequest).withMarshaller((Marshaller)new NotifyMigrationTaskStateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutResourceAttributesResponse putResourceAttributes(PutResourceAttributesRequest putResourceAttributesRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, SdkServiceException, SdkClientException, MigrationHubException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutResourceAttributesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PutResourceAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putResourceAttributesRequest).withMarshaller((Marshaller)new PutResourceAttributesRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<SdkServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(MigrationHubException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedOperation").withModeledClass(UnauthorizedOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyErrorException").withModeledClass(PolicyErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DryRunOperation").withModeledClass(DryRunOperationException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

