/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.migrationhub.model.Status;
import software.amazon.awssdk.services.migrationhub.transform.TaskMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Task
implements StructuredPojo,
ToCopyableBuilder<Builder, Task> {
    private final String status;
    private final String statusDetail;
    private final Integer progressPercent;

    private Task(BuilderImpl builder) {
        this.status = builder.status;
        this.statusDetail = builder.statusDetail;
        this.progressPercent = builder.progressPercent;
    }

    public Status status() {
        return Status.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusDetail() {
        return this.statusDetail;
    }

    public Integer progressPercent() {
        return this.progressPercent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetail(), other.statusDetail()) && Objects.equals(this.progressPercent(), other.progressPercent());
    }

    public String toString() {
        return ToString.builder((String)"Task").add("Status", (Object)this.statusAsString()).add("StatusDetail", (Object)this.statusDetail()).add("ProgressPercent", (Object)this.progressPercent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDetail": {
                return Optional.ofNullable(clazz.cast(this.statusDetail()));
            }
            case "ProgressPercent": {
                return Optional.ofNullable(clazz.cast(this.progressPercent()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String statusDetail;
        private Integer progressPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(Task model) {
            this.status(model.status);
            this.statusDetail(model.statusDetail);
            this.progressPercent(model.progressPercent);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetail() {
            return this.statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        public final Integer getProgressPercent() {
            return this.progressPercent;
        }

        @Override
        public final Builder progressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final void setProgressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
        }

        public Task build() {
            return new Task(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Task> {
        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder statusDetail(String var1);

        public Builder progressPercent(Integer var1);
    }
}

