/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mgn.model.IPsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInterface> {
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("macAddress").getter(NetworkInterface.getter(NetworkInterface::macAddress)).setter(NetworkInterface.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macAddress").build()}).build();
    private static final SdkField<List<String>> IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ips").getter(NetworkInterface.getter(NetworkInterface::ips)).setter(NetworkInterface.setter(Builder::ips)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ips").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_PRIMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPrimary").getter(NetworkInterface.getter(NetworkInterface::isPrimary)).setter(NetworkInterface.setter(Builder::isPrimary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrimary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAC_ADDRESS_FIELD, IPS_FIELD, IS_PRIMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkInterface.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String macAddress;
    private final List<String> ips;
    private final Boolean isPrimary;

    private NetworkInterface(BuilderImpl builder) {
        this.macAddress = builder.macAddress;
        this.ips = builder.ips;
        this.isPrimary = builder.isPrimary;
    }

    public final String macAddress() {
        return this.macAddress;
    }

    public final boolean hasIps() {
        return this.ips != null && !(this.ips instanceof SdkAutoConstructList);
    }

    public final List<String> ips() {
        return this.ips;
    }

    public final Boolean isPrimary() {
        return this.isPrimary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIps() ? this.ips() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isPrimary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface)obj;
        return Objects.equals(this.macAddress(), other.macAddress()) && this.hasIps() == other.hasIps() && Objects.equals(this.ips(), other.ips()) && Objects.equals(this.isPrimary(), other.isPrimary());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkInterface").add("MacAddress", (Object)this.macAddress()).add("Ips", this.hasIps() ? this.ips() : null).add("IsPrimary", (Object)this.isPrimary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "macAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "ips": {
                return Optional.ofNullable(clazz.cast(this.ips()));
            }
            case "isPrimary": {
                return Optional.ofNullable(clazz.cast(this.isPrimary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("macAddress", MAC_ADDRESS_FIELD);
        map.put("ips", IPS_FIELD);
        map.put("isPrimary", IS_PRIMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String macAddress;
        private List<String> ips = DefaultSdkAutoConstructList.getInstance();
        private Boolean isPrimary;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            this.macAddress(model.macAddress);
            this.ips(model.ips);
            this.isPrimary(model.isPrimary);
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final Collection<String> getIps() {
            if (this.ips instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ips;
        }

        public final void setIps(Collection<String> ips) {
            this.ips = IPsListCopier.copy(ips);
        }

        @Override
        public final Builder ips(Collection<String> ips) {
            this.ips = IPsListCopier.copy(ips);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ips(String ... ips) {
            this.ips(Arrays.asList(ips));
            return this;
        }

        public final Boolean getIsPrimary() {
            return this.isPrimary;
        }

        public final void setIsPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
        }

        @Override
        public final Builder isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInterface> {
        public Builder macAddress(String var1);

        public Builder ips(Collection<String> var1);

        public Builder ips(String ... var1);

        public Builder isPrimary(Boolean var1);
    }
}

