/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.BootMode;
import software.amazon.awssdk.services.mgn.model.LaunchDisposition;
import software.amazon.awssdk.services.mgn.model.LaunchTemplateDiskConf;
import software.amazon.awssdk.services.mgn.model.Licensing;
import software.amazon.awssdk.services.mgn.model.MgnRequest;
import software.amazon.awssdk.services.mgn.model.PostLaunchActions;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.services.mgn.model.TargetInstanceTypeRightSizingMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLaunchConfigurationTemplateRequest
extends MgnRequest
implements ToCopyableBuilder<Builder, CreateLaunchConfigurationTemplateRequest> {
    private static final SdkField<PostLaunchActions> POST_LAUNCH_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("postLaunchActions").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::postLaunchActions)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::postLaunchActions)).constructor(PostLaunchActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postLaunchActions").build()}).build();
    private static final SdkField<Boolean> ENABLE_MAP_AUTO_TAGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableMapAutoTagging").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::enableMapAutoTagging)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::enableMapAutoTagging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableMapAutoTagging").build()}).build();
    private static final SdkField<String> MAP_AUTO_TAGGING_MPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mapAutoTaggingMpeID").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::mapAutoTaggingMpeID)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::mapAutoTaggingMpeID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapAutoTaggingMpeID").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::tags)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> LAUNCH_DISPOSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchDisposition").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::launchDispositionAsString)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::launchDisposition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDisposition").build()}).build();
    private static final SdkField<String> TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetInstanceTypeRightSizingMethod").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::targetInstanceTypeRightSizingMethodAsString)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::targetInstanceTypeRightSizingMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstanceTypeRightSizingMethod").build()}).build();
    private static final SdkField<Boolean> COPY_PRIVATE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("copyPrivateIp").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::copyPrivateIp)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::copyPrivateIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyPrivateIp").build()}).build();
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("associatePublicIpAddress").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::associatePublicIpAddress)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::associatePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatePublicIpAddress").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("copyTags").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::copyTags)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTags").build()}).build();
    private static final SdkField<Licensing> LICENSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("licensing").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::licensing)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::licensing)).constructor(Licensing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licensing").build()}).build();
    private static final SdkField<String> BOOT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bootMode").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::bootModeAsString)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::bootMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootMode").build()}).build();
    private static final SdkField<Long> SMALL_VOLUME_MAX_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("smallVolumeMaxSize").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::smallVolumeMaxSize)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::smallVolumeMaxSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smallVolumeMaxSize").build()}).build();
    private static final SdkField<LaunchTemplateDiskConf> SMALL_VOLUME_CONF_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("smallVolumeConf").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::smallVolumeConf)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::smallVolumeConf)).constructor(LaunchTemplateDiskConf::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smallVolumeConf").build()}).build();
    private static final SdkField<LaunchTemplateDiskConf> LARGE_VOLUME_CONF_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("largeVolumeConf").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::largeVolumeConf)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::largeVolumeConf)).constructor(LaunchTemplateDiskConf::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("largeVolumeConf").build()}).build();
    private static final SdkField<Boolean> ENABLE_PARAMETERS_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableParametersEncryption").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::enableParametersEncryption)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::enableParametersEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableParametersEncryption").build()}).build();
    private static final SdkField<String> PARAMETERS_ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parametersEncryptionKey").getter(CreateLaunchConfigurationTemplateRequest.getter(CreateLaunchConfigurationTemplateRequest::parametersEncryptionKey)).setter(CreateLaunchConfigurationTemplateRequest.setter(Builder::parametersEncryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parametersEncryptionKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POST_LAUNCH_ACTIONS_FIELD, ENABLE_MAP_AUTO_TAGGING_FIELD, MAP_AUTO_TAGGING_MPE_ID_FIELD, TAGS_FIELD, LAUNCH_DISPOSITION_FIELD, TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD, COPY_PRIVATE_IP_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, COPY_TAGS_FIELD, LICENSING_FIELD, BOOT_MODE_FIELD, SMALL_VOLUME_MAX_SIZE_FIELD, SMALL_VOLUME_CONF_FIELD, LARGE_VOLUME_CONF_FIELD, ENABLE_PARAMETERS_ENCRYPTION_FIELD, PARAMETERS_ENCRYPTION_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLaunchConfigurationTemplateRequest.memberNameToFieldInitializer();
    private final PostLaunchActions postLaunchActions;
    private final Boolean enableMapAutoTagging;
    private final String mapAutoTaggingMpeID;
    private final Map<String, String> tags;
    private final String launchDisposition;
    private final String targetInstanceTypeRightSizingMethod;
    private final Boolean copyPrivateIp;
    private final Boolean associatePublicIpAddress;
    private final Boolean copyTags;
    private final Licensing licensing;
    private final String bootMode;
    private final Long smallVolumeMaxSize;
    private final LaunchTemplateDiskConf smallVolumeConf;
    private final LaunchTemplateDiskConf largeVolumeConf;
    private final Boolean enableParametersEncryption;
    private final String parametersEncryptionKey;

    private CreateLaunchConfigurationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.postLaunchActions = builder.postLaunchActions;
        this.enableMapAutoTagging = builder.enableMapAutoTagging;
        this.mapAutoTaggingMpeID = builder.mapAutoTaggingMpeID;
        this.tags = builder.tags;
        this.launchDisposition = builder.launchDisposition;
        this.targetInstanceTypeRightSizingMethod = builder.targetInstanceTypeRightSizingMethod;
        this.copyPrivateIp = builder.copyPrivateIp;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.copyTags = builder.copyTags;
        this.licensing = builder.licensing;
        this.bootMode = builder.bootMode;
        this.smallVolumeMaxSize = builder.smallVolumeMaxSize;
        this.smallVolumeConf = builder.smallVolumeConf;
        this.largeVolumeConf = builder.largeVolumeConf;
        this.enableParametersEncryption = builder.enableParametersEncryption;
        this.parametersEncryptionKey = builder.parametersEncryptionKey;
    }

    public final PostLaunchActions postLaunchActions() {
        return this.postLaunchActions;
    }

    public final Boolean enableMapAutoTagging() {
        return this.enableMapAutoTagging;
    }

    public final String mapAutoTaggingMpeID() {
        return this.mapAutoTaggingMpeID;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final LaunchDisposition launchDisposition() {
        return LaunchDisposition.fromValue(this.launchDisposition);
    }

    public final String launchDispositionAsString() {
        return this.launchDisposition;
    }

    public final TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod() {
        return TargetInstanceTypeRightSizingMethod.fromValue(this.targetInstanceTypeRightSizingMethod);
    }

    public final String targetInstanceTypeRightSizingMethodAsString() {
        return this.targetInstanceTypeRightSizingMethod;
    }

    public final Boolean copyPrivateIp() {
        return this.copyPrivateIp;
    }

    public final Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public final Boolean copyTags() {
        return this.copyTags;
    }

    public final Licensing licensing() {
        return this.licensing;
    }

    public final BootMode bootMode() {
        return BootMode.fromValue(this.bootMode);
    }

    public final String bootModeAsString() {
        return this.bootMode;
    }

    public final Long smallVolumeMaxSize() {
        return this.smallVolumeMaxSize;
    }

    public final LaunchTemplateDiskConf smallVolumeConf() {
        return this.smallVolumeConf;
    }

    public final LaunchTemplateDiskConf largeVolumeConf() {
        return this.largeVolumeConf;
    }

    public final Boolean enableParametersEncryption() {
        return this.enableParametersEncryption;
    }

    public final String parametersEncryptionKey() {
        return this.parametersEncryptionKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.postLaunchActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableMapAutoTagging());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapAutoTaggingMpeID());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launchDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetInstanceTypeRightSizingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyPrivateIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.licensing());
        hashCode = 31 * hashCode + Objects.hashCode(this.bootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.smallVolumeMaxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.smallVolumeConf());
        hashCode = 31 * hashCode + Objects.hashCode(this.largeVolumeConf());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableParametersEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.parametersEncryptionKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchConfigurationTemplateRequest)) {
            return false;
        }
        CreateLaunchConfigurationTemplateRequest other = (CreateLaunchConfigurationTemplateRequest)((Object)obj);
        return Objects.equals(this.postLaunchActions(), other.postLaunchActions()) && Objects.equals(this.enableMapAutoTagging(), other.enableMapAutoTagging()) && Objects.equals(this.mapAutoTaggingMpeID(), other.mapAutoTaggingMpeID()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.launchDispositionAsString(), other.launchDispositionAsString()) && Objects.equals(this.targetInstanceTypeRightSizingMethodAsString(), other.targetInstanceTypeRightSizingMethodAsString()) && Objects.equals(this.copyPrivateIp(), other.copyPrivateIp()) && Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress()) && Objects.equals(this.copyTags(), other.copyTags()) && Objects.equals(this.licensing(), other.licensing()) && Objects.equals(this.bootModeAsString(), other.bootModeAsString()) && Objects.equals(this.smallVolumeMaxSize(), other.smallVolumeMaxSize()) && Objects.equals(this.smallVolumeConf(), other.smallVolumeConf()) && Objects.equals(this.largeVolumeConf(), other.largeVolumeConf()) && Objects.equals(this.enableParametersEncryption(), other.enableParametersEncryption()) && Objects.equals(this.parametersEncryptionKey(), other.parametersEncryptionKey());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLaunchConfigurationTemplateRequest").add("PostLaunchActions", (Object)this.postLaunchActions()).add("EnableMapAutoTagging", (Object)this.enableMapAutoTagging()).add("MapAutoTaggingMpeID", (Object)this.mapAutoTaggingMpeID()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("LaunchDisposition", (Object)this.launchDispositionAsString()).add("TargetInstanceTypeRightSizingMethod", (Object)this.targetInstanceTypeRightSizingMethodAsString()).add("CopyPrivateIp", (Object)this.copyPrivateIp()).add("AssociatePublicIpAddress", (Object)this.associatePublicIpAddress()).add("CopyTags", (Object)this.copyTags()).add("Licensing", (Object)this.licensing()).add("BootMode", (Object)this.bootModeAsString()).add("SmallVolumeMaxSize", (Object)this.smallVolumeMaxSize()).add("SmallVolumeConf", (Object)this.smallVolumeConf()).add("LargeVolumeConf", (Object)this.largeVolumeConf()).add("EnableParametersEncryption", (Object)this.enableParametersEncryption()).add("ParametersEncryptionKey", (Object)this.parametersEncryptionKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "postLaunchActions": {
                return Optional.ofNullable(clazz.cast(this.postLaunchActions()));
            }
            case "enableMapAutoTagging": {
                return Optional.ofNullable(clazz.cast(this.enableMapAutoTagging()));
            }
            case "mapAutoTaggingMpeID": {
                return Optional.ofNullable(clazz.cast(this.mapAutoTaggingMpeID()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "launchDisposition": {
                return Optional.ofNullable(clazz.cast(this.launchDispositionAsString()));
            }
            case "targetInstanceTypeRightSizingMethod": {
                return Optional.ofNullable(clazz.cast(this.targetInstanceTypeRightSizingMethodAsString()));
            }
            case "copyPrivateIp": {
                return Optional.ofNullable(clazz.cast(this.copyPrivateIp()));
            }
            case "associatePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associatePublicIpAddress()));
            }
            case "copyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "licensing": {
                return Optional.ofNullable(clazz.cast(this.licensing()));
            }
            case "bootMode": {
                return Optional.ofNullable(clazz.cast(this.bootModeAsString()));
            }
            case "smallVolumeMaxSize": {
                return Optional.ofNullable(clazz.cast(this.smallVolumeMaxSize()));
            }
            case "smallVolumeConf": {
                return Optional.ofNullable(clazz.cast(this.smallVolumeConf()));
            }
            case "largeVolumeConf": {
                return Optional.ofNullable(clazz.cast(this.largeVolumeConf()));
            }
            case "enableParametersEncryption": {
                return Optional.ofNullable(clazz.cast(this.enableParametersEncryption()));
            }
            case "parametersEncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.parametersEncryptionKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("postLaunchActions", POST_LAUNCH_ACTIONS_FIELD);
        map.put("enableMapAutoTagging", ENABLE_MAP_AUTO_TAGGING_FIELD);
        map.put("mapAutoTaggingMpeID", MAP_AUTO_TAGGING_MPE_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("launchDisposition", LAUNCH_DISPOSITION_FIELD);
        map.put("targetInstanceTypeRightSizingMethod", TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD);
        map.put("copyPrivateIp", COPY_PRIVATE_IP_FIELD);
        map.put("associatePublicIpAddress", ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD);
        map.put("copyTags", COPY_TAGS_FIELD);
        map.put("licensing", LICENSING_FIELD);
        map.put("bootMode", BOOT_MODE_FIELD);
        map.put("smallVolumeMaxSize", SMALL_VOLUME_MAX_SIZE_FIELD);
        map.put("smallVolumeConf", SMALL_VOLUME_CONF_FIELD);
        map.put("largeVolumeConf", LARGE_VOLUME_CONF_FIELD);
        map.put("enableParametersEncryption", ENABLE_PARAMETERS_ENCRYPTION_FIELD);
        map.put("parametersEncryptionKey", PARAMETERS_ENCRYPTION_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchConfigurationTemplateRequest, T> g) {
        return obj -> g.apply((CreateLaunchConfigurationTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnRequest.BuilderImpl
    implements Builder {
        private PostLaunchActions postLaunchActions;
        private Boolean enableMapAutoTagging;
        private String mapAutoTaggingMpeID;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String launchDisposition;
        private String targetInstanceTypeRightSizingMethod;
        private Boolean copyPrivateIp;
        private Boolean associatePublicIpAddress;
        private Boolean copyTags;
        private Licensing licensing;
        private String bootMode;
        private Long smallVolumeMaxSize;
        private LaunchTemplateDiskConf smallVolumeConf;
        private LaunchTemplateDiskConf largeVolumeConf;
        private Boolean enableParametersEncryption;
        private String parametersEncryptionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchConfigurationTemplateRequest model) {
            super(model);
            this.postLaunchActions(model.postLaunchActions);
            this.enableMapAutoTagging(model.enableMapAutoTagging);
            this.mapAutoTaggingMpeID(model.mapAutoTaggingMpeID);
            this.tags(model.tags);
            this.launchDisposition(model.launchDisposition);
            this.targetInstanceTypeRightSizingMethod(model.targetInstanceTypeRightSizingMethod);
            this.copyPrivateIp(model.copyPrivateIp);
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.copyTags(model.copyTags);
            this.licensing(model.licensing);
            this.bootMode(model.bootMode);
            this.smallVolumeMaxSize(model.smallVolumeMaxSize);
            this.smallVolumeConf(model.smallVolumeConf);
            this.largeVolumeConf(model.largeVolumeConf);
            this.enableParametersEncryption(model.enableParametersEncryption);
            this.parametersEncryptionKey(model.parametersEncryptionKey);
        }

        public final PostLaunchActions.Builder getPostLaunchActions() {
            return this.postLaunchActions != null ? this.postLaunchActions.toBuilder() : null;
        }

        public final void setPostLaunchActions(PostLaunchActions.BuilderImpl postLaunchActions) {
            this.postLaunchActions = postLaunchActions != null ? postLaunchActions.build() : null;
        }

        @Override
        public final Builder postLaunchActions(PostLaunchActions postLaunchActions) {
            this.postLaunchActions = postLaunchActions;
            return this;
        }

        public final Boolean getEnableMapAutoTagging() {
            return this.enableMapAutoTagging;
        }

        public final void setEnableMapAutoTagging(Boolean enableMapAutoTagging) {
            this.enableMapAutoTagging = enableMapAutoTagging;
        }

        @Override
        public final Builder enableMapAutoTagging(Boolean enableMapAutoTagging) {
            this.enableMapAutoTagging = enableMapAutoTagging;
            return this;
        }

        public final String getMapAutoTaggingMpeID() {
            return this.mapAutoTaggingMpeID;
        }

        public final void setMapAutoTaggingMpeID(String mapAutoTaggingMpeID) {
            this.mapAutoTaggingMpeID = mapAutoTaggingMpeID;
        }

        @Override
        public final Builder mapAutoTaggingMpeID(String mapAutoTaggingMpeID) {
            this.mapAutoTaggingMpeID = mapAutoTaggingMpeID;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getLaunchDisposition() {
            return this.launchDisposition;
        }

        public final void setLaunchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
        }

        @Override
        public final Builder launchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
            return this;
        }

        @Override
        public final Builder launchDisposition(LaunchDisposition launchDisposition) {
            this.launchDisposition(launchDisposition == null ? null : launchDisposition.toString());
            return this;
        }

        public final String getTargetInstanceTypeRightSizingMethod() {
            return this.targetInstanceTypeRightSizingMethod;
        }

        public final void setTargetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
            return this;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod(targetInstanceTypeRightSizingMethod == null ? null : targetInstanceTypeRightSizingMethod.toString());
            return this;
        }

        public final Boolean getCopyPrivateIp() {
            return this.copyPrivateIp;
        }

        public final void setCopyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
        }

        @Override
        public final Builder copyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
            return this;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final Licensing.Builder getLicensing() {
            return this.licensing != null ? this.licensing.toBuilder() : null;
        }

        public final void setLicensing(Licensing.BuilderImpl licensing) {
            this.licensing = licensing != null ? licensing.build() : null;
        }

        @Override
        public final Builder licensing(Licensing licensing) {
            this.licensing = licensing;
            return this;
        }

        public final String getBootMode() {
            return this.bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootMode bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        public final Long getSmallVolumeMaxSize() {
            return this.smallVolumeMaxSize;
        }

        public final void setSmallVolumeMaxSize(Long smallVolumeMaxSize) {
            this.smallVolumeMaxSize = smallVolumeMaxSize;
        }

        @Override
        public final Builder smallVolumeMaxSize(Long smallVolumeMaxSize) {
            this.smallVolumeMaxSize = smallVolumeMaxSize;
            return this;
        }

        public final LaunchTemplateDiskConf.Builder getSmallVolumeConf() {
            return this.smallVolumeConf != null ? this.smallVolumeConf.toBuilder() : null;
        }

        public final void setSmallVolumeConf(LaunchTemplateDiskConf.BuilderImpl smallVolumeConf) {
            this.smallVolumeConf = smallVolumeConf != null ? smallVolumeConf.build() : null;
        }

        @Override
        public final Builder smallVolumeConf(LaunchTemplateDiskConf smallVolumeConf) {
            this.smallVolumeConf = smallVolumeConf;
            return this;
        }

        public final LaunchTemplateDiskConf.Builder getLargeVolumeConf() {
            return this.largeVolumeConf != null ? this.largeVolumeConf.toBuilder() : null;
        }

        public final void setLargeVolumeConf(LaunchTemplateDiskConf.BuilderImpl largeVolumeConf) {
            this.largeVolumeConf = largeVolumeConf != null ? largeVolumeConf.build() : null;
        }

        @Override
        public final Builder largeVolumeConf(LaunchTemplateDiskConf largeVolumeConf) {
            this.largeVolumeConf = largeVolumeConf;
            return this;
        }

        public final Boolean getEnableParametersEncryption() {
            return this.enableParametersEncryption;
        }

        public final void setEnableParametersEncryption(Boolean enableParametersEncryption) {
            this.enableParametersEncryption = enableParametersEncryption;
        }

        @Override
        public final Builder enableParametersEncryption(Boolean enableParametersEncryption) {
            this.enableParametersEncryption = enableParametersEncryption;
            return this;
        }

        public final String getParametersEncryptionKey() {
            return this.parametersEncryptionKey;
        }

        public final void setParametersEncryptionKey(String parametersEncryptionKey) {
            this.parametersEncryptionKey = parametersEncryptionKey;
        }

        @Override
        public final Builder parametersEncryptionKey(String parametersEncryptionKey) {
            this.parametersEncryptionKey = parametersEncryptionKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLaunchConfigurationTemplateRequest build() {
            return new CreateLaunchConfigurationTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MgnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLaunchConfigurationTemplateRequest> {
        public Builder postLaunchActions(PostLaunchActions var1);

        default public Builder postLaunchActions(Consumer<PostLaunchActions.Builder> postLaunchActions) {
            return this.postLaunchActions((PostLaunchActions)((PostLaunchActions.Builder)PostLaunchActions.builder().applyMutation(postLaunchActions)).build());
        }

        public Builder enableMapAutoTagging(Boolean var1);

        public Builder mapAutoTaggingMpeID(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder launchDisposition(String var1);

        public Builder launchDisposition(LaunchDisposition var1);

        public Builder targetInstanceTypeRightSizingMethod(String var1);

        public Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod var1);

        public Builder copyPrivateIp(Boolean var1);

        public Builder associatePublicIpAddress(Boolean var1);

        public Builder copyTags(Boolean var1);

        public Builder licensing(Licensing var1);

        default public Builder licensing(Consumer<Licensing.Builder> licensing) {
            return this.licensing((Licensing)((Licensing.Builder)Licensing.builder().applyMutation(licensing)).build());
        }

        public Builder bootMode(String var1);

        public Builder bootMode(BootMode var1);

        public Builder smallVolumeMaxSize(Long var1);

        public Builder smallVolumeConf(LaunchTemplateDiskConf var1);

        default public Builder smallVolumeConf(Consumer<LaunchTemplateDiskConf.Builder> smallVolumeConf) {
            return this.smallVolumeConf((LaunchTemplateDiskConf)((LaunchTemplateDiskConf.Builder)LaunchTemplateDiskConf.builder().applyMutation(smallVolumeConf)).build());
        }

        public Builder largeVolumeConf(LaunchTemplateDiskConf var1);

        default public Builder largeVolumeConf(Consumer<LaunchTemplateDiskConf.Builder> largeVolumeConf) {
            return this.largeVolumeConf((LaunchTemplateDiskConf)((LaunchTemplateDiskConf.Builder)LaunchTemplateDiskConf.builder().applyMutation(largeVolumeConf)).build());
        }

        public Builder enableParametersEncryption(Boolean var1);

        public Builder parametersEncryptionKey(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

