/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * S3 bucket source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3BucketSource implements SdkPojo, Serializable, ToCopyableBuilder<S3BucketSource.Builder, S3BucketSource> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3Bucket").getter(getter(S3BucketSource::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final SdkField<String> S3_BUCKET_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3BucketOwner").getter(getter(S3BucketSource::s3BucketOwner)).setter(setter(Builder::s3BucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketOwner").build()).build();

    private static final SdkField<String> S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Key")
            .getter(getter(S3BucketSource::s3Key)).setter(setter(Builder::s3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD,
            S3_BUCKET_OWNER_FIELD, S3_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3Bucket;

    private final String s3BucketOwner;

    private final String s3Key;

    private S3BucketSource(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3BucketOwner = builder.s3BucketOwner;
        this.s3Key = builder.s3Key;
    }

    /**
     * <p>
     * S3 bucket source s3 bucket.
     * </p>
     * 
     * @return S3 bucket source s3 bucket.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * S3 bucket source s3 bucket owner.
     * </p>
     * 
     * @return S3 bucket source s3 bucket owner.
     */
    public final String s3BucketOwner() {
        return s3BucketOwner;
    }

    /**
     * <p>
     * S3 bucket source s3 key.
     * </p>
     * 
     * @return S3 bucket source s3 key.
     */
    public final String s3Key() {
        return s3Key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(s3Key());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketSource)) {
            return false;
        }
        S3BucketSource other = (S3BucketSource) obj;
        return Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3BucketOwner(), other.s3BucketOwner())
                && Objects.equals(s3Key(), other.s3Key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3BucketSource").add("S3Bucket", s3Bucket()).add("S3BucketOwner", s3BucketOwner())
                .add("S3Key", s3Key()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "s3BucketOwner":
            return Optional.ofNullable(clazz.cast(s3BucketOwner()));
        case "s3Key":
            return Optional.ofNullable(clazz.cast(s3Key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Bucket", S3_BUCKET_FIELD);
        map.put("s3BucketOwner", S3_BUCKET_OWNER_FIELD);
        map.put("s3Key", S3_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3BucketSource, T> g) {
        return obj -> g.apply((S3BucketSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3BucketSource> {
        /**
         * <p>
         * S3 bucket source s3 bucket.
         * </p>
         * 
         * @param s3Bucket
         *        S3 bucket source s3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * S3 bucket source s3 bucket owner.
         * </p>
         * 
         * @param s3BucketOwner
         *        S3 bucket source s3 bucket owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketOwner(String s3BucketOwner);

        /**
         * <p>
         * S3 bucket source s3 key.
         * </p>
         * 
         * @param s3Key
         *        S3 bucket source s3 key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);
    }

    static final class BuilderImpl implements Builder {
        private String s3Bucket;

        private String s3BucketOwner;

        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketSource model) {
            s3Bucket(model.s3Bucket);
            s3BucketOwner(model.s3BucketOwner);
            s3Key(model.s3Key);
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3BucketOwner() {
            return s3BucketOwner;
        }

        public final void setS3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
        }

        @Override
        public final Builder s3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
            return this;
        }

        public final String getS3Key() {
            return s3Key;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        @Override
        public S3BucketSource build() {
            return new S3BucketSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
