/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTemplateActionsRequest extends MgnRequest implements
        ToCopyableBuilder<ListTemplateActionsRequest.Builder, ListTemplateActionsRequest> {
    private static final SdkField<TemplateActionsRequestFilters> FILTERS_FIELD = SdkField
            .<TemplateActionsRequestFilters> builder(MarshallingType.SDK_POJO).memberName("filters")
            .getter(getter(ListTemplateActionsRequest::filters)).setter(setter(Builder::filters))
            .constructor(TemplateActionsRequestFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build()).build();

    private static final SdkField<String> LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("launchConfigurationTemplateID")
            .getter(getter(ListTemplateActionsRequest::launchConfigurationTemplateID))
            .setter(setter(Builder::launchConfigurationTemplateID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfigurationTemplateID")
                    .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListTemplateActionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTemplateActionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TemplateActionsRequestFilters filters;

    private final String launchConfigurationTemplateID;

    private final Integer maxResults;

    private final String nextToken;

    private ListTemplateActionsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.launchConfigurationTemplateID = builder.launchConfigurationTemplateID;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Filters to apply when listing template post migration custom actions.
     * </p>
     * 
     * @return Filters to apply when listing template post migration custom actions.
     */
    public final TemplateActionsRequestFilters filters() {
        return filters;
    }

    /**
     * <p>
     * Launch configuration template ID.
     * </p>
     * 
     * @return Launch configuration template ID.
     */
    public final String launchConfigurationTemplateID() {
        return launchConfigurationTemplateID;
    }

    /**
     * <p>
     * Maximum amount of items to return when listing template post migration custom actions.
     * </p>
     * 
     * @return Maximum amount of items to return when listing template post migration custom actions.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Next token to use when listing template post migration custom actions.
     * </p>
     * 
     * @return Next token to use when listing template post migration custom actions.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplateActionsRequest)) {
            return false;
        }
        ListTemplateActionsRequest other = (ListTemplateActionsRequest) obj;
        return Objects.equals(filters(), other.filters())
                && Objects.equals(launchConfigurationTemplateID(), other.launchConfigurationTemplateID())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTemplateActionsRequest").add("Filters", filters())
                .add("LaunchConfigurationTemplateID", launchConfigurationTemplateID()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "launchConfigurationTemplateID":
            return Optional.ofNullable(clazz.cast(launchConfigurationTemplateID()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filters", FILTERS_FIELD);
        map.put("launchConfigurationTemplateID", LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTemplateActionsRequest, T> g) {
        return obj -> g.apply((ListTemplateActionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MgnRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTemplateActionsRequest> {
        /**
         * <p>
         * Filters to apply when listing template post migration custom actions.
         * </p>
         * 
         * @param filters
         *        Filters to apply when listing template post migration custom actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(TemplateActionsRequestFilters filters);

        /**
         * <p>
         * Filters to apply when listing template post migration custom actions.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateActionsRequestFilters.Builder}
         * avoiding the need to create one manually via {@link TemplateActionsRequestFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateActionsRequestFilters.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(TemplateActionsRequestFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link TemplateActionsRequestFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(TemplateActionsRequestFilters)
         */
        default Builder filters(Consumer<TemplateActionsRequestFilters.Builder> filters) {
            return filters(TemplateActionsRequestFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * Launch configuration template ID.
         * </p>
         * 
         * @param launchConfigurationTemplateID
         *        Launch configuration template ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationTemplateID(String launchConfigurationTemplateID);

        /**
         * <p>
         * Maximum amount of items to return when listing template post migration custom actions.
         * </p>
         * 
         * @param maxResults
         *        Maximum amount of items to return when listing template post migration custom actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Next token to use when listing template post migration custom actions.
         * </p>
         * 
         * @param nextToken
         *        Next token to use when listing template post migration custom actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private TemplateActionsRequestFilters filters;

        private String launchConfigurationTemplateID;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplateActionsRequest model) {
            super(model);
            filters(model.filters);
            launchConfigurationTemplateID(model.launchConfigurationTemplateID);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final TemplateActionsRequestFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(TemplateActionsRequestFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(TemplateActionsRequestFilters filters) {
            this.filters = filters;
            return this;
        }

        public final String getLaunchConfigurationTemplateID() {
            return launchConfigurationTemplateID;
        }

        public final void setLaunchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
        }

        @Override
        public final Builder launchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTemplateActionsRequest build() {
            return new ListTemplateActionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
