/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSourceServerActionsRequest extends MgnRequest implements
        ToCopyableBuilder<ListSourceServerActionsRequest.Builder, ListSourceServerActionsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountID").getter(getter(ListSourceServerActionsRequest::accountID)).setter(setter(Builder::accountID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountID").build()).build();

    private static final SdkField<SourceServerActionsRequestFilters> FILTERS_FIELD = SdkField
            .<SourceServerActionsRequestFilters> builder(MarshallingType.SDK_POJO).memberName("filters")
            .getter(getter(ListSourceServerActionsRequest::filters)).setter(setter(Builder::filters))
            .constructor(SourceServerActionsRequestFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSourceServerActionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSourceServerActionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(ListSourceServerActionsRequest::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SOURCE_SERVER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountID;

    private final SourceServerActionsRequestFilters filters;

    private final Integer maxResults;

    private final String nextToken;

    private final String sourceServerID;

    private ListSourceServerActionsRequest(BuilderImpl builder) {
        super(builder);
        this.accountID = builder.accountID;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sourceServerID = builder.sourceServerID;
    }

    /**
     * <p>
     * Account ID to return when listing source server post migration custom actions.
     * </p>
     * 
     * @return Account ID to return when listing source server post migration custom actions.
     */
    public final String accountID() {
        return accountID;
    }

    /**
     * <p>
     * Filters to apply when listing source server post migration custom actions.
     * </p>
     * 
     * @return Filters to apply when listing source server post migration custom actions.
     */
    public final SourceServerActionsRequestFilters filters() {
        return filters;
    }

    /**
     * <p>
     * Maximum amount of items to return when listing source server post migration custom actions.
     * </p>
     * 
     * @return Maximum amount of items to return when listing source server post migration custom actions.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Next token to use when listing source server post migration custom actions.
     * </p>
     * 
     * @return Next token to use when listing source server post migration custom actions.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Source server ID.
     * </p>
     * 
     * @return Source server ID.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountID());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSourceServerActionsRequest)) {
            return false;
        }
        ListSourceServerActionsRequest other = (ListSourceServerActionsRequest) obj;
        return Objects.equals(accountID(), other.accountID()) && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(sourceServerID(), other.sourceServerID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSourceServerActionsRequest").add("AccountID", accountID()).add("Filters", filters())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("SourceServerID", sourceServerID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountID":
            return Optional.ofNullable(clazz.cast(accountID()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountID", ACCOUNT_ID_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sourceServerID", SOURCE_SERVER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSourceServerActionsRequest, T> g) {
        return obj -> g.apply((ListSourceServerActionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MgnRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSourceServerActionsRequest> {
        /**
         * <p>
         * Account ID to return when listing source server post migration custom actions.
         * </p>
         * 
         * @param accountID
         *        Account ID to return when listing source server post migration custom actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountID(String accountID);

        /**
         * <p>
         * Filters to apply when listing source server post migration custom actions.
         * </p>
         * 
         * @param filters
         *        Filters to apply when listing source server post migration custom actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SourceServerActionsRequestFilters filters);

        /**
         * <p>
         * Filters to apply when listing source server post migration custom actions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SourceServerActionsRequestFilters.Builder} avoiding the need to create one manually via
         * {@link SourceServerActionsRequestFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceServerActionsRequestFilters.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(SourceServerActionsRequestFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link SourceServerActionsRequestFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(SourceServerActionsRequestFilters)
         */
        default Builder filters(Consumer<SourceServerActionsRequestFilters.Builder> filters) {
            return filters(SourceServerActionsRequestFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * Maximum amount of items to return when listing source server post migration custom actions.
         * </p>
         * 
         * @param maxResults
         *        Maximum amount of items to return when listing source server post migration custom actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Next token to use when listing source server post migration custom actions.
         * </p>
         * 
         * @param nextToken
         *        Next token to use when listing source server post migration custom actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Source server ID.
         * </p>
         * 
         * @param sourceServerID
         *        Source server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private String accountID;

        private SourceServerActionsRequestFilters filters;

        private Integer maxResults;

        private String nextToken;

        private String sourceServerID;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSourceServerActionsRequest model) {
            super(model);
            accountID(model.accountID);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sourceServerID(model.sourceServerID);
        }

        public final String getAccountID() {
            return accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final SourceServerActionsRequestFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(SourceServerActionsRequestFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(SourceServerActionsRequestFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSourceServerActionsRequest build() {
            return new ListSourceServerActionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
