/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicationConfigurationTemplateRequest extends MgnRequest implements
        ToCopyableBuilder<CreateReplicationConfigurationTemplateRequest.Builder, CreateReplicationConfigurationTemplateRequest> {
    private static final SdkField<Boolean> ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("associateDefaultSecurityGroup")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::associateDefaultSecurityGroup))
            .setter(setter(Builder::associateDefaultSecurityGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associateDefaultSecurityGroup")
                    .build()).build();

    private static final SdkField<Long> BANDWIDTH_THROTTLING_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("bandwidthThrottling").getter(getter(CreateReplicationConfigurationTemplateRequest::bandwidthThrottling))
            .setter(setter(Builder::bandwidthThrottling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidthThrottling").build())
            .build();

    private static final SdkField<Boolean> CREATE_PUBLIC_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("createPublicIP").getter(getter(CreateReplicationConfigurationTemplateRequest::createPublicIP))
            .setter(setter(Builder::createPublicIP))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createPublicIP").build()).build();

    private static final SdkField<String> DATA_PLANE_ROUTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataPlaneRouting")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::dataPlaneRoutingAsString))
            .setter(setter(Builder::dataPlaneRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPlaneRouting").build()).build();

    private static final SdkField<String> DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultLargeStagingDiskType")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::defaultLargeStagingDiskTypeAsString))
            .setter(setter(Builder::defaultLargeStagingDiskType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultLargeStagingDiskType")
                    .build()).build();

    private static final SdkField<String> EBS_ENCRYPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ebsEncryption").getter(getter(CreateReplicationConfigurationTemplateRequest::ebsEncryptionAsString))
            .setter(setter(Builder::ebsEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsEncryption").build()).build();

    private static final SdkField<String> EBS_ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ebsEncryptionKeyArn").getter(getter(CreateReplicationConfigurationTemplateRequest::ebsEncryptionKeyArn))
            .setter(setter(Builder::ebsEncryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsEncryptionKeyArn").build())
            .build();

    private static final SdkField<String> REPLICATION_SERVER_INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("replicationServerInstanceType")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::replicationServerInstanceType))
            .setter(setter(Builder::replicationServerInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationServerInstanceType")
                    .build()).build();

    private static final SdkField<List<String>> REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("replicationServersSecurityGroupsIDs")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::replicationServersSecurityGroupsIDs))
            .setter(setter(Builder::replicationServersSecurityGroupsIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("replicationServersSecurityGroupsIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STAGING_AREA_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stagingAreaSubnetId").getter(getter(CreateReplicationConfigurationTemplateRequest::stagingAreaSubnetId))
            .setter(setter(Builder::stagingAreaSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAreaSubnetId").build())
            .build();

    private static final SdkField<Map<String, String>> STAGING_AREA_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("stagingAreaTags")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::stagingAreaTags))
            .setter(setter(Builder::stagingAreaTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAreaTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> USE_DEDICATED_REPLICATION_SERVER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useDedicatedReplicationServer")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::useDedicatedReplicationServer))
            .setter(setter(Builder::useDedicatedReplicationServer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDedicatedReplicationServer")
                    .build()).build();

    private static final SdkField<Boolean> USE_FIPS_ENDPOINT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useFipsEndpoint").getter(getter(CreateReplicationConfigurationTemplateRequest::useFipsEndpoint))
            .setter(setter(Builder::useFipsEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useFipsEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD, BANDWIDTH_THROTTLING_FIELD, CREATE_PUBLIC_IP_FIELD, DATA_PLANE_ROUTING_FIELD,
            DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD, EBS_ENCRYPTION_FIELD, EBS_ENCRYPTION_KEY_ARN_FIELD,
            REPLICATION_SERVER_INSTANCE_TYPE_FIELD, REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD, STAGING_AREA_SUBNET_ID_FIELD,
            STAGING_AREA_TAGS_FIELD, TAGS_FIELD, USE_DEDICATED_REPLICATION_SERVER_FIELD, USE_FIPS_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean associateDefaultSecurityGroup;

    private final Long bandwidthThrottling;

    private final Boolean createPublicIP;

    private final String dataPlaneRouting;

    private final String defaultLargeStagingDiskType;

    private final String ebsEncryption;

    private final String ebsEncryptionKeyArn;

    private final String replicationServerInstanceType;

    private final List<String> replicationServersSecurityGroupsIDs;

    private final String stagingAreaSubnetId;

    private final Map<String, String> stagingAreaTags;

    private final Map<String, String> tags;

    private final Boolean useDedicatedReplicationServer;

    private final Boolean useFipsEndpoint;

    private CreateReplicationConfigurationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.associateDefaultSecurityGroup = builder.associateDefaultSecurityGroup;
        this.bandwidthThrottling = builder.bandwidthThrottling;
        this.createPublicIP = builder.createPublicIP;
        this.dataPlaneRouting = builder.dataPlaneRouting;
        this.defaultLargeStagingDiskType = builder.defaultLargeStagingDiskType;
        this.ebsEncryption = builder.ebsEncryption;
        this.ebsEncryptionKeyArn = builder.ebsEncryptionKeyArn;
        this.replicationServerInstanceType = builder.replicationServerInstanceType;
        this.replicationServersSecurityGroupsIDs = builder.replicationServersSecurityGroupsIDs;
        this.stagingAreaSubnetId = builder.stagingAreaSubnetId;
        this.stagingAreaTags = builder.stagingAreaTags;
        this.tags = builder.tags;
        this.useDedicatedReplicationServer = builder.useDedicatedReplicationServer;
        this.useFipsEndpoint = builder.useFipsEndpoint;
    }

    /**
     * <p>
     * Request to associate the default Application Migration Service Security group with the Replication Settings
     * template.
     * </p>
     * 
     * @return Request to associate the default Application Migration Service Security group with the Replication
     *         Settings template.
     */
    public final Boolean associateDefaultSecurityGroup() {
        return associateDefaultSecurityGroup;
    }

    /**
     * <p>
     * Request to configure bandwidth throttling during Replication Settings template creation.
     * </p>
     * 
     * @return Request to configure bandwidth throttling during Replication Settings template creation.
     */
    public final Long bandwidthThrottling() {
        return bandwidthThrottling;
    }

    /**
     * <p>
     * Request to create Public IP during Replication Settings template creation.
     * </p>
     * 
     * @return Request to create Public IP during Replication Settings template creation.
     */
    public final Boolean createPublicIP() {
        return createPublicIP;
    }

    /**
     * <p>
     * Request to configure data plane routing during Replication Settings template creation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataPlaneRouting}
     * will return {@link ReplicationConfigurationDataPlaneRouting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #dataPlaneRoutingAsString}.
     * </p>
     * 
     * @return Request to configure data plane routing during Replication Settings template creation.
     * @see ReplicationConfigurationDataPlaneRouting
     */
    public final ReplicationConfigurationDataPlaneRouting dataPlaneRouting() {
        return ReplicationConfigurationDataPlaneRouting.fromValue(dataPlaneRouting);
    }

    /**
     * <p>
     * Request to configure data plane routing during Replication Settings template creation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataPlaneRouting}
     * will return {@link ReplicationConfigurationDataPlaneRouting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #dataPlaneRoutingAsString}.
     * </p>
     * 
     * @return Request to configure data plane routing during Replication Settings template creation.
     * @see ReplicationConfigurationDataPlaneRouting
     */
    public final String dataPlaneRoutingAsString() {
        return dataPlaneRouting;
    }

    /**
     * <p>
     * Request to configure the default large staging disk EBS volume type during Replication Settings template
     * creation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultLargeStagingDiskType} will return
     * {@link ReplicationConfigurationDefaultLargeStagingDiskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultLargeStagingDiskTypeAsString}.
     * </p>
     * 
     * @return Request to configure the default large staging disk EBS volume type during Replication Settings template
     *         creation.
     * @see ReplicationConfigurationDefaultLargeStagingDiskType
     */
    public final ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType() {
        return ReplicationConfigurationDefaultLargeStagingDiskType.fromValue(defaultLargeStagingDiskType);
    }

    /**
     * <p>
     * Request to configure the default large staging disk EBS volume type during Replication Settings template
     * creation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultLargeStagingDiskType} will return
     * {@link ReplicationConfigurationDefaultLargeStagingDiskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultLargeStagingDiskTypeAsString}.
     * </p>
     * 
     * @return Request to configure the default large staging disk EBS volume type during Replication Settings template
     *         creation.
     * @see ReplicationConfigurationDefaultLargeStagingDiskType
     */
    public final String defaultLargeStagingDiskTypeAsString() {
        return defaultLargeStagingDiskType;
    }

    /**
     * <p>
     * Request to configure EBS encryption during Replication Settings template creation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebsEncryption}
     * will return {@link ReplicationConfigurationEbsEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #ebsEncryptionAsString}.
     * </p>
     * 
     * @return Request to configure EBS encryption during Replication Settings template creation.
     * @see ReplicationConfigurationEbsEncryption
     */
    public final ReplicationConfigurationEbsEncryption ebsEncryption() {
        return ReplicationConfigurationEbsEncryption.fromValue(ebsEncryption);
    }

    /**
     * <p>
     * Request to configure EBS encryption during Replication Settings template creation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebsEncryption}
     * will return {@link ReplicationConfigurationEbsEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #ebsEncryptionAsString}.
     * </p>
     * 
     * @return Request to configure EBS encryption during Replication Settings template creation.
     * @see ReplicationConfigurationEbsEncryption
     */
    public final String ebsEncryptionAsString() {
        return ebsEncryption;
    }

    /**
     * <p>
     * Request to configure an EBS encryption key during Replication Settings template creation.
     * </p>
     * 
     * @return Request to configure an EBS encryption key during Replication Settings template creation.
     */
    public final String ebsEncryptionKeyArn() {
        return ebsEncryptionKeyArn;
    }

    /**
     * <p>
     * Request to configure the Replication Server instance type during Replication Settings template creation.
     * </p>
     * 
     * @return Request to configure the Replication Server instance type during Replication Settings template creation.
     */
    public final String replicationServerInstanceType() {
        return replicationServerInstanceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationServersSecurityGroupsIDs
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReplicationServersSecurityGroupsIDs() {
        return replicationServersSecurityGroupsIDs != null
                && !(replicationServersSecurityGroupsIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Request to configure the Replication Server Security group ID during Replication Settings template creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationServersSecurityGroupsIDs}
     * method.
     * </p>
     * 
     * @return Request to configure the Replication Server Security group ID during Replication Settings template
     *         creation.
     */
    public final List<String> replicationServersSecurityGroupsIDs() {
        return replicationServersSecurityGroupsIDs;
    }

    /**
     * <p>
     * Request to configure the Staging Area subnet ID during Replication Settings template creation.
     * </p>
     * 
     * @return Request to configure the Staging Area subnet ID during Replication Settings template creation.
     */
    public final String stagingAreaSubnetId() {
        return stagingAreaSubnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the StagingAreaTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStagingAreaTags() {
        return stagingAreaTags != null && !(stagingAreaTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Request to configure Staging Area tags during Replication Settings template creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStagingAreaTags} method.
     * </p>
     * 
     * @return Request to configure Staging Area tags during Replication Settings template creation.
     */
    public final Map<String, String> stagingAreaTags() {
        return stagingAreaTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Request to configure tags during Replication Settings template creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Request to configure tags during Replication Settings template creation.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Request to use Dedicated Replication Servers during Replication Settings template creation.
     * </p>
     * 
     * @return Request to use Dedicated Replication Servers during Replication Settings template creation.
     */
    public final Boolean useDedicatedReplicationServer() {
        return useDedicatedReplicationServer;
    }

    /**
     * <p>
     * Request to use Fips Endpoint during Replication Settings template creation.
     * </p>
     * 
     * @return Request to use Fips Endpoint during Replication Settings template creation.
     */
    public final Boolean useFipsEndpoint() {
        return useFipsEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associateDefaultSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(bandwidthThrottling());
        hashCode = 31 * hashCode + Objects.hashCode(createPublicIP());
        hashCode = 31 * hashCode + Objects.hashCode(dataPlaneRoutingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultLargeStagingDiskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ebsEncryptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ebsEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationServerInstanceType());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReplicationServersSecurityGroupsIDs() ? replicationServersSecurityGroupsIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stagingAreaSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasStagingAreaTags() ? stagingAreaTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(useDedicatedReplicationServer());
        hashCode = 31 * hashCode + Objects.hashCode(useFipsEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationConfigurationTemplateRequest)) {
            return false;
        }
        CreateReplicationConfigurationTemplateRequest other = (CreateReplicationConfigurationTemplateRequest) obj;
        return Objects.equals(associateDefaultSecurityGroup(), other.associateDefaultSecurityGroup())
                && Objects.equals(bandwidthThrottling(), other.bandwidthThrottling())
                && Objects.equals(createPublicIP(), other.createPublicIP())
                && Objects.equals(dataPlaneRoutingAsString(), other.dataPlaneRoutingAsString())
                && Objects.equals(defaultLargeStagingDiskTypeAsString(), other.defaultLargeStagingDiskTypeAsString())
                && Objects.equals(ebsEncryptionAsString(), other.ebsEncryptionAsString())
                && Objects.equals(ebsEncryptionKeyArn(), other.ebsEncryptionKeyArn())
                && Objects.equals(replicationServerInstanceType(), other.replicationServerInstanceType())
                && hasReplicationServersSecurityGroupsIDs() == other.hasReplicationServersSecurityGroupsIDs()
                && Objects.equals(replicationServersSecurityGroupsIDs(), other.replicationServersSecurityGroupsIDs())
                && Objects.equals(stagingAreaSubnetId(), other.stagingAreaSubnetId())
                && hasStagingAreaTags() == other.hasStagingAreaTags()
                && Objects.equals(stagingAreaTags(), other.stagingAreaTags()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(useDedicatedReplicationServer(), other.useDedicatedReplicationServer())
                && Objects.equals(useFipsEndpoint(), other.useFipsEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateReplicationConfigurationTemplateRequest")
                .add("AssociateDefaultSecurityGroup", associateDefaultSecurityGroup())
                .add("BandwidthThrottling", bandwidthThrottling())
                .add("CreatePublicIP", createPublicIP())
                .add("DataPlaneRouting", dataPlaneRoutingAsString())
                .add("DefaultLargeStagingDiskType", defaultLargeStagingDiskTypeAsString())
                .add("EbsEncryption", ebsEncryptionAsString())
                .add("EbsEncryptionKeyArn", ebsEncryptionKeyArn())
                .add("ReplicationServerInstanceType", replicationServerInstanceType())
                .add("ReplicationServersSecurityGroupsIDs",
                        hasReplicationServersSecurityGroupsIDs() ? replicationServersSecurityGroupsIDs() : null)
                .add("StagingAreaSubnetId", stagingAreaSubnetId())
                .add("StagingAreaTags", stagingAreaTags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UseDedicatedReplicationServer", useDedicatedReplicationServer()).add("UseFipsEndpoint", useFipsEndpoint())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associateDefaultSecurityGroup":
            return Optional.ofNullable(clazz.cast(associateDefaultSecurityGroup()));
        case "bandwidthThrottling":
            return Optional.ofNullable(clazz.cast(bandwidthThrottling()));
        case "createPublicIP":
            return Optional.ofNullable(clazz.cast(createPublicIP()));
        case "dataPlaneRouting":
            return Optional.ofNullable(clazz.cast(dataPlaneRoutingAsString()));
        case "defaultLargeStagingDiskType":
            return Optional.ofNullable(clazz.cast(defaultLargeStagingDiskTypeAsString()));
        case "ebsEncryption":
            return Optional.ofNullable(clazz.cast(ebsEncryptionAsString()));
        case "ebsEncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(ebsEncryptionKeyArn()));
        case "replicationServerInstanceType":
            return Optional.ofNullable(clazz.cast(replicationServerInstanceType()));
        case "replicationServersSecurityGroupsIDs":
            return Optional.ofNullable(clazz.cast(replicationServersSecurityGroupsIDs()));
        case "stagingAreaSubnetId":
            return Optional.ofNullable(clazz.cast(stagingAreaSubnetId()));
        case "stagingAreaTags":
            return Optional.ofNullable(clazz.cast(stagingAreaTags()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "useDedicatedReplicationServer":
            return Optional.ofNullable(clazz.cast(useDedicatedReplicationServer()));
        case "useFipsEndpoint":
            return Optional.ofNullable(clazz.cast(useFipsEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associateDefaultSecurityGroup", ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD);
        map.put("bandwidthThrottling", BANDWIDTH_THROTTLING_FIELD);
        map.put("createPublicIP", CREATE_PUBLIC_IP_FIELD);
        map.put("dataPlaneRouting", DATA_PLANE_ROUTING_FIELD);
        map.put("defaultLargeStagingDiskType", DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD);
        map.put("ebsEncryption", EBS_ENCRYPTION_FIELD);
        map.put("ebsEncryptionKeyArn", EBS_ENCRYPTION_KEY_ARN_FIELD);
        map.put("replicationServerInstanceType", REPLICATION_SERVER_INSTANCE_TYPE_FIELD);
        map.put("replicationServersSecurityGroupsIDs", REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD);
        map.put("stagingAreaSubnetId", STAGING_AREA_SUBNET_ID_FIELD);
        map.put("stagingAreaTags", STAGING_AREA_TAGS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("useDedicatedReplicationServer", USE_DEDICATED_REPLICATION_SERVER_FIELD);
        map.put("useFipsEndpoint", USE_FIPS_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationConfigurationTemplateRequest, T> g) {
        return obj -> g.apply((CreateReplicationConfigurationTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MgnRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateReplicationConfigurationTemplateRequest> {
        /**
         * <p>
         * Request to associate the default Application Migration Service Security group with the Replication Settings
         * template.
         * </p>
         * 
         * @param associateDefaultSecurityGroup
         *        Request to associate the default Application Migration Service Security group with the Replication
         *        Settings template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup);

        /**
         * <p>
         * Request to configure bandwidth throttling during Replication Settings template creation.
         * </p>
         * 
         * @param bandwidthThrottling
         *        Request to configure bandwidth throttling during Replication Settings template creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidthThrottling(Long bandwidthThrottling);

        /**
         * <p>
         * Request to create Public IP during Replication Settings template creation.
         * </p>
         * 
         * @param createPublicIP
         *        Request to create Public IP during Replication Settings template creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createPublicIP(Boolean createPublicIP);

        /**
         * <p>
         * Request to configure data plane routing during Replication Settings template creation.
         * </p>
         * 
         * @param dataPlaneRouting
         *        Request to configure data plane routing during Replication Settings template creation.
         * @see ReplicationConfigurationDataPlaneRouting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationDataPlaneRouting
         */
        Builder dataPlaneRouting(String dataPlaneRouting);

        /**
         * <p>
         * Request to configure data plane routing during Replication Settings template creation.
         * </p>
         * 
         * @param dataPlaneRouting
         *        Request to configure data plane routing during Replication Settings template creation.
         * @see ReplicationConfigurationDataPlaneRouting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationDataPlaneRouting
         */
        Builder dataPlaneRouting(ReplicationConfigurationDataPlaneRouting dataPlaneRouting);

        /**
         * <p>
         * Request to configure the default large staging disk EBS volume type during Replication Settings template
         * creation.
         * </p>
         * 
         * @param defaultLargeStagingDiskType
         *        Request to configure the default large staging disk EBS volume type during Replication Settings
         *        template creation.
         * @see ReplicationConfigurationDefaultLargeStagingDiskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationDefaultLargeStagingDiskType
         */
        Builder defaultLargeStagingDiskType(String defaultLargeStagingDiskType);

        /**
         * <p>
         * Request to configure the default large staging disk EBS volume type during Replication Settings template
         * creation.
         * </p>
         * 
         * @param defaultLargeStagingDiskType
         *        Request to configure the default large staging disk EBS volume type during Replication Settings
         *        template creation.
         * @see ReplicationConfigurationDefaultLargeStagingDiskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationDefaultLargeStagingDiskType
         */
        Builder defaultLargeStagingDiskType(ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType);

        /**
         * <p>
         * Request to configure EBS encryption during Replication Settings template creation.
         * </p>
         * 
         * @param ebsEncryption
         *        Request to configure EBS encryption during Replication Settings template creation.
         * @see ReplicationConfigurationEbsEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationEbsEncryption
         */
        Builder ebsEncryption(String ebsEncryption);

        /**
         * <p>
         * Request to configure EBS encryption during Replication Settings template creation.
         * </p>
         * 
         * @param ebsEncryption
         *        Request to configure EBS encryption during Replication Settings template creation.
         * @see ReplicationConfigurationEbsEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationEbsEncryption
         */
        Builder ebsEncryption(ReplicationConfigurationEbsEncryption ebsEncryption);

        /**
         * <p>
         * Request to configure an EBS encryption key during Replication Settings template creation.
         * </p>
         * 
         * @param ebsEncryptionKeyArn
         *        Request to configure an EBS encryption key during Replication Settings template creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsEncryptionKeyArn(String ebsEncryptionKeyArn);

        /**
         * <p>
         * Request to configure the Replication Server instance type during Replication Settings template creation.
         * </p>
         * 
         * @param replicationServerInstanceType
         *        Request to configure the Replication Server instance type during Replication Settings template
         *        creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationServerInstanceType(String replicationServerInstanceType);

        /**
         * <p>
         * Request to configure the Replication Server Security group ID during Replication Settings template creation.
         * </p>
         * 
         * @param replicationServersSecurityGroupsIDs
         *        Request to configure the Replication Server Security group ID during Replication Settings template
         *        creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs);

        /**
         * <p>
         * Request to configure the Replication Server Security group ID during Replication Settings template creation.
         * </p>
         * 
         * @param replicationServersSecurityGroupsIDs
         *        Request to configure the Replication Server Security group ID during Replication Settings template
         *        creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationServersSecurityGroupsIDs(String... replicationServersSecurityGroupsIDs);

        /**
         * <p>
         * Request to configure the Staging Area subnet ID during Replication Settings template creation.
         * </p>
         * 
         * @param stagingAreaSubnetId
         *        Request to configure the Staging Area subnet ID during Replication Settings template creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingAreaSubnetId(String stagingAreaSubnetId);

        /**
         * <p>
         * Request to configure Staging Area tags during Replication Settings template creation.
         * </p>
         * 
         * @param stagingAreaTags
         *        Request to configure Staging Area tags during Replication Settings template creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingAreaTags(Map<String, String> stagingAreaTags);

        /**
         * <p>
         * Request to configure tags during Replication Settings template creation.
         * </p>
         * 
         * @param tags
         *        Request to configure tags during Replication Settings template creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Request to use Dedicated Replication Servers during Replication Settings template creation.
         * </p>
         * 
         * @param useDedicatedReplicationServer
         *        Request to use Dedicated Replication Servers during Replication Settings template creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useDedicatedReplicationServer(Boolean useDedicatedReplicationServer);

        /**
         * <p>
         * Request to use Fips Endpoint during Replication Settings template creation.
         * </p>
         * 
         * @param useFipsEndpoint
         *        Request to use Fips Endpoint during Replication Settings template creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useFipsEndpoint(Boolean useFipsEndpoint);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private Boolean associateDefaultSecurityGroup;

        private Long bandwidthThrottling;

        private Boolean createPublicIP;

        private String dataPlaneRouting;

        private String defaultLargeStagingDiskType;

        private String ebsEncryption;

        private String ebsEncryptionKeyArn;

        private String replicationServerInstanceType;

        private List<String> replicationServersSecurityGroupsIDs = DefaultSdkAutoConstructList.getInstance();

        private String stagingAreaSubnetId;

        private Map<String, String> stagingAreaTags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Boolean useDedicatedReplicationServer;

        private Boolean useFipsEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationConfigurationTemplateRequest model) {
            super(model);
            associateDefaultSecurityGroup(model.associateDefaultSecurityGroup);
            bandwidthThrottling(model.bandwidthThrottling);
            createPublicIP(model.createPublicIP);
            dataPlaneRouting(model.dataPlaneRouting);
            defaultLargeStagingDiskType(model.defaultLargeStagingDiskType);
            ebsEncryption(model.ebsEncryption);
            ebsEncryptionKeyArn(model.ebsEncryptionKeyArn);
            replicationServerInstanceType(model.replicationServerInstanceType);
            replicationServersSecurityGroupsIDs(model.replicationServersSecurityGroupsIDs);
            stagingAreaSubnetId(model.stagingAreaSubnetId);
            stagingAreaTags(model.stagingAreaTags);
            tags(model.tags);
            useDedicatedReplicationServer(model.useDedicatedReplicationServer);
            useFipsEndpoint(model.useFipsEndpoint);
        }

        public final Boolean getAssociateDefaultSecurityGroup() {
            return associateDefaultSecurityGroup;
        }

        public final void setAssociateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
            this.associateDefaultSecurityGroup = associateDefaultSecurityGroup;
        }

        @Override
        public final Builder associateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
            this.associateDefaultSecurityGroup = associateDefaultSecurityGroup;
            return this;
        }

        public final Long getBandwidthThrottling() {
            return bandwidthThrottling;
        }

        public final void setBandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
        }

        @Override
        public final Builder bandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
            return this;
        }

        public final Boolean getCreatePublicIP() {
            return createPublicIP;
        }

        public final void setCreatePublicIP(Boolean createPublicIP) {
            this.createPublicIP = createPublicIP;
        }

        @Override
        public final Builder createPublicIP(Boolean createPublicIP) {
            this.createPublicIP = createPublicIP;
            return this;
        }

        public final String getDataPlaneRouting() {
            return dataPlaneRouting;
        }

        public final void setDataPlaneRouting(String dataPlaneRouting) {
            this.dataPlaneRouting = dataPlaneRouting;
        }

        @Override
        public final Builder dataPlaneRouting(String dataPlaneRouting) {
            this.dataPlaneRouting = dataPlaneRouting;
            return this;
        }

        @Override
        public final Builder dataPlaneRouting(ReplicationConfigurationDataPlaneRouting dataPlaneRouting) {
            this.dataPlaneRouting(dataPlaneRouting == null ? null : dataPlaneRouting.toString());
            return this;
        }

        public final String getDefaultLargeStagingDiskType() {
            return defaultLargeStagingDiskType;
        }

        public final void setDefaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType = defaultLargeStagingDiskType;
        }

        @Override
        public final Builder defaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType = defaultLargeStagingDiskType;
            return this;
        }

        @Override
        public final Builder defaultLargeStagingDiskType(
                ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType(defaultLargeStagingDiskType == null ? null : defaultLargeStagingDiskType.toString());
            return this;
        }

        public final String getEbsEncryption() {
            return ebsEncryption;
        }

        public final void setEbsEncryption(String ebsEncryption) {
            this.ebsEncryption = ebsEncryption;
        }

        @Override
        public final Builder ebsEncryption(String ebsEncryption) {
            this.ebsEncryption = ebsEncryption;
            return this;
        }

        @Override
        public final Builder ebsEncryption(ReplicationConfigurationEbsEncryption ebsEncryption) {
            this.ebsEncryption(ebsEncryption == null ? null : ebsEncryption.toString());
            return this;
        }

        public final String getEbsEncryptionKeyArn() {
            return ebsEncryptionKeyArn;
        }

        public final void setEbsEncryptionKeyArn(String ebsEncryptionKeyArn) {
            this.ebsEncryptionKeyArn = ebsEncryptionKeyArn;
        }

        @Override
        public final Builder ebsEncryptionKeyArn(String ebsEncryptionKeyArn) {
            this.ebsEncryptionKeyArn = ebsEncryptionKeyArn;
            return this;
        }

        public final String getReplicationServerInstanceType() {
            return replicationServerInstanceType;
        }

        public final void setReplicationServerInstanceType(String replicationServerInstanceType) {
            this.replicationServerInstanceType = replicationServerInstanceType;
        }

        @Override
        public final Builder replicationServerInstanceType(String replicationServerInstanceType) {
            this.replicationServerInstanceType = replicationServerInstanceType;
            return this;
        }

        public final Collection<String> getReplicationServersSecurityGroupsIDs() {
            if (replicationServersSecurityGroupsIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationServersSecurityGroupsIDs;
        }

        public final void setReplicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs = ReplicationServersSecurityGroupsIDsCopier
                    .copy(replicationServersSecurityGroupsIDs);
        }

        @Override
        public final Builder replicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs = ReplicationServersSecurityGroupsIDsCopier
                    .copy(replicationServersSecurityGroupsIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationServersSecurityGroupsIDs(String... replicationServersSecurityGroupsIDs) {
            replicationServersSecurityGroupsIDs(Arrays.asList(replicationServersSecurityGroupsIDs));
            return this;
        }

        public final String getStagingAreaSubnetId() {
            return stagingAreaSubnetId;
        }

        public final void setStagingAreaSubnetId(String stagingAreaSubnetId) {
            this.stagingAreaSubnetId = stagingAreaSubnetId;
        }

        @Override
        public final Builder stagingAreaSubnetId(String stagingAreaSubnetId) {
            this.stagingAreaSubnetId = stagingAreaSubnetId;
            return this;
        }

        public final Map<String, String> getStagingAreaTags() {
            if (stagingAreaTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return stagingAreaTags;
        }

        public final void setStagingAreaTags(Map<String, String> stagingAreaTags) {
            this.stagingAreaTags = TagsMapCopier.copy(stagingAreaTags);
        }

        @Override
        public final Builder stagingAreaTags(Map<String, String> stagingAreaTags) {
            this.stagingAreaTags = TagsMapCopier.copy(stagingAreaTags);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final Boolean getUseDedicatedReplicationServer() {
            return useDedicatedReplicationServer;
        }

        public final void setUseDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
            this.useDedicatedReplicationServer = useDedicatedReplicationServer;
        }

        @Override
        public final Builder useDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
            this.useDedicatedReplicationServer = useDedicatedReplicationServer;
            return this;
        }

        public final Boolean getUseFipsEndpoint() {
            return useFipsEndpoint;
        }

        public final void setUseFipsEndpoint(Boolean useFipsEndpoint) {
            this.useFipsEndpoint = useFipsEndpoint;
        }

        @Override
        public final Builder useFipsEndpoint(Boolean useFipsEndpoint) {
            this.useFipsEndpoint = useFipsEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationConfigurationTemplateRequest build() {
            return new CreateReplicationConfigurationTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
