/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateApplicationsRequest extends MgnRequest implements
        ToCopyableBuilder<AssociateApplicationsRequest.Builder, AssociateApplicationsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountID").getter(getter(AssociateApplicationsRequest::accountID)).setter(setter(Builder::accountID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountID").build()).build();

    private static final SdkField<List<String>> APPLICATION_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("applicationIDs")
            .getter(getter(AssociateApplicationsRequest::applicationIDs))
            .setter(setter(Builder::applicationIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WAVE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("waveID")
            .getter(getter(AssociateApplicationsRequest::waveID)).setter(setter(Builder::waveID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waveID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            APPLICATION_I_DS_FIELD, WAVE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountID;

    private final List<String> applicationIDs;

    private final String waveID;

    private AssociateApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.accountID = builder.accountID;
        this.applicationIDs = builder.applicationIDs;
        this.waveID = builder.waveID;
    }

    /**
     * <p>
     * Account ID.
     * </p>
     * 
     * @return Account ID.
     */
    public final String accountID() {
        return accountID;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationIDs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicationIDs() {
        return applicationIDs != null && !(applicationIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Application IDs list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationIDs} method.
     * </p>
     * 
     * @return Application IDs list.
     */
    public final List<String> applicationIDs() {
        return applicationIDs;
    }

    /**
     * <p>
     * Wave ID.
     * </p>
     * 
     * @return Wave ID.
     */
    public final String waveID() {
        return waveID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountID());
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationIDs() ? applicationIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(waveID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateApplicationsRequest)) {
            return false;
        }
        AssociateApplicationsRequest other = (AssociateApplicationsRequest) obj;
        return Objects.equals(accountID(), other.accountID()) && hasApplicationIDs() == other.hasApplicationIDs()
                && Objects.equals(applicationIDs(), other.applicationIDs()) && Objects.equals(waveID(), other.waveID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateApplicationsRequest").add("AccountID", accountID())
                .add("ApplicationIDs", hasApplicationIDs() ? applicationIDs() : null).add("WaveID", waveID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountID":
            return Optional.ofNullable(clazz.cast(accountID()));
        case "applicationIDs":
            return Optional.ofNullable(clazz.cast(applicationIDs()));
        case "waveID":
            return Optional.ofNullable(clazz.cast(waveID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountID", ACCOUNT_ID_FIELD);
        map.put("applicationIDs", APPLICATION_I_DS_FIELD);
        map.put("waveID", WAVE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateApplicationsRequest, T> g) {
        return obj -> g.apply((AssociateApplicationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MgnRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateApplicationsRequest> {
        /**
         * <p>
         * Account ID.
         * </p>
         * 
         * @param accountID
         *        Account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountID(String accountID);

        /**
         * <p>
         * Application IDs list.
         * </p>
         * 
         * @param applicationIDs
         *        Application IDs list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIDs(Collection<String> applicationIDs);

        /**
         * <p>
         * Application IDs list.
         * </p>
         * 
         * @param applicationIDs
         *        Application IDs list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIDs(String... applicationIDs);

        /**
         * <p>
         * Wave ID.
         * </p>
         * 
         * @param waveID
         *        Wave ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waveID(String waveID);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private String accountID;

        private List<String> applicationIDs = DefaultSdkAutoConstructList.getInstance();

        private String waveID;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateApplicationsRequest model) {
            super(model);
            accountID(model.accountID);
            applicationIDs(model.applicationIDs);
            waveID(model.waveID);
        }

        public final String getAccountID() {
            return accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final Collection<String> getApplicationIDs() {
            if (applicationIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return applicationIDs;
        }

        public final void setApplicationIDs(Collection<String> applicationIDs) {
            this.applicationIDs = ApplicationIDsCopier.copy(applicationIDs);
        }

        @Override
        public final Builder applicationIDs(Collection<String> applicationIDs) {
            this.applicationIDs = ApplicationIDsCopier.copy(applicationIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationIDs(String... applicationIDs) {
            applicationIDs(Arrays.asList(applicationIDs));
            return this;
        }

        public final String getWaveID() {
            return waveID;
        }

        public final void setWaveID(String waveID) {
            this.waveID = waveID;
        }

        @Override
        public final Builder waveID(String waveID) {
            this.waveID = waveID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateApplicationsRequest build() {
            return new AssociateApplicationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
