/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequestSourceServerIDsCopier;
import software.amazon.awssdk.services.mgn.model.MgnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateSourceServersRequest
extends MgnRequest
implements ToCopyableBuilder<Builder, AssociateSourceServersRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountID").getter(AssociateSourceServersRequest.getter(AssociateSourceServersRequest::accountID)).setter(AssociateSourceServersRequest.setter(Builder::accountID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountID").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationID").getter(AssociateSourceServersRequest.getter(AssociateSourceServersRequest::applicationID)).setter(AssociateSourceServersRequest.setter(Builder::applicationID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationID").build()}).build();
    private static final SdkField<List<String>> SOURCE_SERVER_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceServerIDs").getter(AssociateSourceServersRequest.getter(AssociateSourceServersRequest::sourceServerIDs)).setter(AssociateSourceServersRequest.setter(Builder::sourceServerIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, APPLICATION_ID_FIELD, SOURCE_SERVER_I_DS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateSourceServersRequest.memberNameToFieldInitializer();
    private final String accountID;
    private final String applicationID;
    private final List<String> sourceServerIDs;

    private AssociateSourceServersRequest(BuilderImpl builder) {
        super(builder);
        this.accountID = builder.accountID;
        this.applicationID = builder.applicationID;
        this.sourceServerIDs = builder.sourceServerIDs;
    }

    public final String accountID() {
        return this.accountID;
    }

    public final String applicationID() {
        return this.applicationID;
    }

    public final boolean hasSourceServerIDs() {
        return this.sourceServerIDs != null && !(this.sourceServerIDs instanceof SdkAutoConstructList);
    }

    public final List<String> sourceServerIDs() {
        return this.sourceServerIDs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountID());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationID());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceServerIDs() ? this.sourceServerIDs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSourceServersRequest)) {
            return false;
        }
        AssociateSourceServersRequest other = (AssociateSourceServersRequest)((Object)obj);
        return Objects.equals(this.accountID(), other.accountID()) && Objects.equals(this.applicationID(), other.applicationID()) && this.hasSourceServerIDs() == other.hasSourceServerIDs() && Objects.equals(this.sourceServerIDs(), other.sourceServerIDs());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateSourceServersRequest").add("AccountID", (Object)this.accountID()).add("ApplicationID", (Object)this.applicationID()).add("SourceServerIDs", this.hasSourceServerIDs() ? this.sourceServerIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountID": {
                return Optional.ofNullable(clazz.cast(this.accountID()));
            }
            case "applicationID": {
                return Optional.ofNullable(clazz.cast(this.applicationID()));
            }
            case "sourceServerIDs": {
                return Optional.ofNullable(clazz.cast(this.sourceServerIDs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountID", ACCOUNT_ID_FIELD);
        map.put("applicationID", APPLICATION_ID_FIELD);
        map.put("sourceServerIDs", SOURCE_SERVER_I_DS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateSourceServersRequest, T> g) {
        return obj -> g.apply((AssociateSourceServersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnRequest.BuilderImpl
    implements Builder {
        private String accountID;
        private String applicationID;
        private List<String> sourceServerIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSourceServersRequest model) {
            super(model);
            this.accountID(model.accountID);
            this.applicationID(model.applicationID);
            this.sourceServerIDs(model.sourceServerIDs);
        }

        public final String getAccountID() {
            return this.accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final String getApplicationID() {
            return this.applicationID;
        }

        public final void setApplicationID(String applicationID) {
            this.applicationID = applicationID;
        }

        @Override
        public final Builder applicationID(String applicationID) {
            this.applicationID = applicationID;
            return this;
        }

        public final Collection<String> getSourceServerIDs() {
            if (this.sourceServerIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceServerIDs;
        }

        public final void setSourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = AssociateSourceServersRequestSourceServerIDsCopier.copy(sourceServerIDs);
        }

        @Override
        public final Builder sourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = AssociateSourceServersRequestSourceServerIDsCopier.copy(sourceServerIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServerIDs(String ... sourceServerIDs) {
            this.sourceServerIDs(Arrays.asList(sourceServerIDs));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSourceServersRequest build() {
            return new AssociateSourceServersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MgnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateSourceServersRequest> {
        public Builder accountID(String var1);

        public Builder applicationID(String var1);

        public Builder sourceServerIDs(Collection<String> var1);

        public Builder sourceServerIDs(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

