/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SsmExternalParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SsmExternalParameter> {
    private static final SdkField<String> DYNAMIC_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dynamicPath").getter(SsmExternalParameter.getter(SsmExternalParameter::dynamicPath)).setter(SsmExternalParameter.setter(Builder::dynamicPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMIC_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("dynamicPath", DYNAMIC_PATH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dynamicPath;
    private final Type type;

    private SsmExternalParameter(BuilderImpl builder) {
        this.dynamicPath = builder.dynamicPath;
        this.type = builder.type;
    }

    public final String dynamicPath() {
        return this.dynamicPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmExternalParameter)) {
            return false;
        }
        SsmExternalParameter other = (SsmExternalParameter)obj;
        return Objects.equals(this.dynamicPath(), other.dynamicPath());
    }

    public final String toString() {
        return ToString.builder((String)"SsmExternalParameter").add("DynamicPath", (Object)this.dynamicPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dynamicPath": {
                return Optional.ofNullable(clazz.cast(this.dynamicPath()));
            }
        }
        return Optional.empty();
    }

    public static SsmExternalParameter fromDynamicPath(String dynamicPath) {
        return (SsmExternalParameter)SsmExternalParameter.builder().dynamicPath(dynamicPath).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SsmExternalParameter, T> g) {
        return obj -> g.apply((SsmExternalParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DYNAMIC_PATH,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String dynamicPath;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SsmExternalParameter model) {
            this.dynamicPath(model.dynamicPath);
        }

        public final String getDynamicPath() {
            return this.dynamicPath;
        }

        public final void setDynamicPath(String dynamicPath) {
            String oldValue = this.dynamicPath;
            this.dynamicPath = dynamicPath;
            this.handleUnionValueChange(Type.DYNAMIC_PATH, oldValue, this.dynamicPath);
        }

        @Override
        public final Builder dynamicPath(String dynamicPath) {
            String oldValue = this.dynamicPath;
            this.dynamicPath = dynamicPath;
            this.handleUnionValueChange(Type.DYNAMIC_PATH, oldValue, this.dynamicPath);
            return this;
        }

        public SsmExternalParameter build() {
            return new SsmExternalParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SsmExternalParameter> {
        public Builder dynamicPath(String var1);
    }
}

