/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.BootMode;
import software.amazon.awssdk.services.mgn.model.LaunchDisposition;
import software.amazon.awssdk.services.mgn.model.LaunchTemplateDiskConf;
import software.amazon.awssdk.services.mgn.model.Licensing;
import software.amazon.awssdk.services.mgn.model.MgnResponse;
import software.amazon.awssdk.services.mgn.model.PostLaunchActions;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.services.mgn.model.TargetInstanceTypeRightSizingMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLaunchConfigurationTemplateResponse
extends MgnResponse
implements ToCopyableBuilder<Builder, CreateLaunchConfigurationTemplateResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::arn)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("associatePublicIpAddress").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::associatePublicIpAddress)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::associatePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatePublicIpAddress").build()}).build();
    private static final SdkField<String> BOOT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bootMode").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::bootModeAsString)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::bootMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootMode").build()}).build();
    private static final SdkField<Boolean> COPY_PRIVATE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("copyPrivateIp").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::copyPrivateIp)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::copyPrivateIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyPrivateIp").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("copyTags").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::copyTags)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTags").build()}).build();
    private static final SdkField<String> EC2_LAUNCH_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2LaunchTemplateID").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::ec2LaunchTemplateID)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::ec2LaunchTemplateID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2LaunchTemplateID").build()}).build();
    private static final SdkField<Boolean> ENABLE_MAP_AUTO_TAGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableMapAutoTagging").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::enableMapAutoTagging)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::enableMapAutoTagging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableMapAutoTagging").build()}).build();
    private static final SdkField<LaunchTemplateDiskConf> LARGE_VOLUME_CONF_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("largeVolumeConf").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::largeVolumeConf)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::largeVolumeConf)).constructor(LaunchTemplateDiskConf::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("largeVolumeConf").build()}).build();
    private static final SdkField<String> LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchConfigurationTemplateID").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::launchConfigurationTemplateID)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::launchConfigurationTemplateID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfigurationTemplateID").build()}).build();
    private static final SdkField<String> LAUNCH_DISPOSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchDisposition").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::launchDispositionAsString)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::launchDisposition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDisposition").build()}).build();
    private static final SdkField<Licensing> LICENSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("licensing").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::licensing)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::licensing)).constructor(Licensing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licensing").build()}).build();
    private static final SdkField<String> MAP_AUTO_TAGGING_MPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mapAutoTaggingMpeID").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::mapAutoTaggingMpeID)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::mapAutoTaggingMpeID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapAutoTaggingMpeID").build()}).build();
    private static final SdkField<PostLaunchActions> POST_LAUNCH_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("postLaunchActions").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::postLaunchActions)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::postLaunchActions)).constructor(PostLaunchActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postLaunchActions").build()}).build();
    private static final SdkField<LaunchTemplateDiskConf> SMALL_VOLUME_CONF_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("smallVolumeConf").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::smallVolumeConf)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::smallVolumeConf)).constructor(LaunchTemplateDiskConf::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smallVolumeConf").build()}).build();
    private static final SdkField<Long> SMALL_VOLUME_MAX_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("smallVolumeMaxSize").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::smallVolumeMaxSize)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::smallVolumeMaxSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smallVolumeMaxSize").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::tags)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetInstanceTypeRightSizingMethod").getter(CreateLaunchConfigurationTemplateResponse.getter(CreateLaunchConfigurationTemplateResponse::targetInstanceTypeRightSizingMethodAsString)).setter(CreateLaunchConfigurationTemplateResponse.setter(Builder::targetInstanceTypeRightSizingMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstanceTypeRightSizingMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, BOOT_MODE_FIELD, COPY_PRIVATE_IP_FIELD, COPY_TAGS_FIELD, EC2_LAUNCH_TEMPLATE_ID_FIELD, ENABLE_MAP_AUTO_TAGGING_FIELD, LARGE_VOLUME_CONF_FIELD, LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD, LAUNCH_DISPOSITION_FIELD, LICENSING_FIELD, MAP_AUTO_TAGGING_MPE_ID_FIELD, POST_LAUNCH_ACTIONS_FIELD, SMALL_VOLUME_CONF_FIELD, SMALL_VOLUME_MAX_SIZE_FIELD, TAGS_FIELD, TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("associatePublicIpAddress", ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD);
            this.put("bootMode", BOOT_MODE_FIELD);
            this.put("copyPrivateIp", COPY_PRIVATE_IP_FIELD);
            this.put("copyTags", COPY_TAGS_FIELD);
            this.put("ec2LaunchTemplateID", EC2_LAUNCH_TEMPLATE_ID_FIELD);
            this.put("enableMapAutoTagging", ENABLE_MAP_AUTO_TAGGING_FIELD);
            this.put("largeVolumeConf", LARGE_VOLUME_CONF_FIELD);
            this.put("launchConfigurationTemplateID", LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD);
            this.put("launchDisposition", LAUNCH_DISPOSITION_FIELD);
            this.put("licensing", LICENSING_FIELD);
            this.put("mapAutoTaggingMpeID", MAP_AUTO_TAGGING_MPE_ID_FIELD);
            this.put("postLaunchActions", POST_LAUNCH_ACTIONS_FIELD);
            this.put("smallVolumeConf", SMALL_VOLUME_CONF_FIELD);
            this.put("smallVolumeMaxSize", SMALL_VOLUME_MAX_SIZE_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("targetInstanceTypeRightSizingMethod", TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD);
        }
    });
    private final String arn;
    private final Boolean associatePublicIpAddress;
    private final String bootMode;
    private final Boolean copyPrivateIp;
    private final Boolean copyTags;
    private final String ec2LaunchTemplateID;
    private final Boolean enableMapAutoTagging;
    private final LaunchTemplateDiskConf largeVolumeConf;
    private final String launchConfigurationTemplateID;
    private final String launchDisposition;
    private final Licensing licensing;
    private final String mapAutoTaggingMpeID;
    private final PostLaunchActions postLaunchActions;
    private final LaunchTemplateDiskConf smallVolumeConf;
    private final Long smallVolumeMaxSize;
    private final Map<String, String> tags;
    private final String targetInstanceTypeRightSizingMethod;

    private CreateLaunchConfigurationTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.bootMode = builder.bootMode;
        this.copyPrivateIp = builder.copyPrivateIp;
        this.copyTags = builder.copyTags;
        this.ec2LaunchTemplateID = builder.ec2LaunchTemplateID;
        this.enableMapAutoTagging = builder.enableMapAutoTagging;
        this.largeVolumeConf = builder.largeVolumeConf;
        this.launchConfigurationTemplateID = builder.launchConfigurationTemplateID;
        this.launchDisposition = builder.launchDisposition;
        this.licensing = builder.licensing;
        this.mapAutoTaggingMpeID = builder.mapAutoTaggingMpeID;
        this.postLaunchActions = builder.postLaunchActions;
        this.smallVolumeConf = builder.smallVolumeConf;
        this.smallVolumeMaxSize = builder.smallVolumeMaxSize;
        this.tags = builder.tags;
        this.targetInstanceTypeRightSizingMethod = builder.targetInstanceTypeRightSizingMethod;
    }

    public final String arn() {
        return this.arn;
    }

    public final Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public final BootMode bootMode() {
        return BootMode.fromValue(this.bootMode);
    }

    public final String bootModeAsString() {
        return this.bootMode;
    }

    public final Boolean copyPrivateIp() {
        return this.copyPrivateIp;
    }

    public final Boolean copyTags() {
        return this.copyTags;
    }

    public final String ec2LaunchTemplateID() {
        return this.ec2LaunchTemplateID;
    }

    public final Boolean enableMapAutoTagging() {
        return this.enableMapAutoTagging;
    }

    public final LaunchTemplateDiskConf largeVolumeConf() {
        return this.largeVolumeConf;
    }

    public final String launchConfigurationTemplateID() {
        return this.launchConfigurationTemplateID;
    }

    public final LaunchDisposition launchDisposition() {
        return LaunchDisposition.fromValue(this.launchDisposition);
    }

    public final String launchDispositionAsString() {
        return this.launchDisposition;
    }

    public final Licensing licensing() {
        return this.licensing;
    }

    public final String mapAutoTaggingMpeID() {
        return this.mapAutoTaggingMpeID;
    }

    public final PostLaunchActions postLaunchActions() {
        return this.postLaunchActions;
    }

    public final LaunchTemplateDiskConf smallVolumeConf() {
        return this.smallVolumeConf;
    }

    public final Long smallVolumeMaxSize() {
        return this.smallVolumeMaxSize;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod() {
        return TargetInstanceTypeRightSizingMethod.fromValue(this.targetInstanceTypeRightSizingMethod);
    }

    public final String targetInstanceTypeRightSizingMethodAsString() {
        return this.targetInstanceTypeRightSizingMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.bootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyPrivateIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2LaunchTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableMapAutoTagging());
        hashCode = 31 * hashCode + Objects.hashCode(this.largeVolumeConf());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licensing());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapAutoTaggingMpeID());
        hashCode = 31 * hashCode + Objects.hashCode(this.postLaunchActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.smallVolumeConf());
        hashCode = 31 * hashCode + Objects.hashCode(this.smallVolumeMaxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetInstanceTypeRightSizingMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchConfigurationTemplateResponse)) {
            return false;
        }
        CreateLaunchConfigurationTemplateResponse other = (CreateLaunchConfigurationTemplateResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress()) && Objects.equals(this.bootModeAsString(), other.bootModeAsString()) && Objects.equals(this.copyPrivateIp(), other.copyPrivateIp()) && Objects.equals(this.copyTags(), other.copyTags()) && Objects.equals(this.ec2LaunchTemplateID(), other.ec2LaunchTemplateID()) && Objects.equals(this.enableMapAutoTagging(), other.enableMapAutoTagging()) && Objects.equals(this.largeVolumeConf(), other.largeVolumeConf()) && Objects.equals(this.launchConfigurationTemplateID(), other.launchConfigurationTemplateID()) && Objects.equals(this.launchDispositionAsString(), other.launchDispositionAsString()) && Objects.equals(this.licensing(), other.licensing()) && Objects.equals(this.mapAutoTaggingMpeID(), other.mapAutoTaggingMpeID()) && Objects.equals(this.postLaunchActions(), other.postLaunchActions()) && Objects.equals(this.smallVolumeConf(), other.smallVolumeConf()) && Objects.equals(this.smallVolumeMaxSize(), other.smallVolumeMaxSize()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.targetInstanceTypeRightSizingMethodAsString(), other.targetInstanceTypeRightSizingMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLaunchConfigurationTemplateResponse").add("Arn", (Object)this.arn()).add("AssociatePublicIpAddress", (Object)this.associatePublicIpAddress()).add("BootMode", (Object)this.bootModeAsString()).add("CopyPrivateIp", (Object)this.copyPrivateIp()).add("CopyTags", (Object)this.copyTags()).add("Ec2LaunchTemplateID", (Object)this.ec2LaunchTemplateID()).add("EnableMapAutoTagging", (Object)this.enableMapAutoTagging()).add("LargeVolumeConf", (Object)this.largeVolumeConf()).add("LaunchConfigurationTemplateID", (Object)this.launchConfigurationTemplateID()).add("LaunchDisposition", (Object)this.launchDispositionAsString()).add("Licensing", (Object)this.licensing()).add("MapAutoTaggingMpeID", (Object)this.mapAutoTaggingMpeID()).add("PostLaunchActions", (Object)this.postLaunchActions()).add("SmallVolumeConf", (Object)this.smallVolumeConf()).add("SmallVolumeMaxSize", (Object)this.smallVolumeMaxSize()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("TargetInstanceTypeRightSizingMethod", (Object)this.targetInstanceTypeRightSizingMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "associatePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associatePublicIpAddress()));
            }
            case "bootMode": {
                return Optional.ofNullable(clazz.cast(this.bootModeAsString()));
            }
            case "copyPrivateIp": {
                return Optional.ofNullable(clazz.cast(this.copyPrivateIp()));
            }
            case "copyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "ec2LaunchTemplateID": {
                return Optional.ofNullable(clazz.cast(this.ec2LaunchTemplateID()));
            }
            case "enableMapAutoTagging": {
                return Optional.ofNullable(clazz.cast(this.enableMapAutoTagging()));
            }
            case "largeVolumeConf": {
                return Optional.ofNullable(clazz.cast(this.largeVolumeConf()));
            }
            case "launchConfigurationTemplateID": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationTemplateID()));
            }
            case "launchDisposition": {
                return Optional.ofNullable(clazz.cast(this.launchDispositionAsString()));
            }
            case "licensing": {
                return Optional.ofNullable(clazz.cast(this.licensing()));
            }
            case "mapAutoTaggingMpeID": {
                return Optional.ofNullable(clazz.cast(this.mapAutoTaggingMpeID()));
            }
            case "postLaunchActions": {
                return Optional.ofNullable(clazz.cast(this.postLaunchActions()));
            }
            case "smallVolumeConf": {
                return Optional.ofNullable(clazz.cast(this.smallVolumeConf()));
            }
            case "smallVolumeMaxSize": {
                return Optional.ofNullable(clazz.cast(this.smallVolumeMaxSize()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "targetInstanceTypeRightSizingMethod": {
                return Optional.ofNullable(clazz.cast(this.targetInstanceTypeRightSizingMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchConfigurationTemplateResponse, T> g) {
        return obj -> g.apply((CreateLaunchConfigurationTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Boolean associatePublicIpAddress;
        private String bootMode;
        private Boolean copyPrivateIp;
        private Boolean copyTags;
        private String ec2LaunchTemplateID;
        private Boolean enableMapAutoTagging;
        private LaunchTemplateDiskConf largeVolumeConf;
        private String launchConfigurationTemplateID;
        private String launchDisposition;
        private Licensing licensing;
        private String mapAutoTaggingMpeID;
        private PostLaunchActions postLaunchActions;
        private LaunchTemplateDiskConf smallVolumeConf;
        private Long smallVolumeMaxSize;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String targetInstanceTypeRightSizingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchConfigurationTemplateResponse model) {
            super(model);
            this.arn(model.arn);
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.bootMode(model.bootMode);
            this.copyPrivateIp(model.copyPrivateIp);
            this.copyTags(model.copyTags);
            this.ec2LaunchTemplateID(model.ec2LaunchTemplateID);
            this.enableMapAutoTagging(model.enableMapAutoTagging);
            this.largeVolumeConf(model.largeVolumeConf);
            this.launchConfigurationTemplateID(model.launchConfigurationTemplateID);
            this.launchDisposition(model.launchDisposition);
            this.licensing(model.licensing);
            this.mapAutoTaggingMpeID(model.mapAutoTaggingMpeID);
            this.postLaunchActions(model.postLaunchActions);
            this.smallVolumeConf(model.smallVolumeConf);
            this.smallVolumeMaxSize(model.smallVolumeMaxSize);
            this.tags(model.tags);
            this.targetInstanceTypeRightSizingMethod(model.targetInstanceTypeRightSizingMethod);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final String getBootMode() {
            return this.bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootMode bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        public final Boolean getCopyPrivateIp() {
            return this.copyPrivateIp;
        }

        public final void setCopyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
        }

        @Override
        public final Builder copyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
            return this;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final String getEc2LaunchTemplateID() {
            return this.ec2LaunchTemplateID;
        }

        public final void setEc2LaunchTemplateID(String ec2LaunchTemplateID) {
            this.ec2LaunchTemplateID = ec2LaunchTemplateID;
        }

        @Override
        public final Builder ec2LaunchTemplateID(String ec2LaunchTemplateID) {
            this.ec2LaunchTemplateID = ec2LaunchTemplateID;
            return this;
        }

        public final Boolean getEnableMapAutoTagging() {
            return this.enableMapAutoTagging;
        }

        public final void setEnableMapAutoTagging(Boolean enableMapAutoTagging) {
            this.enableMapAutoTagging = enableMapAutoTagging;
        }

        @Override
        public final Builder enableMapAutoTagging(Boolean enableMapAutoTagging) {
            this.enableMapAutoTagging = enableMapAutoTagging;
            return this;
        }

        public final LaunchTemplateDiskConf.Builder getLargeVolumeConf() {
            return this.largeVolumeConf != null ? this.largeVolumeConf.toBuilder() : null;
        }

        public final void setLargeVolumeConf(LaunchTemplateDiskConf.BuilderImpl largeVolumeConf) {
            this.largeVolumeConf = largeVolumeConf != null ? largeVolumeConf.build() : null;
        }

        @Override
        public final Builder largeVolumeConf(LaunchTemplateDiskConf largeVolumeConf) {
            this.largeVolumeConf = largeVolumeConf;
            return this;
        }

        public final String getLaunchConfigurationTemplateID() {
            return this.launchConfigurationTemplateID;
        }

        public final void setLaunchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
        }

        @Override
        public final Builder launchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
            return this;
        }

        public final String getLaunchDisposition() {
            return this.launchDisposition;
        }

        public final void setLaunchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
        }

        @Override
        public final Builder launchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
            return this;
        }

        @Override
        public final Builder launchDisposition(LaunchDisposition launchDisposition) {
            this.launchDisposition(launchDisposition == null ? null : launchDisposition.toString());
            return this;
        }

        public final Licensing.Builder getLicensing() {
            return this.licensing != null ? this.licensing.toBuilder() : null;
        }

        public final void setLicensing(Licensing.BuilderImpl licensing) {
            this.licensing = licensing != null ? licensing.build() : null;
        }

        @Override
        public final Builder licensing(Licensing licensing) {
            this.licensing = licensing;
            return this;
        }

        public final String getMapAutoTaggingMpeID() {
            return this.mapAutoTaggingMpeID;
        }

        public final void setMapAutoTaggingMpeID(String mapAutoTaggingMpeID) {
            this.mapAutoTaggingMpeID = mapAutoTaggingMpeID;
        }

        @Override
        public final Builder mapAutoTaggingMpeID(String mapAutoTaggingMpeID) {
            this.mapAutoTaggingMpeID = mapAutoTaggingMpeID;
            return this;
        }

        public final PostLaunchActions.Builder getPostLaunchActions() {
            return this.postLaunchActions != null ? this.postLaunchActions.toBuilder() : null;
        }

        public final void setPostLaunchActions(PostLaunchActions.BuilderImpl postLaunchActions) {
            this.postLaunchActions = postLaunchActions != null ? postLaunchActions.build() : null;
        }

        @Override
        public final Builder postLaunchActions(PostLaunchActions postLaunchActions) {
            this.postLaunchActions = postLaunchActions;
            return this;
        }

        public final LaunchTemplateDiskConf.Builder getSmallVolumeConf() {
            return this.smallVolumeConf != null ? this.smallVolumeConf.toBuilder() : null;
        }

        public final void setSmallVolumeConf(LaunchTemplateDiskConf.BuilderImpl smallVolumeConf) {
            this.smallVolumeConf = smallVolumeConf != null ? smallVolumeConf.build() : null;
        }

        @Override
        public final Builder smallVolumeConf(LaunchTemplateDiskConf smallVolumeConf) {
            this.smallVolumeConf = smallVolumeConf;
            return this;
        }

        public final Long getSmallVolumeMaxSize() {
            return this.smallVolumeMaxSize;
        }

        public final void setSmallVolumeMaxSize(Long smallVolumeMaxSize) {
            this.smallVolumeMaxSize = smallVolumeMaxSize;
        }

        @Override
        public final Builder smallVolumeMaxSize(Long smallVolumeMaxSize) {
            this.smallVolumeMaxSize = smallVolumeMaxSize;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getTargetInstanceTypeRightSizingMethod() {
            return this.targetInstanceTypeRightSizingMethod;
        }

        public final void setTargetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
            return this;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod(targetInstanceTypeRightSizingMethod == null ? null : targetInstanceTypeRightSizingMethod.toString());
            return this;
        }

        @Override
        public CreateLaunchConfigurationTemplateResponse build() {
            return new CreateLaunchConfigurationTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MgnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLaunchConfigurationTemplateResponse> {
        public Builder arn(String var1);

        public Builder associatePublicIpAddress(Boolean var1);

        public Builder bootMode(String var1);

        public Builder bootMode(BootMode var1);

        public Builder copyPrivateIp(Boolean var1);

        public Builder copyTags(Boolean var1);

        public Builder ec2LaunchTemplateID(String var1);

        public Builder enableMapAutoTagging(Boolean var1);

        public Builder largeVolumeConf(LaunchTemplateDiskConf var1);

        default public Builder largeVolumeConf(Consumer<LaunchTemplateDiskConf.Builder> largeVolumeConf) {
            return this.largeVolumeConf((LaunchTemplateDiskConf)((LaunchTemplateDiskConf.Builder)LaunchTemplateDiskConf.builder().applyMutation(largeVolumeConf)).build());
        }

        public Builder launchConfigurationTemplateID(String var1);

        public Builder launchDisposition(String var1);

        public Builder launchDisposition(LaunchDisposition var1);

        public Builder licensing(Licensing var1);

        default public Builder licensing(Consumer<Licensing.Builder> licensing) {
            return this.licensing((Licensing)((Licensing.Builder)Licensing.builder().applyMutation(licensing)).build());
        }

        public Builder mapAutoTaggingMpeID(String var1);

        public Builder postLaunchActions(PostLaunchActions var1);

        default public Builder postLaunchActions(Consumer<PostLaunchActions.Builder> postLaunchActions) {
            return this.postLaunchActions((PostLaunchActions)((PostLaunchActions.Builder)PostLaunchActions.builder().applyMutation(postLaunchActions)).build());
        }

        public Builder smallVolumeConf(LaunchTemplateDiskConf var1);

        default public Builder smallVolumeConf(Consumer<LaunchTemplateDiskConf.Builder> smallVolumeConf) {
            return this.smallVolumeConf((LaunchTemplateDiskConf)((LaunchTemplateDiskConf.Builder)LaunchTemplateDiskConf.builder().applyMutation(smallVolumeConf)).build());
        }

        public Builder smallVolumeMaxSize(Long var1);

        public Builder tags(Map<String, String> var1);

        public Builder targetInstanceTypeRightSizingMethod(String var1);

        public Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod var1);
    }
}

