/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mgn.model.ApplicationIDsFilterCopier;
import software.amazon.awssdk.services.mgn.model.WaveIDsFilterCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationsRequestFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListApplicationsRequestFilters> {
    private static final SdkField<List<String>> APPLICATION_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicationIDs").getter(ListApplicationsRequestFilters.getter(ListApplicationsRequestFilters::applicationIDs)).setter(ListApplicationsRequestFilters.setter(Builder::applicationIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isArchived").getter(ListApplicationsRequestFilters.getter(ListApplicationsRequestFilters::isArchived)).setter(ListApplicationsRequestFilters.setter(Builder::isArchived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()}).build();
    private static final SdkField<List<String>> WAVE_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("waveIDs").getter(ListApplicationsRequestFilters.getter(ListApplicationsRequestFilters::waveIDs)).setter(ListApplicationsRequestFilters.setter(Builder::waveIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waveIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_I_DS_FIELD, IS_ARCHIVED_FIELD, WAVE_I_DS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> applicationIDs;
    private final Boolean isArchived;
    private final List<String> waveIDs;

    private ListApplicationsRequestFilters(BuilderImpl builder) {
        this.applicationIDs = builder.applicationIDs;
        this.isArchived = builder.isArchived;
        this.waveIDs = builder.waveIDs;
    }

    public final boolean hasApplicationIDs() {
        return this.applicationIDs != null && !(this.applicationIDs instanceof SdkAutoConstructList);
    }

    public final List<String> applicationIDs() {
        return this.applicationIDs;
    }

    public final Boolean isArchived() {
        return this.isArchived;
    }

    public final boolean hasWaveIDs() {
        return this.waveIDs != null && !(this.waveIDs instanceof SdkAutoConstructList);
    }

    public final List<String> waveIDs() {
        return this.waveIDs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationIDs() ? this.applicationIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWaveIDs() ? this.waveIDs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsRequestFilters)) {
            return false;
        }
        ListApplicationsRequestFilters other = (ListApplicationsRequestFilters)obj;
        return this.hasApplicationIDs() == other.hasApplicationIDs() && Objects.equals(this.applicationIDs(), other.applicationIDs()) && Objects.equals(this.isArchived(), other.isArchived()) && this.hasWaveIDs() == other.hasWaveIDs() && Objects.equals(this.waveIDs(), other.waveIDs());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationsRequestFilters").add("ApplicationIDs", this.hasApplicationIDs() ? this.applicationIDs() : null).add("IsArchived", (Object)this.isArchived()).add("WaveIDs", this.hasWaveIDs() ? this.waveIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationIDs": {
                return Optional.ofNullable(clazz.cast(this.applicationIDs()));
            }
            case "isArchived": {
                return Optional.ofNullable(clazz.cast(this.isArchived()));
            }
            case "waveIDs": {
                return Optional.ofNullable(clazz.cast(this.waveIDs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationsRequestFilters, T> g) {
        return obj -> g.apply((ListApplicationsRequestFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> applicationIDs = DefaultSdkAutoConstructList.getInstance();
        private Boolean isArchived;
        private List<String> waveIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsRequestFilters model) {
            this.applicationIDs(model.applicationIDs);
            this.isArchived(model.isArchived);
            this.waveIDs(model.waveIDs);
        }

        public final Collection<String> getApplicationIDs() {
            if (this.applicationIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationIDs;
        }

        public final void setApplicationIDs(Collection<String> applicationIDs) {
            this.applicationIDs = ApplicationIDsFilterCopier.copy(applicationIDs);
        }

        @Override
        public final Builder applicationIDs(Collection<String> applicationIDs) {
            this.applicationIDs = ApplicationIDsFilterCopier.copy(applicationIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationIDs(String ... applicationIDs) {
            this.applicationIDs(Arrays.asList(applicationIDs));
            return this;
        }

        public final Boolean getIsArchived() {
            return this.isArchived;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final Collection<String> getWaveIDs() {
            if (this.waveIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.waveIDs;
        }

        public final void setWaveIDs(Collection<String> waveIDs) {
            this.waveIDs = WaveIDsFilterCopier.copy(waveIDs);
        }

        @Override
        public final Builder waveIDs(Collection<String> waveIDs) {
            this.waveIDs = WaveIDsFilterCopier.copy(waveIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder waveIDs(String ... waveIDs) {
            this.waveIDs(Arrays.asList(waveIDs));
            return this;
        }

        public ListApplicationsRequestFilters build() {
            return new ListApplicationsRequestFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListApplicationsRequestFilters> {
        public Builder applicationIDs(Collection<String> var1);

        public Builder applicationIDs(String ... var1);

        public Builder isArchived(Boolean var1);

        public Builder waveIDs(Collection<String> var1);

        public Builder waveIDs(String ... var1);
    }
}

