/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Post Launch Actions to executed on the Test or Cutover instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostLaunchActions implements SdkPojo, Serializable,
        ToCopyableBuilder<PostLaunchActions.Builder, PostLaunchActions> {
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudWatchLogGroupName").getter(getter(PostLaunchActions::cloudWatchLogGroupName))
            .setter(setter(Builder::cloudWatchLogGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogGroupName").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deployment").getter(getter(PostLaunchActions::deploymentAsString)).setter(setter(Builder::deployment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployment").build()).build();

    private static final SdkField<String> S3_LOG_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3LogBucket").getter(getter(PostLaunchActions::s3LogBucket)).setter(setter(Builder::s3LogBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3LogBucket").build()).build();

    private static final SdkField<String> S3_OUTPUT_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3OutputKeyPrefix").getter(getter(PostLaunchActions::s3OutputKeyPrefix))
            .setter(setter(Builder::s3OutputKeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3OutputKeyPrefix").build()).build();

    private static final SdkField<List<SsmDocument>> SSM_DOCUMENTS_FIELD = SdkField
            .<List<SsmDocument>> builder(MarshallingType.LIST)
            .memberName("ssmDocuments")
            .getter(getter(PostLaunchActions::ssmDocuments))
            .setter(setter(Builder::ssmDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SsmDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(SsmDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOG_GROUP_NAME_FIELD, DEPLOYMENT_FIELD, S3_LOG_BUCKET_FIELD, S3_OUTPUT_KEY_PREFIX_FIELD,
            SSM_DOCUMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cloudWatchLogGroupName;

    private final String deployment;

    private final String s3LogBucket;

    private final String s3OutputKeyPrefix;

    private final List<SsmDocument> ssmDocuments;

    private PostLaunchActions(BuilderImpl builder) {
        this.cloudWatchLogGroupName = builder.cloudWatchLogGroupName;
        this.deployment = builder.deployment;
        this.s3LogBucket = builder.s3LogBucket;
        this.s3OutputKeyPrefix = builder.s3OutputKeyPrefix;
        this.ssmDocuments = builder.ssmDocuments;
    }

    /**
     * <p>
     * AWS Systems Manager Command's CloudWatch log group name.
     * </p>
     * 
     * @return AWS Systems Manager Command's CloudWatch log group name.
     */
    public final String cloudWatchLogGroupName() {
        return cloudWatchLogGroupName;
    }

    /**
     * <p>
     * Deployment type in which AWS Systems Manager Documents will be executed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deployment} will
     * return {@link PostLaunchActionsDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentAsString}.
     * </p>
     * 
     * @return Deployment type in which AWS Systems Manager Documents will be executed.
     * @see PostLaunchActionsDeploymentType
     */
    public final PostLaunchActionsDeploymentType deployment() {
        return PostLaunchActionsDeploymentType.fromValue(deployment);
    }

    /**
     * <p>
     * Deployment type in which AWS Systems Manager Documents will be executed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deployment} will
     * return {@link PostLaunchActionsDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentAsString}.
     * </p>
     * 
     * @return Deployment type in which AWS Systems Manager Documents will be executed.
     * @see PostLaunchActionsDeploymentType
     */
    public final String deploymentAsString() {
        return deployment;
    }

    /**
     * <p>
     * AWS Systems Manager Command's logs S3 log bucket.
     * </p>
     * 
     * @return AWS Systems Manager Command's logs S3 log bucket.
     */
    public final String s3LogBucket() {
        return s3LogBucket;
    }

    /**
     * <p>
     * AWS Systems Manager Command's logs S3 output key prefix.
     * </p>
     * 
     * @return AWS Systems Manager Command's logs S3 output key prefix.
     */
    public final String s3OutputKeyPrefix() {
        return s3OutputKeyPrefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the SsmDocuments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSsmDocuments() {
        return ssmDocuments != null && !(ssmDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * AWS Systems Manager Documents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSsmDocuments} method.
     * </p>
     * 
     * @return AWS Systems Manager Documents.
     */
    public final List<SsmDocument> ssmDocuments() {
        return ssmDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3LogBucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputKeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(hasSsmDocuments() ? ssmDocuments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostLaunchActions)) {
            return false;
        }
        PostLaunchActions other = (PostLaunchActions) obj;
        return Objects.equals(cloudWatchLogGroupName(), other.cloudWatchLogGroupName())
                && Objects.equals(deploymentAsString(), other.deploymentAsString())
                && Objects.equals(s3LogBucket(), other.s3LogBucket())
                && Objects.equals(s3OutputKeyPrefix(), other.s3OutputKeyPrefix()) && hasSsmDocuments() == other.hasSsmDocuments()
                && Objects.equals(ssmDocuments(), other.ssmDocuments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostLaunchActions").add("CloudWatchLogGroupName", cloudWatchLogGroupName())
                .add("Deployment", deploymentAsString()).add("S3LogBucket", s3LogBucket())
                .add("S3OutputKeyPrefix", s3OutputKeyPrefix()).add("SsmDocuments", hasSsmDocuments() ? ssmDocuments() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchLogGroupName":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupName()));
        case "deployment":
            return Optional.ofNullable(clazz.cast(deploymentAsString()));
        case "s3LogBucket":
            return Optional.ofNullable(clazz.cast(s3LogBucket()));
        case "s3OutputKeyPrefix":
            return Optional.ofNullable(clazz.cast(s3OutputKeyPrefix()));
        case "ssmDocuments":
            return Optional.ofNullable(clazz.cast(ssmDocuments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostLaunchActions, T> g) {
        return obj -> g.apply((PostLaunchActions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PostLaunchActions> {
        /**
         * <p>
         * AWS Systems Manager Command's CloudWatch log group name.
         * </p>
         * 
         * @param cloudWatchLogGroupName
         *        AWS Systems Manager Command's CloudWatch log group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupName(String cloudWatchLogGroupName);

        /**
         * <p>
         * Deployment type in which AWS Systems Manager Documents will be executed.
         * </p>
         * 
         * @param deployment
         *        Deployment type in which AWS Systems Manager Documents will be executed.
         * @see PostLaunchActionsDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostLaunchActionsDeploymentType
         */
        Builder deployment(String deployment);

        /**
         * <p>
         * Deployment type in which AWS Systems Manager Documents will be executed.
         * </p>
         * 
         * @param deployment
         *        Deployment type in which AWS Systems Manager Documents will be executed.
         * @see PostLaunchActionsDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostLaunchActionsDeploymentType
         */
        Builder deployment(PostLaunchActionsDeploymentType deployment);

        /**
         * <p>
         * AWS Systems Manager Command's logs S3 log bucket.
         * </p>
         * 
         * @param s3LogBucket
         *        AWS Systems Manager Command's logs S3 log bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3LogBucket(String s3LogBucket);

        /**
         * <p>
         * AWS Systems Manager Command's logs S3 output key prefix.
         * </p>
         * 
         * @param s3OutputKeyPrefix
         *        AWS Systems Manager Command's logs S3 output key prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputKeyPrefix(String s3OutputKeyPrefix);

        /**
         * <p>
         * AWS Systems Manager Documents.
         * </p>
         * 
         * @param ssmDocuments
         *        AWS Systems Manager Documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmDocuments(Collection<SsmDocument> ssmDocuments);

        /**
         * <p>
         * AWS Systems Manager Documents.
         * </p>
         * 
         * @param ssmDocuments
         *        AWS Systems Manager Documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmDocuments(SsmDocument... ssmDocuments);

        /**
         * <p>
         * AWS Systems Manager Documents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mgn.model.SsmDocument.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mgn.model.SsmDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mgn.model.SsmDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #ssmDocuments(List<SsmDocument>)}.
         * 
         * @param ssmDocuments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mgn.model.SsmDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmDocuments(java.util.Collection<SsmDocument>)
         */
        Builder ssmDocuments(Consumer<SsmDocument.Builder>... ssmDocuments);
    }

    static final class BuilderImpl implements Builder {
        private String cloudWatchLogGroupName;

        private String deployment;

        private String s3LogBucket;

        private String s3OutputKeyPrefix;

        private List<SsmDocument> ssmDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PostLaunchActions model) {
            cloudWatchLogGroupName(model.cloudWatchLogGroupName);
            deployment(model.deployment);
            s3LogBucket(model.s3LogBucket);
            s3OutputKeyPrefix(model.s3OutputKeyPrefix);
            ssmDocuments(model.ssmDocuments);
        }

        public final String getCloudWatchLogGroupName() {
            return cloudWatchLogGroupName;
        }

        public final void setCloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
        }

        @Override
        public final Builder cloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
            return this;
        }

        public final String getDeployment() {
            return deployment;
        }

        public final void setDeployment(String deployment) {
            this.deployment = deployment;
        }

        @Override
        public final Builder deployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        @Override
        public final Builder deployment(PostLaunchActionsDeploymentType deployment) {
            this.deployment(deployment == null ? null : deployment.toString());
            return this;
        }

        public final String getS3LogBucket() {
            return s3LogBucket;
        }

        public final void setS3LogBucket(String s3LogBucket) {
            this.s3LogBucket = s3LogBucket;
        }

        @Override
        public final Builder s3LogBucket(String s3LogBucket) {
            this.s3LogBucket = s3LogBucket;
            return this;
        }

        public final String getS3OutputKeyPrefix() {
            return s3OutputKeyPrefix;
        }

        public final void setS3OutputKeyPrefix(String s3OutputKeyPrefix) {
            this.s3OutputKeyPrefix = s3OutputKeyPrefix;
        }

        @Override
        public final Builder s3OutputKeyPrefix(String s3OutputKeyPrefix) {
            this.s3OutputKeyPrefix = s3OutputKeyPrefix;
            return this;
        }

        public final List<SsmDocument.Builder> getSsmDocuments() {
            List<SsmDocument.Builder> result = SsmDocumentsCopier.copyToBuilder(this.ssmDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSsmDocuments(Collection<SsmDocument.BuilderImpl> ssmDocuments) {
            this.ssmDocuments = SsmDocumentsCopier.copyFromBuilder(ssmDocuments);
        }

        @Override
        public final Builder ssmDocuments(Collection<SsmDocument> ssmDocuments) {
            this.ssmDocuments = SsmDocumentsCopier.copy(ssmDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ssmDocuments(SsmDocument... ssmDocuments) {
            ssmDocuments(Arrays.asList(ssmDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ssmDocuments(Consumer<SsmDocument.Builder>... ssmDocuments) {
            ssmDocuments(Stream.of(ssmDocuments).map(c -> SsmDocument.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PostLaunchActions build() {
            return new PostLaunchActions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
