/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Export task summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportTaskSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportTaskSummary.Builder, ExportTaskSummary> {
    private static final SdkField<Long> APPLICATIONS_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("applicationsCount").getter(getter(ExportTaskSummary::applicationsCount))
            .setter(setter(Builder::applicationsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationsCount").build()).build();

    private static final SdkField<Long> SERVERS_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("serversCount").getter(getter(ExportTaskSummary::serversCount)).setter(setter(Builder::serversCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serversCount").build()).build();

    private static final SdkField<Long> WAVES_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("wavesCount").getter(getter(ExportTaskSummary::wavesCount)).setter(setter(Builder::wavesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wavesCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATIONS_COUNT_FIELD,
            SERVERS_COUNT_FIELD, WAVES_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long applicationsCount;

    private final Long serversCount;

    private final Long wavesCount;

    private ExportTaskSummary(BuilderImpl builder) {
        this.applicationsCount = builder.applicationsCount;
        this.serversCount = builder.serversCount;
        this.wavesCount = builder.wavesCount;
    }

    /**
     * <p>
     * Export task summary applications count.
     * </p>
     * 
     * @return Export task summary applications count.
     */
    public final Long applicationsCount() {
        return applicationsCount;
    }

    /**
     * <p>
     * Export task summary servers count.
     * </p>
     * 
     * @return Export task summary servers count.
     */
    public final Long serversCount() {
        return serversCount;
    }

    /**
     * <p>
     * Export task summary waves count.
     * </p>
     * 
     * @return Export task summary waves count.
     */
    public final Long wavesCount() {
        return wavesCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationsCount());
        hashCode = 31 * hashCode + Objects.hashCode(serversCount());
        hashCode = 31 * hashCode + Objects.hashCode(wavesCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTaskSummary)) {
            return false;
        }
        ExportTaskSummary other = (ExportTaskSummary) obj;
        return Objects.equals(applicationsCount(), other.applicationsCount())
                && Objects.equals(serversCount(), other.serversCount()) && Objects.equals(wavesCount(), other.wavesCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportTaskSummary").add("ApplicationsCount", applicationsCount())
                .add("ServersCount", serversCount()).add("WavesCount", wavesCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationsCount":
            return Optional.ofNullable(clazz.cast(applicationsCount()));
        case "serversCount":
            return Optional.ofNullable(clazz.cast(serversCount()));
        case "wavesCount":
            return Optional.ofNullable(clazz.cast(wavesCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportTaskSummary, T> g) {
        return obj -> g.apply((ExportTaskSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportTaskSummary> {
        /**
         * <p>
         * Export task summary applications count.
         * </p>
         * 
         * @param applicationsCount
         *        Export task summary applications count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationsCount(Long applicationsCount);

        /**
         * <p>
         * Export task summary servers count.
         * </p>
         * 
         * @param serversCount
         *        Export task summary servers count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serversCount(Long serversCount);

        /**
         * <p>
         * Export task summary waves count.
         * </p>
         * 
         * @param wavesCount
         *        Export task summary waves count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wavesCount(Long wavesCount);
    }

    static final class BuilderImpl implements Builder {
        private Long applicationsCount;

        private Long serversCount;

        private Long wavesCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTaskSummary model) {
            applicationsCount(model.applicationsCount);
            serversCount(model.serversCount);
            wavesCount(model.wavesCount);
        }

        public final Long getApplicationsCount() {
            return applicationsCount;
        }

        public final void setApplicationsCount(Long applicationsCount) {
            this.applicationsCount = applicationsCount;
        }

        @Override
        public final Builder applicationsCount(Long applicationsCount) {
            this.applicationsCount = applicationsCount;
            return this;
        }

        public final Long getServersCount() {
            return serversCount;
        }

        public final void setServersCount(Long serversCount) {
            this.serversCount = serversCount;
        }

        @Override
        public final Builder serversCount(Long serversCount) {
            this.serversCount = serversCount;
            return this;
        }

        public final Long getWavesCount() {
            return wavesCount;
        }

        public final void setWavesCount(Long wavesCount) {
            this.wavesCount = wavesCount;
        }

        @Override
        public final Builder wavesCount(Long wavesCount) {
            this.wavesCount = wavesCount;
            return this;
        }

        @Override
        public ExportTaskSummary build() {
            return new ExportTaskSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
