/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.MgnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveSourceServerActionRequest
extends MgnRequest
implements ToCopyableBuilder<Builder, RemoveSourceServerActionRequest> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionID").getter(RemoveSourceServerActionRequest.getter(RemoveSourceServerActionRequest::actionID)).setter(RemoveSourceServerActionRequest.setter(Builder::actionID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionID").build()}).build();
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(RemoveSourceServerActionRequest.getter(RemoveSourceServerActionRequest::sourceServerID)).setter(RemoveSourceServerActionRequest.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, SOURCE_SERVER_ID_FIELD));
    private final String actionID;
    private final String sourceServerID;

    private RemoveSourceServerActionRequest(BuilderImpl builder) {
        super(builder);
        this.actionID = builder.actionID;
        this.sourceServerID = builder.sourceServerID;
    }

    public final String actionID() {
        return this.actionID;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionID());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveSourceServerActionRequest)) {
            return false;
        }
        RemoveSourceServerActionRequest other = (RemoveSourceServerActionRequest)((Object)obj);
        return Objects.equals(this.actionID(), other.actionID()) && Objects.equals(this.sourceServerID(), other.sourceServerID());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveSourceServerActionRequest").add("ActionID", (Object)this.actionID()).add("SourceServerID", (Object)this.sourceServerID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionID": {
                return Optional.ofNullable(clazz.cast(this.actionID()));
            }
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveSourceServerActionRequest, T> g) {
        return obj -> g.apply((RemoveSourceServerActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnRequest.BuilderImpl
    implements Builder {
        private String actionID;
        private String sourceServerID;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveSourceServerActionRequest model) {
            super(model);
            this.actionID(model.actionID);
            this.sourceServerID(model.sourceServerID);
        }

        public final String getActionID() {
            return this.actionID;
        }

        public final void setActionID(String actionID) {
            this.actionID = actionID;
        }

        @Override
        public final Builder actionID(String actionID) {
            this.actionID = actionID;
            return this;
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveSourceServerActionRequest build() {
            return new RemoveSourceServerActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MgnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveSourceServerActionRequest> {
        public Builder actionID(String var1);

        public Builder sourceServerID(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

