/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.BootMode;
import software.amazon.awssdk.services.mgn.model.LaunchDisposition;
import software.amazon.awssdk.services.mgn.model.Licensing;
import software.amazon.awssdk.services.mgn.model.MgnRequest;
import software.amazon.awssdk.services.mgn.model.TargetInstanceTypeRightSizingMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLaunchConfigurationRequest
extends MgnRequest
implements ToCopyableBuilder<Builder, UpdateLaunchConfigurationRequest> {
    private static final SdkField<String> BOOT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bootMode").getter(UpdateLaunchConfigurationRequest.getter(UpdateLaunchConfigurationRequest::bootModeAsString)).setter(UpdateLaunchConfigurationRequest.setter(Builder::bootMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootMode").build()}).build();
    private static final SdkField<Boolean> COPY_PRIVATE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("copyPrivateIp").getter(UpdateLaunchConfigurationRequest.getter(UpdateLaunchConfigurationRequest::copyPrivateIp)).setter(UpdateLaunchConfigurationRequest.setter(Builder::copyPrivateIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyPrivateIp").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("copyTags").getter(UpdateLaunchConfigurationRequest.getter(UpdateLaunchConfigurationRequest::copyTags)).setter(UpdateLaunchConfigurationRequest.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTags").build()}).build();
    private static final SdkField<String> LAUNCH_DISPOSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchDisposition").getter(UpdateLaunchConfigurationRequest.getter(UpdateLaunchConfigurationRequest::launchDispositionAsString)).setter(UpdateLaunchConfigurationRequest.setter(Builder::launchDisposition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDisposition").build()}).build();
    private static final SdkField<Licensing> LICENSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("licensing").getter(UpdateLaunchConfigurationRequest.getter(UpdateLaunchConfigurationRequest::licensing)).setter(UpdateLaunchConfigurationRequest.setter(Builder::licensing)).constructor(Licensing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licensing").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateLaunchConfigurationRequest.getter(UpdateLaunchConfigurationRequest::name)).setter(UpdateLaunchConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(UpdateLaunchConfigurationRequest.getter(UpdateLaunchConfigurationRequest::sourceServerID)).setter(UpdateLaunchConfigurationRequest.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final SdkField<String> TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetInstanceTypeRightSizingMethod").getter(UpdateLaunchConfigurationRequest.getter(UpdateLaunchConfigurationRequest::targetInstanceTypeRightSizingMethodAsString)).setter(UpdateLaunchConfigurationRequest.setter(Builder::targetInstanceTypeRightSizingMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstanceTypeRightSizingMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOT_MODE_FIELD, COPY_PRIVATE_IP_FIELD, COPY_TAGS_FIELD, LAUNCH_DISPOSITION_FIELD, LICENSING_FIELD, NAME_FIELD, SOURCE_SERVER_ID_FIELD, TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD));
    private final String bootMode;
    private final Boolean copyPrivateIp;
    private final Boolean copyTags;
    private final String launchDisposition;
    private final Licensing licensing;
    private final String name;
    private final String sourceServerID;
    private final String targetInstanceTypeRightSizingMethod;

    private UpdateLaunchConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.bootMode = builder.bootMode;
        this.copyPrivateIp = builder.copyPrivateIp;
        this.copyTags = builder.copyTags;
        this.launchDisposition = builder.launchDisposition;
        this.licensing = builder.licensing;
        this.name = builder.name;
        this.sourceServerID = builder.sourceServerID;
        this.targetInstanceTypeRightSizingMethod = builder.targetInstanceTypeRightSizingMethod;
    }

    public final BootMode bootMode() {
        return BootMode.fromValue(this.bootMode);
    }

    public final String bootModeAsString() {
        return this.bootMode;
    }

    public final Boolean copyPrivateIp() {
        return this.copyPrivateIp;
    }

    public final Boolean copyTags() {
        return this.copyTags;
    }

    public final LaunchDisposition launchDisposition() {
        return LaunchDisposition.fromValue(this.launchDisposition);
    }

    public final String launchDispositionAsString() {
        return this.launchDisposition;
    }

    public final Licensing licensing() {
        return this.licensing;
    }

    public final String name() {
        return this.name;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    public final TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod() {
        return TargetInstanceTypeRightSizingMethod.fromValue(this.targetInstanceTypeRightSizingMethod);
    }

    public final String targetInstanceTypeRightSizingMethodAsString() {
        return this.targetInstanceTypeRightSizingMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyPrivateIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licensing());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetInstanceTypeRightSizingMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLaunchConfigurationRequest)) {
            return false;
        }
        UpdateLaunchConfigurationRequest other = (UpdateLaunchConfigurationRequest)((Object)obj);
        return Objects.equals(this.bootModeAsString(), other.bootModeAsString()) && Objects.equals(this.copyPrivateIp(), other.copyPrivateIp()) && Objects.equals(this.copyTags(), other.copyTags()) && Objects.equals(this.launchDispositionAsString(), other.launchDispositionAsString()) && Objects.equals(this.licensing(), other.licensing()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sourceServerID(), other.sourceServerID()) && Objects.equals(this.targetInstanceTypeRightSizingMethodAsString(), other.targetInstanceTypeRightSizingMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLaunchConfigurationRequest").add("BootMode", (Object)this.bootModeAsString()).add("CopyPrivateIp", (Object)this.copyPrivateIp()).add("CopyTags", (Object)this.copyTags()).add("LaunchDisposition", (Object)this.launchDispositionAsString()).add("Licensing", (Object)this.licensing()).add("Name", (Object)this.name()).add("SourceServerID", (Object)this.sourceServerID()).add("TargetInstanceTypeRightSizingMethod", (Object)this.targetInstanceTypeRightSizingMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bootMode": {
                return Optional.ofNullable(clazz.cast(this.bootModeAsString()));
            }
            case "copyPrivateIp": {
                return Optional.ofNullable(clazz.cast(this.copyPrivateIp()));
            }
            case "copyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "launchDisposition": {
                return Optional.ofNullable(clazz.cast(this.launchDispositionAsString()));
            }
            case "licensing": {
                return Optional.ofNullable(clazz.cast(this.licensing()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
            case "targetInstanceTypeRightSizingMethod": {
                return Optional.ofNullable(clazz.cast(this.targetInstanceTypeRightSizingMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLaunchConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateLaunchConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnRequest.BuilderImpl
    implements Builder {
        private String bootMode;
        private Boolean copyPrivateIp;
        private Boolean copyTags;
        private String launchDisposition;
        private Licensing licensing;
        private String name;
        private String sourceServerID;
        private String targetInstanceTypeRightSizingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLaunchConfigurationRequest model) {
            super(model);
            this.bootMode(model.bootMode);
            this.copyPrivateIp(model.copyPrivateIp);
            this.copyTags(model.copyTags);
            this.launchDisposition(model.launchDisposition);
            this.licensing(model.licensing);
            this.name(model.name);
            this.sourceServerID(model.sourceServerID);
            this.targetInstanceTypeRightSizingMethod(model.targetInstanceTypeRightSizingMethod);
        }

        public final String getBootMode() {
            return this.bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        @Transient
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        @Transient
        public final Builder bootMode(BootMode bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        public final Boolean getCopyPrivateIp() {
            return this.copyPrivateIp;
        }

        public final void setCopyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
        }

        @Override
        @Transient
        public final Builder copyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
            return this;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        @Transient
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final String getLaunchDisposition() {
            return this.launchDisposition;
        }

        public final void setLaunchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
        }

        @Override
        @Transient
        public final Builder launchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
            return this;
        }

        @Override
        @Transient
        public final Builder launchDisposition(LaunchDisposition launchDisposition) {
            this.launchDisposition(launchDisposition == null ? null : launchDisposition.toString());
            return this;
        }

        public final Licensing.Builder getLicensing() {
            return this.licensing != null ? this.licensing.toBuilder() : null;
        }

        public final void setLicensing(Licensing.BuilderImpl licensing) {
            this.licensing = licensing != null ? licensing.build() : null;
        }

        @Override
        @Transient
        public final Builder licensing(Licensing licensing) {
            this.licensing = licensing;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        @Transient
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final String getTargetInstanceTypeRightSizingMethod() {
            return this.targetInstanceTypeRightSizingMethod;
        }

        public final void setTargetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
        }

        @Override
        @Transient
        public final Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod(targetInstanceTypeRightSizingMethod == null ? null : targetInstanceTypeRightSizingMethod.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLaunchConfigurationRequest build() {
            return new UpdateLaunchConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MgnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLaunchConfigurationRequest> {
        public Builder bootMode(String var1);

        public Builder bootMode(BootMode var1);

        public Builder copyPrivateIp(Boolean var1);

        public Builder copyTags(Boolean var1);

        public Builder launchDisposition(String var1);

        public Builder launchDisposition(LaunchDisposition var1);

        public Builder licensing(Licensing var1);

        default public Builder licensing(Consumer<Licensing.Builder> licensing) {
            return this.licensing((Licensing)((Licensing.Builder)Licensing.builder().applyMutation(licensing)).build());
        }

        public Builder name(String var1);

        public Builder sourceServerID(String var1);

        public Builder targetInstanceTypeRightSizingMethod(String var1);

        public Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

