/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.InitiatedBy;
import software.amazon.awssdk.services.mgn.model.JobStatus;
import software.amazon.awssdk.services.mgn.model.JobType;
import software.amazon.awssdk.services.mgn.model.ParticipatingServer;
import software.amazon.awssdk.services.mgn.model.ParticipatingServersCopier;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Job
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Job> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Job.getter(Job::arn)).setter(Job.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creationDateTime").getter(Job.getter(Job::creationDateTime)).setter(Job.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<String> END_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endDateTime").getter(Job.getter(Job::endDateTime)).setter(Job.setter(Builder::endDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()}).build();
    private static final SdkField<String> INITIATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("initiatedBy").getter(Job.getter(Job::initiatedByAsString)).setter(Job.setter(Builder::initiatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiatedBy").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobID").getter(Job.getter(Job::jobID)).setter(Job.setter(Builder::jobID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobID").build()}).build();
    private static final SdkField<List<ParticipatingServer>> PARTICIPATING_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("participatingServers").getter(Job.getter(Job::participatingServers)).setter(Job.setter(Builder::participatingServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participatingServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParticipatingServer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Job.getter(Job::statusAsString)).setter(Job.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Job.getter(Job::tags)).setter(Job.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Job.getter(Job::typeAsString)).setter(Job.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_DATE_TIME_FIELD, END_DATE_TIME_FIELD, INITIATED_BY_FIELD, JOB_ID_FIELD, PARTICIPATING_SERVERS_FIELD, STATUS_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String creationDateTime;
    private final String endDateTime;
    private final String initiatedBy;
    private final String jobID;
    private final List<ParticipatingServer> participatingServers;
    private final String status;
    private final Map<String, String> tags;
    private final String type;

    private Job(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationDateTime = builder.creationDateTime;
        this.endDateTime = builder.endDateTime;
        this.initiatedBy = builder.initiatedBy;
        this.jobID = builder.jobID;
        this.participatingServers = builder.participatingServers;
        this.status = builder.status;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final String creationDateTime() {
        return this.creationDateTime;
    }

    public final String endDateTime() {
        return this.endDateTime;
    }

    public final InitiatedBy initiatedBy() {
        return InitiatedBy.fromValue(this.initiatedBy);
    }

    public final String initiatedByAsString() {
        return this.initiatedBy;
    }

    public final String jobID() {
        return this.jobID;
    }

    public final boolean hasParticipatingServers() {
        return this.participatingServers != null && !(this.participatingServers instanceof SdkAutoConstructList);
    }

    public final List<ParticipatingServer> participatingServers() {
        return this.participatingServers;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final JobType type() {
        return JobType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiatedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobID());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParticipatingServers() ? this.participatingServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime()) && Objects.equals(this.initiatedByAsString(), other.initiatedByAsString()) && Objects.equals(this.jobID(), other.jobID()) && this.hasParticipatingServers() == other.hasParticipatingServers() && Objects.equals(this.participatingServers(), other.participatingServers()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Job").add("Arn", (Object)this.arn()).add("CreationDateTime", (Object)this.creationDateTime()).add("EndDateTime", (Object)this.endDateTime()).add("InitiatedBy", (Object)this.initiatedByAsString()).add("JobID", (Object)this.jobID()).add("ParticipatingServers", this.hasParticipatingServers() ? this.participatingServers() : null).add("Status", (Object)this.statusAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "endDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
            case "initiatedBy": {
                return Optional.ofNullable(clazz.cast(this.initiatedByAsString()));
            }
            case "jobID": {
                return Optional.ofNullable(clazz.cast(this.jobID()));
            }
            case "participatingServers": {
                return Optional.ofNullable(clazz.cast(this.participatingServers()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String creationDateTime;
        private String endDateTime;
        private String initiatedBy;
        private String jobID;
        private List<ParticipatingServer> participatingServers = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            this.arn(model.arn);
            this.creationDateTime(model.creationDateTime);
            this.endDateTime(model.endDateTime);
            this.initiatedBy(model.initiatedBy);
            this.jobID(model.jobID);
            this.participatingServers(model.participatingServers);
            this.status(model.status);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final String getEndDateTime() {
            return this.endDateTime;
        }

        @Override
        public final Builder endDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final void setEndDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
        }

        public final String getInitiatedBy() {
            return this.initiatedBy;
        }

        @Override
        public final Builder initiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
            return this;
        }

        @Override
        public final Builder initiatedBy(InitiatedBy initiatedBy) {
            this.initiatedBy(initiatedBy == null ? null : initiatedBy.toString());
            return this;
        }

        public final void setInitiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
        }

        public final String getJobID() {
            return this.jobID;
        }

        @Override
        public final Builder jobID(String jobID) {
            this.jobID = jobID;
            return this;
        }

        public final void setJobID(String jobID) {
            this.jobID = jobID;
        }

        public final Collection<ParticipatingServer.Builder> getParticipatingServers() {
            if (this.participatingServers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.participatingServers != null ? (Collection)this.participatingServers.stream().map(ParticipatingServer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder participatingServers(Collection<ParticipatingServer> participatingServers) {
            this.participatingServers = ParticipatingServersCopier.copy(participatingServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participatingServers(ParticipatingServer ... participatingServers) {
            this.participatingServers(Arrays.asList(participatingServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participatingServers(Consumer<ParticipatingServer.Builder> ... participatingServers) {
            this.participatingServers(Stream.of(participatingServers).map(c -> (ParticipatingServer)((ParticipatingServer.Builder)ParticipatingServer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParticipatingServers(Collection<ParticipatingServer.BuilderImpl> participatingServers) {
            this.participatingServers = ParticipatingServersCopier.copyFromBuilder(participatingServers);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JobType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public Job build() {
            return new Job(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Job> {
        public Builder arn(String var1);

        public Builder creationDateTime(String var1);

        public Builder endDateTime(String var1);

        public Builder initiatedBy(String var1);

        public Builder initiatedBy(InitiatedBy var1);

        public Builder jobID(String var1);

        public Builder participatingServers(Collection<ParticipatingServer> var1);

        public Builder participatingServers(ParticipatingServer ... var1);

        public Builder participatingServers(Consumer<ParticipatingServer.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(JobType var1);
    }
}

